/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.impl.internal.notifications.ManagerNotification;
import org.mule.impl.internal.notifications.ManagerNotificationListener;
import org.mule.impl.internal.notifications.NotificationException;
import org.mule.umo.manager.UMOServerNotification;

public class JmxRegistrationContext {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private static final ThreadLocal contexts = new ThreadLocal();
    private String resolvedDomain;

    protected JmxRegistrationContext() {
        if (!MuleManager.isInstanciated()) {
            return;
        }
        try {
            MuleManager.getInstance().registerListener(new ManagerNotificationListener(){

                public void onNotification(UMOServerNotification notification) {
                    ManagerNotification mn = (ManagerNotification)notification;
                    if (108 == mn.getAction()) {
                        JmxRegistrationContext.this.resolvedDomain = null;
                        contexts.set(null);
                    }
                }
            });
        }
        catch (NotificationException e) {
            this.logger.warn((Object)"Did not cleanup properly.", (Throwable)e);
        }
    }

    public static JmxRegistrationContext getCurrent() {
        JmxRegistrationContext ctx = (JmxRegistrationContext)contexts.get();
        if (ctx == null) {
            ctx = new JmxRegistrationContext();
        }
        contexts.set(ctx);
        return ctx;
    }

    public String getResolvedDomain() {
        return this.resolvedDomain;
    }

    public void setResolvedDomain(String resolvedDomain) {
        this.resolvedDomain = resolvedDomain;
    }
}

