/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.xml;

import java.io.OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.mule.transformers.AbstractTransformer;
import org.mule.umo.transformer.TransformerException;
import org.mule.util.StringUtils;

public class XmlPrettyPrinter
extends AbstractTransformer {
    protected OutputFormat outputFormat = OutputFormat.createPrettyPrint();

    public XmlPrettyPrinter() {
        this.registerSourceType(String.class);
        this.registerSourceType(Document.class);
        this.setReturnClass(String.class);
    }

    public synchronized OutputFormat getOutputFormat() {
        return this.outputFormat;
    }

    protected Object doTransform(Object src, String encoding) throws TransformerException {
        try {
            ByteArrayOutputStream resultStream = new ByteArrayOutputStream();
            Document document = null;
            if (src instanceof String) {
                String text = (String)src;
                document = DocumentHelper.parseText((String)text);
            } else if (src instanceof Document) {
                document = (Document)src;
            }
            XMLWriter writer = new XMLWriter((OutputStream)resultStream, this.getOutputFormat());
            writer.write(document);
            writer.close();
            return resultStream.toString(encoding);
        }
        catch (Exception e) {
            throw new TransformerException(this, (Throwable)e);
        }
    }

    public synchronized String getEncoding() {
        return this.outputFormat.getEncoding();
    }

    public synchronized void setEncoding(String encoding) {
        this.outputFormat.setEncoding(encoding);
    }

    public synchronized boolean getIndentEnabled() {
        return this.outputFormat.getIndent() != null;
    }

    public synchronized void setIndentEnabled(boolean doIndent) {
        this.outputFormat.setIndent(doIndent);
    }

    public synchronized String getIndentString() {
        return this.outputFormat.getIndent();
    }

    public synchronized void setIndentString(String indentString) {
        this.outputFormat.setIndent(indentString);
    }

    public synchronized int getIndentSize() {
        return StringUtils.defaultIfEmpty(this.outputFormat.getIndent(), "").length();
    }

    public synchronized void setIndentSize(int indentSize) {
        this.outputFormat.setIndentSize(indentSize);
    }

    public synchronized String getLineSeparator() {
        return this.outputFormat.getLineSeparator();
    }

    public synchronized void setLineSeparator(String separator) {
        this.outputFormat.setLineSeparator(separator);
    }

    public synchronized int getNewLineAfterNTags() {
        return this.outputFormat.getNewLineAfterNTags();
    }

    public synchronized void setNewLineAfterNTags(int tagCount) {
        this.outputFormat.setNewLineAfterNTags(tagCount);
    }

    public synchronized boolean isExpandEmptyElements() {
        return this.outputFormat.isExpandEmptyElements();
    }

    public synchronized void setExpandEmptyElements(boolean expandEmptyElements) {
        this.outputFormat.setExpandEmptyElements(expandEmptyElements);
    }

    public synchronized boolean isNewlines() {
        return this.outputFormat.isNewlines();
    }

    public synchronized void setNewlines(boolean newlines) {
        this.outputFormat.setNewlines(newlines);
    }

    public synchronized boolean isOmitEncoding() {
        return this.outputFormat.isOmitEncoding();
    }

    public synchronized void setOmitEncoding(boolean omitEncoding) {
        this.outputFormat.setOmitEncoding(omitEncoding);
    }

    public synchronized boolean isPadText() {
        return this.outputFormat.isPadText();
    }

    public synchronized void setPadText(boolean padText) {
        this.outputFormat.setPadText(padText);
    }

    public synchronized boolean isSuppressDeclaration() {
        return this.outputFormat.isSuppressDeclaration();
    }

    public synchronized void setSuppressDeclaration(boolean suppressDeclaration) {
        this.outputFormat.setSuppressDeclaration(suppressDeclaration);
    }

    public synchronized boolean isTrimText() {
        return this.outputFormat.isTrimText();
    }

    public synchronized void setTrimText(boolean trimText) {
        this.outputFormat.setTrimText(trimText);
    }

    public synchronized boolean isXHTML() {
        return this.outputFormat.isXHTML();
    }

    public synchronized void setXHTML(boolean xhtml) {
        this.outputFormat.setXHTML(xhtml);
    }
}

