/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.outers;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineOutput;
import org.ow2.jasmine.probe.JasmineProbeResult;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.outer.JasmineOuter;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public abstract class JOuter
extends Thread
implements JasmineOuter {
    protected Log logger = LogFactory.getLog(JOuter.class);
    private LinkedList<JasmineProbeResult> dataqueue = new LinkedList();
    protected static final String SEPARATOR = ";";
    protected JasmineOutput output;
    private boolean valid = true;
    private boolean waiting = false;
    private long outerTimeout = 10000L;
    protected SimpleDateFormat dateformat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private boolean removed = false;

    public abstract void processData(JasmineProbeResult var1);

    public JOuter(JasmineOutput output) {
        super("JasmineOuter-" + output.getName());
        this.output = output;
    }

    public JasmineOutput getOutput() {
        return this.output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.valid) {
            JasmineProbeResult data = null;
            JOuter jOuter = this;
            synchronized (jOuter) {
                if (this.dataqueue.isEmpty()) {
                    try {
                        this.waiting = true;
                        this.wait(this.outerTimeout);
                        this.waiting = false;
                    }
                    catch (InterruptedException e) {
                        this.logger.warn((Object)(this.getName() + ": outer interrupted"), new Object[]{e});
                    }
                    catch (Exception e) {
                        this.logger.warn((Object)(this.getName() + ": outer exception"), new Object[]{e});
                    }
                }
                try {
                    data = this.dataqueue.removeFirst();
                }
                catch (NoSuchElementException e) {
                    data = null;
                }
            }
            if (data == null) continue;
            this.processData(data);
        }
    }

    public synchronized void stopIt() {
        this.valid = false;
        this.notify();
    }

    public void flushData() {
    }

    public String composeName(JasmineIndicatorValue jiv, String jsrName) {
        StringBuffer name = new StringBuffer(jiv.getName());
        if (jiv.isMultiValue() && jsrName != null && jsrName.length() != 0) {
            name.append(".");
            name.append(jsrName);
        }
        return name.toString();
    }

    public String findMbean(JasmineSingleResult jsr) {
        String mbean = null;
        HashMap resultProps = jsr.getProperties();
        if (!resultProps.isEmpty()) {
            for (String key : resultProps.keySet()) {
                if (!"mbean".equals(key)) continue;
                mbean = (String)resultProps.get(key);
            }
        }
        if (mbean == null) {
            mbean = "misc:type=unknown";
        }
        return mbean;
    }

    public String getOutputName() {
        return this.getOutput().getName();
    }

    public synchronized void publishData(JasmineProbeResult result) {
        this.logger.debug((Object)"", new Object[0]);
        this.dataqueue.addLast(result);
        if (this.waiting) {
            this.notify();
        }
    }

    protected String outputProps(String output, HashMap<String, String> props, String separator) {
        String result = output;
        for (String key : props.keySet()) {
            if (result.length() > 0) {
                result = result + separator;
            }
            result = result + key + "=" + props.get(key);
        }
        return result;
    }

    public void remove() {
        this.logger.debug((Object)("Mark removed " + this.getName()), new Object[0]);
        this.removed = true;
    }

    public boolean isRemoved() {
        return this.removed;
    }
}

