/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.lewys.internal;

import java.util.Map;
import org.objectweb.lewys.common.exceptions.NoResourceToProbeException;
import org.objectweb.lewys.common.exceptions.NoSuchResourceException;
import org.objectweb.lewys.common.exceptions.ProbeException;
import org.objectweb.lewys.probe.Probe;
import org.objectweb.lewys.probe.linux.DiskProbe;
import org.objectweb.lewys.probe.linux.KernelProbe;
import org.objectweb.lewys.probe.linux.Linux2_6DiskProbe;
import org.objectweb.lewys.probe.linux.Linux2_6MemoryProbe;
import org.objectweb.lewys.probe.linux.NetworkProbe;
import org.objectweb.lewys.probe.windows.CpuProbe;
import org.objectweb.lewys.probe.windows.MemoryProbe;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineSingleNumberResult;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.jasmine.probe.collectors.JCollector;
import org.ow2.jasmine.probe.util.CsvConverter;

public class LewysCollector
extends JCollector {
    protected String cmd;
    protected Probe probe = null;
    protected String[] resources = null;
    protected int[] rids = null;

    public LewysCollector(String name, JasmineIndicator indicator, int period, int ostype) {
        super(name, indicator, period);
        Map props = indicator.getProperties();
        this.cmd = (String)props.get("cmd");
        if (this.cmd.equals("disk")) {
            try {
                switch (ostype) {
                    case 10: {
                        this.probe = new DiskProbe();
                        break;
                    }
                    case 11: {
                        this.probe = new Linux2_6DiskProbe();
                        break;
                    }
                    case 20: {
                        this.probe = new org.objectweb.lewys.probe.windows.DiskProbe();
                        break;
                    }
                    case 30: {
                        this.probe = new org.objectweb.lewys.probe.macosx.DiskProbe();
                        break;
                    }
                    default: {
                        throw new RuntimeException("No DiskProbe available for " + System.getProperty("os.name"));
                    }
                }
            }
            catch (NoResourceToProbeException ex) {
                throw new RuntimeException("Can't set Disk probe", ex);
            }
        } else if (this.cmd.equals("memory")) {
            try {
                switch (ostype) {
                    case 10: {
                        this.probe = new org.objectweb.lewys.probe.linux.MemoryProbe();
                        break;
                    }
                    case 11: {
                        this.probe = new Linux2_6MemoryProbe();
                        break;
                    }
                    case 20: {
                        this.probe = new MemoryProbe();
                        break;
                    }
                    case 30: {
                        this.probe = new org.objectweb.lewys.probe.macosx.MemoryProbe();
                        break;
                    }
                    default: {
                        throw new RuntimeException("No Memory probe available for " + System.getProperty("os.name"));
                    }
                }
            }
            catch (NoResourceToProbeException ex) {
                throw new RuntimeException("Can't set Memory probe", ex);
            }
        } else if (this.cmd.equals("network")) {
            try {
                switch (ostype) {
                    case 10: 
                    case 11: {
                        this.probe = new NetworkProbe();
                        break;
                    }
                    case 20: {
                        this.probe = new org.objectweb.lewys.probe.windows.NetworkProbe();
                        break;
                    }
                    case 30: {
                        this.probe = new org.objectweb.lewys.probe.macosx.NetworkProbe();
                        break;
                    }
                    default: {
                        throw new RuntimeException("No Network probe available for " + System.getProperty("os.name"));
                    }
                }
            }
            catch (NoResourceToProbeException ex) {
                throw new RuntimeException("Can't set Network probe", ex);
            }
        } else if (this.cmd.equals("cpu")) {
            try {
                switch (ostype) {
                    case 10: 
                    case 11: {
                        this.probe = new org.objectweb.lewys.probe.linux.CpuProbe();
                        break;
                    }
                    case 20: {
                        this.probe = new CpuProbe();
                        break;
                    }
                    case 30: {
                        this.probe = new org.objectweb.lewys.probe.macosx.CpuProbe();
                        break;
                    }
                    default: {
                        throw new RuntimeException("No Cpu probe available for " + System.getProperty("os.name"));
                    }
                }
            }
            catch (NoResourceToProbeException ex) {
                throw new RuntimeException("Can't set Cpu probe", ex);
            }
        } else if (this.cmd.equals("kernel")) {
            try {
                switch (ostype) {
                    case 10: 
                    case 11: {
                        this.probe = new KernelProbe();
                        break;
                    }
                    case 20: {
                        this.probe = new org.objectweb.lewys.probe.windows.KernelProbe();
                        break;
                    }
                    default: {
                        throw new RuntimeException("No Kernel probe available for " + System.getProperty("os.name"));
                    }
                }
            }
            catch (NoResourceToProbeException ex) {
                throw new RuntimeException("Can't set Kernel probe", ex);
            }
        } else {
            this.logger.warn((Object)("LeWYS command not supported: " + this.cmd), new Object[0]);
        }
        this.resources = CsvConverter.csv2array((String)((String)props.get("resources")));
        this.rids = new int[this.resources.length];
        for (int i = 0; i < this.resources.length; ++i) {
            try {
                int id = this.probe.getResourceId(this.resources[i]);
                this.rids[i++] = id;
                continue;
            }
            catch (NoSuchResourceException e) {
                this.logger.warn((Object)("This resource is not supported by LeWYS: " + this.resources[i]), new Object[0]);
            }
        }
    }

    public JasmineIndicatorValue getLastResult() throws JasmineCollectorException {
        this.logger.debug((Object)"", new Object[0]);
        long[] values = null;
        try {
            values = this.probe.getValue(this.rids);
        }
        catch (ProbeException e) {
            this.logger.error((Object)("Cannot get Probe values: " + (Object)((Object)e)), new Object[0]);
            throw new JasmineCollectorException("Cannot get Probe values");
        }
        catch (NoSuchResourceException e) {
            this.logger.error((Object)("Cannot get Probe values: " + (Object)((Object)e)), new Object[0]);
            throw new JasmineCollectorException("Cannot get Probe values: Unknown Resource");
        }
        if (values == null) {
            return null;
        }
        long time = System.currentTimeMillis();
        JasmineIndicatorValue jiv = new JasmineIndicatorValue();
        jiv.setName(this.indicator.getName());
        jiv.addMetadata("cmd", this.cmd);
        jiv.addMetadata("server", this.getServerName());
        jiv.addMetadata("domain", this.getDomainName());
        if (this.hostName != null) {
            jiv.setTarget(this.hostName);
        } else {
            jiv.setTarget(this.getServerName());
        }
        for (int i = 0; i < values.length; ++i) {
            if (this.indicator.getScale() != 1) {
                values[i] = values[i] / (long)this.indicator.getScale();
            }
            JasmineSingleNumberResult jsr = new JasmineSingleNumberResult();
            jsr.setName(this.resources[i]);
            jsr.setValue((Object)values[i]);
            jsr.setTimestamp(time);
            jsr.addProperty("resource", this.resources[i]);
            jiv.addValue((JasmineSingleResult)jsr);
        }
        if (this.resources.length == 1) {
            jiv.setMultiValue(false);
        }
        return jiv;
    }

    public void stopPolling() {
        this.logger.debug((Object)("Stop " + this.indicator.getName() + " in probe " + this.probeId), new Object[0]);
    }

    public void startPolling() {
        this.logger.debug((Object)("Start " + this.indicator.getName() + " in probe " + this.probeId), new Object[0]);
    }
}

