@Echo off

Rem   ---------------------------------------------------------------------------
Rem   JASMINe
Rem   Copyright (C) 2011-2012 Bull S.A.S.
Rem   Contact: jasmine@ow2.org
Rem
Rem   This library is free software; you can redistribute it and/or
Rem   modify it under the terms of the GNU Lesser General Public
Rem   License as published by the Free Software Foundation; either
Rem   version 2.1 of the License, or any later version.
Rem
Rem   This library is distributed in the hope that it will be useful,
Rem   but WITHOUT ANY WARRANTY; without even the implied warranty of
Rem   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Rem   Lesser General Public License for more details.
Rem
Rem   You should have received a copy of the GNU Lesser General Public
Rem   License along with this library; if not, write to the Free Software
Rem   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
Rem   USA
Rem   ---------------------------------------------------------------------------
Rem   $Id: jasmine-probe.bat 9814 2012-02-09 14:01:47Z jlegrand $
Rem   ---------------------------------------------------------------------------

Rem Test JONAS_ROOT and JONAS_BASE

set JONAS_ROOT=%JPROBE_ROOT%

if ["%JONAS_ROOT%"]==[""] goto set_jonas_root
goto :args

:set_jonas_root
  echo Check that JPROBE_ROOT is set
goto :EOF

Rem ---------------------------------------------
Rem Get args
Rem ---------------------------------------------
:args

set JONAS_BASE=%JONAS_ROOT%
set PATH=%JONAS_ROOT%\bin;%PATH%

if [%1]==[]   goto no_arg
set ARGS=
set COMMAND=
:loop_on_args
set VALUE=%~1
if [%1]==["start"]     goto command_arg
if [%1]==["stop"]      goto command_arg
set ARGS=%ARGS% %1
goto next_arg

Rem set ARGS=%ARGS% -Dhttp.proxyHost=
Rem set ARGS=%ARGS% -Dhttp.proxyPort=8080
Rem set ARGS=%ARGS% -Dhttp.nonProxyHosts="localhost|127.0.0.1"

echo %ARGS%

:command_arg
set COMMAND=%1
goto :next_arg

:next_arg
shift
if not ["%1"]==[""] goto loop_on_args

if [%COMMAND%]==["start"] goto start
if [%COMMAND%]==["stop"]  goto stop
if [%COMMAND%]==[""]      goto no_arg

:start
jonas start -n jasmine-probe -clean -Djava.net.preferIPv4Stack=true %ARGS%
goto :EOF

:stop
jonas stop -n jasmine-probe %ARGS%
goto :EOF

:no_arg
echo No arguments specified.
echo "jasmine-probe start|stop [OPTIONS]"
