/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployablemonitor;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.ow2.jonas.deployablemonitor.SortableFileDeployable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortableFileDeployableComparator
implements Comparator<SortableFileDeployable> {
    private List<String> orderedDeployables = new ArrayList<String>();

    public void setOrderedDeployables(List<String> orderedDeployables) {
        this.orderedDeployables = orderedDeployables;
    }

    private int index(SortableFileDeployable sortableFileDeployable) {
        if (sortableFileDeployable == null) {
            return Integer.MAX_VALUE;
        }
        String deployableClassName = sortableFileDeployable.getDeployable().getClass().getName();
        int index = this.orderedDeployables.indexOf(deployableClassName);
        if (index == -1) {
            int i;
            boolean found = false;
            for (i = 0; i < this.orderedDeployables.size() && !found; ++i) {
                String name = this.orderedDeployables.get(i);
                if (!deployableClassName.toLowerCase().contains(name.toLowerCase())) continue;
                found = true;
                break;
            }
            index = !found ? Integer.MAX_VALUE : i;
        }
        return index;
    }

    @Override
    public int compare(SortableFileDeployable sortableFileDeployable1, SortableFileDeployable sortableFileDeployable2) {
        int index2;
        int index1 = this.index(sortableFileDeployable1);
        if (index1 > (index2 = this.index(sortableFileDeployable2))) {
            return 1;
        }
        if (index1 == index2) {
            return sortableFileDeployable1.getFile().getName().compareTo(sortableFileDeployable2.getFile().getName());
        }
        return -1;
    }
}

