/*
 * Decompiled with CFR 0.152.
 */
package javax.ejb.embeddable;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.ejb.EJBException;
import javax.ejb.spi.EJBContainerProvider;
import javax.naming.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EJBContainer {
    private static final String EJBCONTAINER_PROVIDER_JAR_PROPERTY = "META-INF/services/" + EJBContainerProvider.class.getName();
    public static final String APP_NAME = "javax.ejb.embeddable.appName";
    public static final String PROVIDER = "javax.ejb.embeddable.provider";
    public static final String MODULES = "javax.ejb.embeddable.modules";
    private static WeakHashMap<ClassLoader, List<EJBContainerProvider>> ejbContainerProviders = new WeakHashMap();

    public abstract void close();

    public static EJBContainer createEJBContainer() {
        return EJBContainer.createEJBContainer(null);
    }

    public static EJBContainer createEJBContainer(Map<?, ?> properties) {
        List<EJBContainerProvider> ejbContainerProviders = EJBContainer.getEJBContainerProviders();
        if (ejbContainerProviders == null || ejbContainerProviders.isEmpty()) {
            throw new EJBException("No EJB Container Provider provider found");
        }
        for (EJBContainerProvider provider : ejbContainerProviders) {
            EJBContainer ejbContainer = provider.createEJBContainer(properties);
            if (ejbContainer == null) continue;
            return ejbContainer;
        }
        throw new EJBException("Unable to build any EJBContainer from providers + '" + ejbContainerProviders + "'.");
    }

    public abstract Context getContext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void findEJBContainerProviders(ClassLoader classLoader) {
        Enumeration<URL> urls = null;
        try {
            urls = classLoader.getResources(EJBCONTAINER_PROVIDER_JAR_PROPERTY);
        }
        catch (IOException e) {
            throw new EJBException("Cannot get resources named '" + EJBCONTAINER_PROVIDER_JAR_PROPERTY + "' on the current classloader '" + classLoader + "'.", e);
        }
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            URLConnection urlConnection = null;
            try {
                urlConnection = url.openConnection();
            }
            catch (IOException e) {
                throw new EJBException("Cannot open connection on URL '" + url + "'.", e);
            }
            urlConnection.setDefaultUseCaches(false);
            InputStream is = null;
            try {
                is = urlConnection.getInputStream();
                Reader reader = null;
                BufferedReader bufferedReader = null;
                try {
                    reader = new InputStreamReader(is);
                    bufferedReader = new BufferedReader(reader);
                    String line = bufferedReader.readLine();
                    if (line == null) {
                        throw new EJBException("No lines found in the file available at the URL '" + url + "'.");
                    }
                    EJBContainer.addEJBContainerProvider(classLoader, line.trim());
                }
                finally {
                    reader.close();
                    bufferedReader.close();
                }
            }
            catch (IOException e) {
                throw new EJBException("Cannot get InputStream on URL '" + url + "'.", e);
            }
            finally {
                if (is == null) continue;
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new EJBException("Cannot close InputStream on URL '" + url + "'.", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<EJBContainerProvider> getEJBContainerProviders() {
        ClassLoader currentCL = Thread.currentThread().getContextClassLoader();
        List<EJBContainerProvider> availableEJBContainers = null;
        WeakHashMap<ClassLoader, List<EJBContainerProvider>> weakHashMap = ejbContainerProviders;
        synchronized (weakHashMap) {
            availableEJBContainers = ejbContainerProviders.get(currentCL);
            if (availableEJBContainers == null) {
                EJBContainer.findEJBContainerProviders(currentCL);
            }
            availableEJBContainers = ejbContainerProviders.get(currentCL);
        }
        return availableEJBContainers;
    }

    private static void addEJBContainerProvider(ClassLoader classLoader, String ejbContainerProviderName) {
        Class<?> ejbContainerProviderClass = null;
        try {
            ejbContainerProviderClass = classLoader.loadClass(ejbContainerProviderName);
        }
        catch (ClassNotFoundException e) {
            throw new EJBException("Cannot load the EJBContainer provider class with the name '" + ejbContainerProviderName + "' in the ClassLoader '" + classLoader + "'.", e);
        }
        Object object = null;
        try {
            object = ejbContainerProviderClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new EJBException("Cannot build an instance of the EJBContainer provider class with the name '" + ejbContainerProviderName + "' in the ClassLoader '" + classLoader + "'.", e);
        }
        catch (IllegalAccessException e) {
            throw new EJBException("Cannot build an instance of the EJBContainer provider class with the name '" + ejbContainerProviderName + "' in the ClassLoader '" + classLoader + "'.", e);
        }
        if (!(object instanceof EJBContainerProvider)) {
            throw new EJBException("The instance of the object with the class name '" + ejbContainerProviderName + "' in the ClassLoader '" + classLoader + "' is not an instance of EJBContainer provider interface.");
        }
        List<EJBContainerProvider> existingEJBContainerProviders = ejbContainerProviders.get(classLoader);
        if (existingEJBContainerProviders == null) {
            existingEJBContainerProviders = new ArrayList<EJBContainerProvider>();
            ejbContainerProviders.put(classLoader, existingEJBContainerProviders);
        }
        existingEJBContainerProviders.add(object);
    }
}

