/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.core.console;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import jline.Terminal;
import jline.TerminalFactory;
import jline.console.ConsoleReader;
import jline.console.completer.AggregateCompleter;
import jline.console.completer.Completer;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.fusesource.jansi.AnsiRenderer;
import org.ow2.shelbie.core.ExitSessionException;
import org.ow2.shelbie.core.IPromptProvider;
import org.ow2.shelbie.core.internal.handler.completer.ScopeCompleter;

public class JLineConsole
implements Runnable {
    private CommandSession session;
    private ConsoleReader reader;
    private boolean running = true;
    private IPromptProvider promptProvider;

    public JLineConsole(CommandProcessor processor, Completer completer, InputStream in, PrintStream out, PrintStream err, IPromptProvider promptProvider) throws Exception {
        this.promptProvider = promptProvider;
        PrintStream wrappedOut = this.wrap(out);
        PrintStream wrappedErr = this.wrap(err);
        this.session = processor.createSession(in, wrappedOut, wrappedErr);
        Terminal terminal = TerminalFactory.get();
        this.reader = new ConsoleReader(in, new PrintWriter(wrappedOut), null, terminal);
        AggregateCompleter composite = new AggregateCompleter(completer, new ScopeCompleter(completer, this.session));
        this.reader.addCompleter(composite);
    }

    private PrintStream wrap(PrintStream stream) {
        PrintStream ps = this.unwrapStream(stream);
        OutputStream result = AnsiConsole.wrapOutputStream(ps);
        if (result instanceof PrintStream) {
            return (PrintStream)result;
        }
        return new PrintStream(result);
    }

    private PrintStream unwrapStream(PrintStream stream) {
        try {
            Method method = stream.getClass().getMethod("getRoot", new Class[0]);
            return (PrintStream)method.invoke((Object)stream, new Object[0]);
        }
        catch (Throwable t) {
            return stream;
        }
    }

    public CommandSession getSession() {
        return this.session;
    }

    public void close() {
        this.running = false;
    }

    public void run() {
        while (this.running) {
            try {
                String rendered = this.getRenderedPrompt(this.session);
                String line = this.reader.readLine(rendered);
                if (line == null) break;
                Object result = this.session.execute((CharSequence)line);
                this.session.put("_", result);
                if (result == null) continue;
                CharSequence value = this.session.format(result, 0);
                this.session.getConsole().println(value);
            }
            catch (ExitSessionException e) {
                break;
            }
            catch (Throwable t) {
                this.session.put("exception", (Object)t);
                this.printError(t.getClass().getSimpleName(), t.getMessage());
            }
        }
    }

    private String getRenderedPrompt(CommandSession session) {
        String prompt = this.promptProvider.getPrompt(session);
        if (AnsiRenderer.test(prompt)) {
            prompt = AnsiRenderer.render(prompt);
        }
        return prompt;
    }

    private void printError(String type, String message) {
        String error = Ansi.ansi().fg(Ansi.Color.RED).a("[").a(type).a("]: ").reset().toString();
        this.session.getConsole().println(error + message);
    }
}

