/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulation.annotations;

import org.apache.felix.ipojo.manipulation.annotations.CustomAnnotationVisitor;
import org.apache.felix.ipojo.manipulation.annotations.MetadataCollector;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.EmptyVisitor;

public class MethodCollector
extends EmptyVisitor {
    private MetadataCollector m_collector;
    private String m_name;
    private String m_descriptor;

    public MethodCollector(String name, String descriptor, MetadataCollector collector) {
        this.m_collector = collector;
        this.m_name = name;
        this.m_descriptor = descriptor;
    }

    public AnnotationVisitor visitParameterAnnotation(int index, String annotation, boolean visible) {
        if (this.m_name.equals("<init>")) {
            if (annotation.equals("Lorg/apache/felix/ipojo/annotations/Property;")) {
                return this.processProperty(true, index);
            }
            if (annotation.equals("Lorg/apache/felix/ipojo/annotations/Requires;")) {
                return new BindAnnotationParser(index);
            }
            if (CustomAnnotationVisitor.isCustomAnnotation(annotation)) {
                Element elem = CustomAnnotationVisitor.buildElement(annotation);
                elem.addAttribute(new Attribute("index", "" + index));
                return new CustomAnnotationVisitor(elem, this.m_collector, true, false, index, this.m_descriptor);
            }
        }
        return super.visitParameterAnnotation(index, annotation, visible);
    }

    public AnnotationVisitor visitAnnotation(String arg0, boolean arg1) {
        if (arg0.equals("Lorg/apache/felix/ipojo/annotations/Property;")) {
            return this.processProperty(false, -1);
        }
        if (arg0.equals("Lorg/apache/felix/ipojo/annotations/Validate;")) {
            return this.processValidate();
        }
        if (arg0.equals("Lorg/apache/felix/ipojo/annotations/Invalidate;")) {
            return this.processInvalidate();
        }
        if (arg0.equals("Lorg/apache/felix/ipojo/annotations/Updated;")) {
            return this.processUpdated();
        }
        if (arg0.equals("Lorg/apache/felix/ipojo/annotations/Bind;")) {
            return this.processBind("bind");
        }
        if (arg0.equals("Lorg/apache/felix/ipojo/annotations/Modified;")) {
            return this.processBind("modified");
        }
        if (arg0.equals("Lorg/apache/felix/ipojo/annotations/Unbind;")) {
            return this.processBind("unbind");
        }
        if (arg0.equals("Lorg/apache/felix/ipojo/annotations/PostRegistration;")) {
            return this.processPostRegistration();
        }
        if (arg0.equals("Lorg/apache/felix/ipojo/annotations/PostUnregistration;")) {
            return this.processPostUnregistration();
        }
        if (CustomAnnotationVisitor.isCustomAnnotation(arg0)) {
            Element elem = CustomAnnotationVisitor.buildElement(arg0);
            elem.addAttribute(new Attribute("method", this.m_name));
            return new CustomAnnotationVisitor(elem, this.m_collector, true, false);
        }
        return null;
    }

    private AnnotationVisitor processUpdated() {
        Element parent = null;
        if (!this.m_collector.getIds().containsKey("properties")) {
            parent = new Element("Properties", "");
            this.m_collector.getIds().put("properties", parent);
            this.m_collector.getElements().put(parent, null);
        } else {
            parent = (Element)this.m_collector.getIds().get("properties");
        }
        parent.addAttribute(new Attribute("updated", this.m_name));
        return null;
    }

    private AnnotationVisitor processPostRegistration() {
        Element parent = null;
        if (this.m_collector.getIds().containsKey("provides")) {
            parent = (Element)this.m_collector.getIds().get("provides");
            parent.addAttribute(new Attribute("post-registration", this.m_name));
        }
        return null;
    }

    private AnnotationVisitor processPostUnregistration() {
        Element parent = null;
        if (this.m_collector.getIds().containsKey("provides")) {
            parent = (Element)this.m_collector.getIds().get("provides");
            parent.addAttribute(new Attribute("post-unregistration", this.m_name));
        }
        return null;
    }

    private AnnotationVisitor processBind(String type) {
        return new BindAnnotationParser(this.m_name, type);
    }

    private AnnotationVisitor processValidate() {
        Element cb = new Element("callback", "");
        cb.addAttribute(new Attribute("transition", "validate"));
        cb.addAttribute(new Attribute("method", this.m_name));
        this.m_collector.getElements().put(cb, null);
        return null;
    }

    private AnnotationVisitor processInvalidate() {
        Element cb = new Element("callback", "");
        cb.addAttribute(new Attribute("transition", "invalidate"));
        cb.addAttribute(new Attribute("method", this.m_name));
        this.m_collector.getElements().put(cb, null);
        return null;
    }

    private AnnotationVisitor processProperty(boolean parameter, int index) {
        Element prop = null;
        if (!this.m_collector.getIds().containsKey("properties")) {
            prop = new Element("Properties", "");
            this.m_collector.getIds().put("properties", prop);
            this.m_collector.getElements().put(prop, null);
        } else {
            prop = (Element)this.m_collector.getIds().get("properties");
        }
        return new PropertyAnnotationParser(prop, this.m_name, parameter, index);
    }

    private final class PropertyAnnotationParser
    extends EmptyVisitor
    implements AnnotationVisitor {
        private Element m_parent;
        private String m_method;
        private String m_name;
        private String m_id;
        private String m_value;
        private String m_mandatory;
        private boolean m_isParameterAnnotation = false;
        private int m_index = -1;

        private PropertyAnnotationParser(Element parent, String method, boolean param, int index) {
            this.m_parent = parent;
            this.m_method = method;
            this.m_isParameterAnnotation = param;
            this.m_index = index;
        }

        public void visit(String arg0, Object arg1) {
            if (arg0.equals("name")) {
                this.m_name = arg1.toString();
                return;
            }
            if (arg0.equals("value")) {
                this.m_value = arg1.toString();
                return;
            }
            if (arg0.equals("mandatory")) {
                this.m_mandatory = arg1.toString();
                return;
            }
            if (arg0.equals("id")) {
                this.m_id = arg1.toString();
                return;
            }
        }

        public void visitEnd() {
            if (this.m_name == null && this.m_id == null && this.m_method.startsWith("set")) {
                this.m_id = this.m_name = this.m_method.substring("set".length());
            } else if (this.m_name != null && this.m_id == null) {
                this.m_id = this.m_name;
            } else if (this.m_id != null && this.m_name == null) {
                this.m_name = this.m_id;
            }
            Element[] props = this.m_parent.getElements("Property");
            Element prop = null;
            for (int i = 0; props != null && prop == null && i < props.length; ++i) {
                String name = props[i].getAttribute("name");
                if (name == null || !name.equals(this.m_name)) continue;
                prop = props[i];
            }
            if (prop == null) {
                prop = new Element("property", "");
                this.m_parent.addElement(prop);
                if (this.m_name != null) {
                    prop.addAttribute(new Attribute("name", this.m_name));
                }
            }
            if (this.m_value != null) {
                prop.addAttribute(new Attribute("value", this.m_value));
            }
            if (this.m_mandatory != null) {
                prop.addAttribute(new Attribute("mandatory", this.m_mandatory));
            }
            if (this.m_isParameterAnnotation) {
                String t = Type.getArgumentTypes(MethodCollector.this.m_descriptor)[this.m_index].getClassName();
                prop.addAttribute(new Attribute("type", t));
                prop.addAttribute(new Attribute("constructor-parameter", Integer.toString(this.m_index)));
            } else {
                prop.addAttribute(new Attribute("method", this.m_method));
            }
        }
    }

    private final class BindAnnotationParser
    extends EmptyVisitor
    implements AnnotationVisitor {
        private String m_name;
        private String m_filter;
        private String m_optional;
        private String m_aggregate;
        private String m_specification;
        private String m_id;
        private String m_type;
        private String m_policy;
        private String m_comparator;
        private String m_from;
        private int m_index = -1;

        private BindAnnotationParser(String bind, String type) {
            this.m_name = bind;
            this.m_type = type;
        }

        private BindAnnotationParser(int index) {
            this.m_index = index;
        }

        public void visit(String arg0, Object arg1) {
            if (arg0.equals("filter")) {
                this.m_filter = arg1.toString();
                return;
            }
            if (arg0.equals("optional")) {
                this.m_optional = arg1.toString();
                return;
            }
            if (arg0.equals("aggregate")) {
                this.m_aggregate = arg1.toString();
                return;
            }
            if (arg0.equals("specification")) {
                this.m_specification = arg1.toString();
                return;
            }
            if (arg0.equals("policy")) {
                this.m_policy = arg1.toString();
                return;
            }
            if (arg0.equals("id")) {
                this.m_id = arg1.toString();
                return;
            }
            if (arg0.equals("comparator")) {
                Type type = Type.getType(arg1.toString());
                this.m_comparator = type.getClassName();
                return;
            }
            if (arg0.equals("from")) {
                this.m_from = arg1.toString();
                return;
            }
        }

        public void visitEnd() {
            Element req;
            if (this.m_id == null) {
                if (this.m_name != null && this.m_name.startsWith("bind")) {
                    this.m_id = this.m_name.substring("bind".length());
                } else if (this.m_name != null && this.m_name.startsWith("unbind")) {
                    this.m_id = this.m_name.substring("unbind".length());
                } else if (this.m_name != null && this.m_name.startsWith("modified")) {
                    this.m_id = this.m_name.substring("modified".length());
                } else if (this.m_index != -1) {
                    this.m_id = "" + this.m_index;
                } else {
                    System.err.println("Cannot determine the id of the " + this.m_type + " method : " + this.m_name);
                    return;
                }
            }
            if ((req = (Element)MethodCollector.this.m_collector.getIds().get(this.m_id)) == null) {
                req = new Element("requires", "");
                if (this.m_specification != null) {
                    req.addAttribute(new Attribute("specification", this.m_specification));
                }
                if (this.m_aggregate != null) {
                    req.addAttribute(new Attribute("aggregate", this.m_aggregate));
                }
                if (this.m_filter != null) {
                    req.addAttribute(new Attribute("filter", this.m_filter));
                }
                if (this.m_optional != null) {
                    req.addAttribute(new Attribute("optional", this.m_optional));
                }
                if (this.m_policy != null) {
                    req.addAttribute(new Attribute("policy", this.m_policy));
                }
                if (this.m_id != null) {
                    req.addAttribute(new Attribute("id", this.m_id));
                }
                if (this.m_comparator != null) {
                    req.addAttribute(new Attribute("comparator", this.m_comparator));
                }
                if (this.m_from != null) {
                    req.addAttribute(new Attribute("from", this.m_from));
                }
            } else {
                String itf = req.getAttribute("specification");
                String aggregate = req.getAttribute("aggregate");
                String optional = req.getAttribute("optional");
                String filter = req.getAttribute("filter");
                String policy = req.getAttribute("policy");
                String comparator = req.getAttribute("comparator");
                String from = req.getAttribute("from");
                if (this.m_specification != null) {
                    if (itf == null) {
                        req.addAttribute(new Attribute("specification", this.m_specification));
                    } else if (!this.m_specification.equals(itf)) {
                        System.err.println("The required specification is not the same as previouly : " + this.m_specification + " & " + itf);
                        return;
                    }
                }
                if (this.m_optional != null) {
                    if (optional == null) {
                        req.addAttribute(new Attribute("optional", this.m_optional));
                    } else if (!this.m_optional.equals(optional)) {
                        System.err.println("The optional attribute is not always the same");
                        return;
                    }
                }
                if (this.m_aggregate != null) {
                    if (aggregate == null) {
                        req.addAttribute(new Attribute("aggregate", this.m_aggregate));
                    } else if (!this.m_aggregate.equals(aggregate)) {
                        System.err.println("The aggregate attribute is not always the same");
                        return;
                    }
                }
                if (this.m_filter != null) {
                    if (filter == null) {
                        req.addAttribute(new Attribute("filter", this.m_filter));
                    } else if (!this.m_filter.equals(filter)) {
                        System.err.println("The filter attribute is not always the same");
                        return;
                    }
                }
                if (this.m_policy != null) {
                    if (policy == null) {
                        req.addAttribute(new Attribute("policy", this.m_policy));
                    } else if (!this.m_policy.equals(policy)) {
                        System.err.println("The policy attribute is not always the same");
                        return;
                    }
                }
                if (this.m_comparator != null) {
                    if (comparator == null) {
                        req.addAttribute(new Attribute("comparator", this.m_comparator));
                    } else if (!this.m_comparator.equals(comparator)) {
                        System.err.println("The comparator attribute is not always the same");
                        return;
                    }
                }
                if (this.m_from != null) {
                    if (from == null) {
                        req.addAttribute(new Attribute("from", this.m_from));
                    } else if (!this.m_from.equals(from)) {
                        System.err.println("The from attribute is not always the same");
                        return;
                    }
                }
            }
            if (this.m_name != null) {
                Element method = new Element("callback", "");
                method.addAttribute(new Attribute("method", this.m_name));
                method.addAttribute(new Attribute("type", this.m_type));
                req.addElement(method);
            } else {
                req.addAttribute(new Attribute("constructor-parameter", Integer.toString(this.m_index)));
            }
            MethodCollector.this.m_collector.getIds().put(this.m_id, req);
            MethodCollector.this.m_collector.getElements().put(req, null);
        }
    }
}

