/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.event.provider.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.ow2.jonas.event.provider.api.Event;
import org.ow2.jonas.event.provider.api.EventLevel;
import org.ow2.jonas.event.provider.api.IEventProvider;
import org.ow2.jonas.log.provider.api.ILogProvider;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventProviderComponent
implements IEventProvider,
Pojo {
    private InstanceManager __IM;
    public static final String JONAS_BASE = System.getProperty("jonas.base");
    public static final String CONF_DIR = "conf";
    public static final String EVENT_PROVIDER_FILE = "event-provider.properties";
    public static final Log logger = LogFactory.getLog(EventProviderComponent.class);
    public static final String INFO_EVENT_WINDOW_TOKEN = "jonas.service.event.info.window";
    public static final String FINE_EVENT_WINDOW_TOKEN = "jonas.service.event.fine.window";
    public static final String FINEST_EVENT_WINDOW_TOKEN = "jonas.service.event.finest.window";
    public static final String FINER_EVENT_WINDOW_TOKEN = "jonas.service.event.finer.window";
    public static final String WARNING_EVENT_WINDOW_TOKEN = "jonas.service.event.warning.window";
    public static final String SEVERE_EVENT_WINDOW_TOKEN = "jonas.service.event.severe.window";
    public static final String EXCEPTION_EVENT_WINDOW_TOKEN = "jonas.service.event.exception.window";
    public static final int DEFAULT_WINDOW_VALUE = 25;
    private boolean __FlogProvider;
    private ILogProvider logProvider;
    private boolean __FeventProviderProperties;
    private Properties eventProviderProperties;
    private boolean __FinfoEvents;
    private List<Event> infoEvents;
    private boolean __FfinestEvents;
    private List<Event> finestEvents;
    private boolean __FfineEvents;
    private List<Event> fineEvents;
    private boolean __FfinerEvents;
    private List<Event> finerEvents;
    private boolean __FwarningEvents;
    private List<Event> warningEvents;
    private boolean __FseverEvents;
    private List<Event> severEvents;
    private boolean __FexceptionEvents;
    private List<Event> exceptionEvents;
    private boolean __Mstart;
    private boolean __MgetEvents$java_util_List;
    private boolean __MgetLevel$org_ow2_jonas_event_provider_api_EventLevel;
    private boolean __MaddEvent$org_ow2_jonas_event_provider_api_Event;
    private boolean __McheckWindowValidity$java_lang_String$java_util_List;
    private boolean __MbindLogProvider$org_ow2_jonas_log_provider_api_ILogProvider;
    private boolean __MunbindLogProvider$org_ow2_jonas_log_provider_api_ILogProvider;

    ILogProvider __getlogProvider() {
        if (!this.__FlogProvider) {
            return this.logProvider;
        }
        return (ILogProvider)this.__IM.onGet((Object)this, "logProvider");
    }

    void __setlogProvider(ILogProvider iLogProvider) {
        if (!this.__FlogProvider) {
            this.logProvider = iLogProvider;
            return;
        }
        this.__IM.onSet((Object)this, "logProvider", (Object)iLogProvider);
    }

    Properties __geteventProviderProperties() {
        if (!this.__FeventProviderProperties) {
            return this.eventProviderProperties;
        }
        return (Properties)this.__IM.onGet((Object)this, "eventProviderProperties");
    }

    void __seteventProviderProperties(Properties properties) {
        if (!this.__FeventProviderProperties) {
            this.eventProviderProperties = properties;
            return;
        }
        this.__IM.onSet((Object)this, "eventProviderProperties", (Object)properties);
    }

    List __getinfoEvents() {
        if (!this.__FinfoEvents) {
            return this.infoEvents;
        }
        return (List)this.__IM.onGet((Object)this, "infoEvents");
    }

    void __setinfoEvents(List list) {
        if (!this.__FinfoEvents) {
            this.infoEvents = list;
            return;
        }
        this.__IM.onSet((Object)this, "infoEvents", (Object)list);
    }

    List __getfinestEvents() {
        if (!this.__FfinestEvents) {
            return this.finestEvents;
        }
        return (List)this.__IM.onGet((Object)this, "finestEvents");
    }

    void __setfinestEvents(List list) {
        if (!this.__FfinestEvents) {
            this.finestEvents = list;
            return;
        }
        this.__IM.onSet((Object)this, "finestEvents", (Object)list);
    }

    List __getfineEvents() {
        if (!this.__FfineEvents) {
            return this.fineEvents;
        }
        return (List)this.__IM.onGet((Object)this, "fineEvents");
    }

    void __setfineEvents(List list) {
        if (!this.__FfineEvents) {
            this.fineEvents = list;
            return;
        }
        this.__IM.onSet((Object)this, "fineEvents", (Object)list);
    }

    List __getfinerEvents() {
        if (!this.__FfinerEvents) {
            return this.finerEvents;
        }
        return (List)this.__IM.onGet((Object)this, "finerEvents");
    }

    void __setfinerEvents(List list) {
        if (!this.__FfinerEvents) {
            this.finerEvents = list;
            return;
        }
        this.__IM.onSet((Object)this, "finerEvents", (Object)list);
    }

    List __getwarningEvents() {
        if (!this.__FwarningEvents) {
            return this.warningEvents;
        }
        return (List)this.__IM.onGet((Object)this, "warningEvents");
    }

    void __setwarningEvents(List list) {
        if (!this.__FwarningEvents) {
            this.warningEvents = list;
            return;
        }
        this.__IM.onSet((Object)this, "warningEvents", (Object)list);
    }

    List __getseverEvents() {
        if (!this.__FseverEvents) {
            return this.severEvents;
        }
        return (List)this.__IM.onGet((Object)this, "severEvents");
    }

    void __setseverEvents(List list) {
        if (!this.__FseverEvents) {
            this.severEvents = list;
            return;
        }
        this.__IM.onSet((Object)this, "severEvents", (Object)list);
    }

    List __getexceptionEvents() {
        if (!this.__FexceptionEvents) {
            return this.exceptionEvents;
        }
        return (List)this.__IM.onGet((Object)this, "exceptionEvents");
    }

    void __setexceptionEvents(List list) {
        if (!this.__FexceptionEvents) {
            this.exceptionEvents = list;
            return;
        }
        this.__IM.onSet((Object)this, "exceptionEvents", (Object)list);
    }

    public EventProviderComponent() {
        this(null);
    }

    private EventProviderComponent(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setinfoEvents(new ArrayList());
        this.__setexceptionEvents(new ArrayList());
        this.__setwarningEvents(new ArrayList());
        this.__setfinerEvents(new ArrayList());
        this.__setfinestEvents(new ArrayList());
        this.__setfineEvents(new ArrayList());
        this.__setseverEvents(new ArrayList());
    }

    public void start() {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    private void __M_start() {
        File eventProviderFile = new File(new File(JONAS_BASE, CONF_DIR), EVENT_PROVIDER_FILE);
        this.__seteventProviderProperties(new Properties());
        try {
            this.__geteventProviderProperties().load(new FileInputStream(eventProviderFile));
        }
        catch (IOException e) {
            logger.error((Object)("Cannot load properties of file " + eventProviderFile.getAbsolutePath()), new Object[]{e});
        }
    }

    public List<Event> getEvents(List<EventLevel> list) {
        List<Event> list2;
        if (!this.__MgetEvents$java_util_List) {
            return this.__M_getEvents(list);
        }
        try {
            this.__IM.onEntry((Object)this, "getEvents$java_util_List", new Object[]{list});
            list2 = this.__M_getEvents(list);
            this.__IM.onExit((Object)this, "getEvents$java_util_List", list2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getEvents$java_util_List", throwable);
            throw throwable;
        }
        return list2;
    }

    private List<Event> __M_getEvents(List<EventLevel> eventLevels) {
        ArrayList<Event> events = new ArrayList<Event>();
        if (eventLevels.contains(EventLevel.ALL)) {
            events.addAll(this.__getexceptionEvents());
            events.addAll(this.__getinfoEvents());
            events.addAll(this.__getseverEvents());
            events.addAll(this.__getwarningEvents());
            events.addAll(this.__getfineEvents());
            events.addAll(this.__getfinerEvents());
            events.addAll(this.__getfinestEvents());
        } else {
            for (EventLevel eventLevel : eventLevels) {
                switch (eventLevel) {
                    case EXCEPTION: {
                        events.addAll(this.__getexceptionEvents());
                        break;
                    }
                    case INFO: {
                        events.addAll(this.__getinfoEvents());
                        break;
                    }
                    case SEVERE: {
                        events.addAll(this.__getseverEvents());
                        break;
                    }
                    case WARNING: {
                        events.addAll(this.__getwarningEvents());
                        break;
                    }
                    case FINE: {
                        events.addAll(this.__getfineEvents());
                        break;
                    }
                    case FINER: {
                        events.addAll(this.__getfinerEvents());
                        break;
                    }
                    case FINEST: {
                        events.addAll(this.__getfinestEvents());
                    }
                }
            }
        }
        return events;
    }

    public Level getLevel(EventLevel eventLevel) {
        Level level;
        if (!this.__MgetLevel$org_ow2_jonas_event_provider_api_EventLevel) {
            return this.__M_getLevel(eventLevel);
        }
        try {
            this.__IM.onEntry((Object)this, "getLevel$org_ow2_jonas_event_provider_api_EventLevel", new Object[]{eventLevel});
            level = this.__M_getLevel(eventLevel);
            this.__IM.onExit((Object)this, "getLevel$org_ow2_jonas_event_provider_api_EventLevel", (Object)level);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getLevel$org_ow2_jonas_event_provider_api_EventLevel", throwable);
            throw throwable;
        }
        return level;
    }

    private Level __M_getLevel(EventLevel eventLevel) {
        if (Level.INFO.toString().equals(eventLevel.toString())) {
            return Level.INFO;
        }
        if (Level.FINEST.toString().equals(eventLevel.toString())) {
            return Level.FINEST;
        }
        if (Level.FINER.toString().equals(eventLevel.toString())) {
            return Level.FINER;
        }
        if (Level.FINE.toString().equals(eventLevel.toString())) {
            return Level.FINE;
        }
        if (Level.SEVERE.toString().equals(eventLevel.toString())) {
            return Level.SEVERE;
        }
        if (Level.WARNING.toString().equals(eventLevel.toString())) {
            return Level.WARNING;
        }
        return null;
    }

    public void addEvent(Event event) {
        if (!this.__MaddEvent$org_ow2_jonas_event_provider_api_Event) {
            this.__M_addEvent(event);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addEvent$org_ow2_jonas_event_provider_api_Event", new Object[]{event});
            this.__M_addEvent(event);
            this.__IM.onExit((Object)this, "addEvent$org_ow2_jonas_event_provider_api_Event", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addEvent$org_ow2_jonas_event_provider_api_Event", throwable);
            throw throwable;
        }
    }

    private void __M_addEvent(Event event) {
        if (event != null) {
            if (EventLevel.INFO.toString().equals(event.getType())) {
                this.__getinfoEvents().add(event);
                this.checkWindowValidity(this.__geteventProviderProperties().getProperty(INFO_EVENT_WINDOW_TOKEN), this.__getinfoEvents());
            } else if (EventLevel.EXCEPTION.toString().equals(event.getType())) {
                this.__getexceptionEvents().add(event);
                this.checkWindowValidity(this.__geteventProviderProperties().getProperty(EXCEPTION_EVENT_WINDOW_TOKEN), this.__getexceptionEvents());
            } else if (EventLevel.SEVERE.toString().equals(event.getType())) {
                this.__getseverEvents().add(event);
                this.checkWindowValidity(this.__geteventProviderProperties().getProperty(SEVERE_EVENT_WINDOW_TOKEN), this.__getseverEvents());
            } else if (EventLevel.FINE.toString().equals(event.getType())) {
                this.__getfineEvents().add(event);
                this.checkWindowValidity(this.__geteventProviderProperties().getProperty(FINE_EVENT_WINDOW_TOKEN), this.__getfineEvents());
            } else if (EventLevel.FINER.toString().equals(event.getType())) {
                this.__getfinerEvents().add(event);
                this.checkWindowValidity(this.__geteventProviderProperties().getProperty(FINER_EVENT_WINDOW_TOKEN), this.__getfinerEvents());
            } else if (EventLevel.FINEST.toString().equals(event.getType())) {
                this.__getfinestEvents().add(event);
                this.checkWindowValidity(this.__geteventProviderProperties().getProperty(FINEST_EVENT_WINDOW_TOKEN), this.__getfinestEvents());
            } else if (EventLevel.WARNING.toString().equals(event.getType())) {
                this.__getwarningEvents().add(event);
                this.checkWindowValidity(this.__geteventProviderProperties().getProperty(WARNING_EVENT_WINDOW_TOKEN), this.__getwarningEvents());
            }
        }
    }

    private void checkWindowValidity(String string, List<Event> list) {
        if (!this.__McheckWindowValidity$java_lang_String$java_util_List) {
            this.__M_checkWindowValidity(string, list);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "checkWindowValidity$java_lang_String$java_util_List", new Object[]{string, list});
            this.__M_checkWindowValidity(string, list);
            this.__IM.onExit((Object)this, "checkWindowValidity$java_lang_String$java_util_List", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "checkWindowValidity$java_lang_String$java_util_List", throwable);
            throw throwable;
        }
    }

    private void __M_checkWindowValidity(String value, List<Event> events) {
        int diff;
        Integer window = null;
        if (value != null) {
            window = Integer.valueOf(value);
        }
        if (window == null) {
            window = 25;
        }
        if ((diff = events.size() - window) > 0) {
            for (int i = 0; i < diff; ++i) {
                events.remove(0);
            }
        }
    }

    public void bindLogProvider(ILogProvider iLogProvider) {
        if (!this.__MbindLogProvider$org_ow2_jonas_log_provider_api_ILogProvider) {
            this.__M_bindLogProvider(iLogProvider);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindLogProvider$org_ow2_jonas_log_provider_api_ILogProvider", new Object[]{iLogProvider});
            this.__M_bindLogProvider(iLogProvider);
            this.__IM.onExit((Object)this, "bindLogProvider$org_ow2_jonas_log_provider_api_ILogProvider", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindLogProvider$org_ow2_jonas_log_provider_api_ILogProvider", throwable);
            throw throwable;
        }
    }

    private void __M_bindLogProvider(ILogProvider logProvider) {
        this.__setlogProvider(logProvider);
    }

    public void unbindLogProvider(ILogProvider iLogProvider) {
        if (!this.__MunbindLogProvider$org_ow2_jonas_log_provider_api_ILogProvider) {
            this.__M_unbindLogProvider(iLogProvider);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindLogProvider$org_ow2_jonas_log_provider_api_ILogProvider", new Object[]{iLogProvider});
            this.__M_unbindLogProvider(iLogProvider);
            this.__IM.onExit((Object)this, "unbindLogProvider$org_ow2_jonas_log_provider_api_ILogProvider", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindLogProvider$org_ow2_jonas_log_provider_api_ILogProvider", throwable);
            throw throwable;
        }
    }

    private void __M_unbindLogProvider(ILogProvider logProvider) {
        this.__setlogProvider(null);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("eventProviderProperties")) {
                this.__FeventProviderProperties = true;
            }
            if (set.contains("exceptionEvents")) {
                this.__FexceptionEvents = true;
            }
            if (set.contains("fineEvents")) {
                this.__FfineEvents = true;
            }
            if (set.contains("finerEvents")) {
                this.__FfinerEvents = true;
            }
            if (set.contains("finestEvents")) {
                this.__FfinestEvents = true;
            }
            if (set.contains("infoEvents")) {
                this.__FinfoEvents = true;
            }
            if (set.contains("logProvider")) {
                this.__FlogProvider = true;
            }
            if (set.contains("severEvents")) {
                this.__FseverEvents = true;
            }
            if (set.contains("warningEvents")) {
                this.__FwarningEvents = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("getEvents$java_util_List")) {
                this.__MgetEvents$java_util_List = true;
            }
            if (set.contains("getLevel$org_ow2_jonas_event_provider_api_EventLevel")) {
                this.__MgetLevel$org_ow2_jonas_event_provider_api_EventLevel = true;
            }
            if (set.contains("addEvent$org_ow2_jonas_event_provider_api_Event")) {
                this.__MaddEvent$org_ow2_jonas_event_provider_api_Event = true;
            }
            if (set.contains("checkWindowValidity$java_lang_String$java_util_List")) {
                this.__McheckWindowValidity$java_lang_String$java_util_List = true;
            }
            if (set.contains("bindLogProvider$org_ow2_jonas_log_provider_api_ILogProvider")) {
                this.__MbindLogProvider$org_ow2_jonas_log_provider_api_ILogProvider = true;
            }
            if (set.contains("unbindLogProvider$org_ow2_jonas_log_provider_api_ILogProvider")) {
                this.__MunbindLogProvider$org_ow2_jonas_log_provider_api_ILogProvider = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

