/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.digester.CallMethodRule;
import org.apache.commons.digester.CallParamRule;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ObjectCreateRule;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.RuleSetBase;
import org.mule.MuleManager;
import org.mule.MuleServer;
import org.mule.config.ConfigurationException;
import org.mule.config.PropertyFactory;
import org.mule.config.builders.CallMethodOnIndexRule;
import org.mule.config.builders.ContainerReference;
import org.mule.config.builders.PlaceholderProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.BeanUtils;
import org.mule.util.ClassUtils;
import org.mule.util.IOUtils;
import org.mule.util.StringUtils;
import org.xml.sax.Attributes;

public class MulePropertiesRuleSet
extends RuleSetBase {
    private String path;
    private PlaceholderProcessor processor;
    private String propertiesSetterName;
    private List objectRefs = null;
    private String parentElement = "properties";

    public MulePropertiesRuleSet(String path, String propertiesSetterName, List objectRefs) {
        this(path, objectRefs);
        this.propertiesSetterName = propertiesSetterName;
    }

    public MulePropertiesRuleSet(String path, String propertiesSetterName, List objectRefs, String parentElement) {
        this(path, objectRefs);
        this.propertiesSetterName = propertiesSetterName;
        this.parentElement = parentElement;
    }

    public MulePropertiesRuleSet(String path, List objectRefs) {
        this.path = path;
        this.processor = new PlaceholderProcessor();
        this.objectRefs = objectRefs;
    }

    public void addRuleInstances(Digester digester) {
        this.path = this.path + "/" + this.parentElement;
        digester.addRule(this.path, new ObjectCreateRule(this.path, HashMap.class){

            public void end(String string, String string1) throws Exception {
                Map props = (Map)this.digester.peek();
                if (props.containsKey("org.mule.useManagerProperties")) {
                    props.putAll(MuleManager.getInstance().getProperties());
                    props.remove("org.mule.useManagerProperties");
                }
                super.end(string, string1);
                if (MulePropertiesRuleSet.this.propertiesSetterName == null) {
                    BeanUtils.populateWithoutFail(this.digester.peek(), props, true);
                } else {
                    MethodUtils.invokeMethod(this.digester.peek(), MulePropertiesRuleSet.this.propertiesSetterName, props);
                }
            }
        });
        digester.addCallMethod(this.path + "/property", "put", 2);
        digester.addRule(this.path + "/property", new ProcessedCallParamRule(0, "name"));
        digester.addRule(this.path + "/property", new ProcessedCallParamRule(1, "value"));
        this.addPropertyFactoryRule(digester, this.path + "/factory-property");
        this.addSystemPropertyRule(digester, this.path + "/system-property");
        this.addFilePropertiesRule(digester, this.path + "/file-properties");
        this.addContainerPropertyRule(digester, this.path + "/container-property", this.propertiesSetterName == null);
        this.addTextPropertyRule(digester, this.path + "/text-property");
        this.addMapPropertyRules(digester, this.path);
        this.addListPropertyRules(digester, this.path);
        this.addMapPropertyRules(digester, this.path + "/map");
        this.addListPropertyRules(digester, this.path + "/map");
    }

    protected void addMapPropertyRules(Digester digester, String path) {
        digester.addObjectCreate(path + "/map", HashMap.class);
        digester.addCallMethod(path + "/map/property", "put", 2);
        digester.addRule(path + "/map/property", new ProcessedCallParamRule(0, "name"));
        digester.addRule(path + "/map/property", new ProcessedCallParamRule(1, "value"));
        this.addPropertyFactoryRule(digester, path + "/map/factory-property");
        this.addSystemPropertyRule(digester, path + "/map/system-property");
        this.addFilePropertiesRule(digester, path + "/map/file-properties");
        this.addContainerPropertyRule(digester, path + "/map/container-property", false);
        digester.addRule(path + "/map", new CallMethodOnIndexRule("put", 2, 1));
        digester.addCallParam(path + "/map", 0, "name");
        digester.addCallParam(path + "/map", 1, true);
    }

    protected void addListPropertyRules(Digester digester, String path) {
        digester.addObjectCreate(path + "/list", ArrayList.class);
        digester.addRule(path + "/list/entry", new CallMethodRule("add", 1){

            public void begin(String endpointName, String endpointName1, Attributes attributes) throws Exception {
                attributes = MulePropertiesRuleSet.this.processor.processAttributes(attributes, endpointName1);
                super.begin(endpointName, endpointName1, attributes);
            }
        });
        digester.addRule(path + "/list/entry", new ProcessedCallParamRule(0, "value"));
        this.addPropertyFactoryRule(digester, path + "/list/factory-entry");
        this.addSystemPropertyRule(digester, path + "/list/system-entry");
        this.addContainerPropertyRule(digester, path + "/list/container-entry", false);
        digester.addRule(path + "/list", new CallMethodOnIndexRule("put", 2, 1));
        digester.addCallParam(path + "/list", 0, "name");
        digester.addCallParam(path + "/list", 1, true);
    }

    protected void addPropertyFactoryRule(Digester digester, String path) {
        digester.addRule(path, new Rule(){

            public void begin(String s, String s1, Attributes attributes) throws Exception {
                attributes = MulePropertiesRuleSet.this.processor.processAttributes(attributes, s1);
                String clazz = attributes.getValue("factory");
                String name = attributes.getValue("name");
                Object props = this.digester.peek();
                Object obj = ClassUtils.instanciateClass(clazz, ClassUtils.NO_ARGS);
                if (obj instanceof PropertyFactory) {
                    obj = props instanceof Map ? ((PropertyFactory)obj).create((Map)props) : ((PropertyFactory)obj).create((Map)this.digester.peek(1));
                }
                if (obj != null) {
                    if (props instanceof Map) {
                        ((Map)props).put(name, obj);
                    } else {
                        ((List)props).add(obj);
                    }
                }
            }
        });
    }

    protected void addSystemPropertyRule(Digester digester, String path) {
        digester.addRule(path, new Rule(){

            public void begin(String s, String s1, Attributes attributes) throws Exception {
                String defaultValue;
                attributes = MulePropertiesRuleSet.this.processor.processAttributes(attributes, s1);
                String name = attributes.getValue("name");
                String key = attributes.getValue("key");
                String value = System.getProperty(key, defaultValue = attributes.getValue("defaultValue"));
                if (value != null) {
                    Object props = this.digester.peek();
                    if (props instanceof Map) {
                        ((Map)props).put(name, value);
                    } else {
                        ((List)props).add(value);
                    }
                }
            }
        });
    }

    protected synchronized void addFilePropertiesRule(Digester digester, String path) {
        digester.addRule(path, new Rule(){

            public void begin(String s, String s1, Attributes attributes) throws Exception {
                attributes = MulePropertiesRuleSet.this.processor.processAttributes(attributes, s1);
                String location = attributes.getValue("location");
                String temp = attributes.getValue("override");
                boolean override = "true".equalsIgnoreCase(temp);
                InputStream is = IOUtils.getResourceAsStream(location, this.getClass());
                if (is == null) {
                    throw new ConfigurationException(CoreMessages.cannotLoadFromClasspath(location));
                }
                Properties fileProps = new Properties();
                fileProps.load(is);
                Map digesterProps = (Map)this.digester.peek();
                if (override) {
                    digesterProps.putAll(fileProps);
                } else {
                    Iterator<Object> iterator = fileProps.keySet().iterator();
                    while (iterator.hasNext()) {
                        String key = (String)iterator.next();
                        if (digesterProps.containsKey(key)) continue;
                        digesterProps.put(key, fileProps.getProperty(key));
                    }
                }
                if (StringUtils.isNotBlank(MuleServer.getStartupPropertiesFile()) && (is = IOUtils.getResourceAsStream(MuleServer.getStartupPropertiesFile(), this.getClass(), true, false)) != null) {
                    Properties startupProps = new Properties();
                    startupProps.load(is);
                    Iterator<Object> iterator = startupProps.keySet().iterator();
                    while (iterator.hasNext()) {
                        String key = (String)iterator.next();
                        if (!digesterProps.containsKey(key)) continue;
                        digesterProps.put(key, startupProps.getProperty(key));
                    }
                }
            }
        });
    }

    protected void addContainerPropertyRule(Digester digester, String path, final boolean asBean) {
        digester.addRule(path, new Rule(){

            public void begin(String s, String s1, Attributes attributes) throws Exception {
                attributes = MulePropertiesRuleSet.this.processor.processAttributes(attributes, s1);
                String name = attributes.getValue("name");
                String value = attributes.getValue("reference");
                String required = attributes.getValue("required");
                String container = attributes.getValue("container");
                if (required == null) {
                    required = "true";
                }
                boolean req = Boolean.valueOf(required);
                Object obj = null;
                obj = asBean ? this.digester.peek(1) : this.digester.peek();
                MulePropertiesRuleSet.this.objectRefs.add(new ContainerReference(name, value, obj, req, container));
            }
        });
    }

    protected void addTextPropertyRule(Digester digester, String path) {
        digester.addRule(path, new Rule(){
            private String name = null;

            public void begin(String s, String s1, Attributes attributes) throws Exception {
                attributes = MulePropertiesRuleSet.this.processor.processAttributes(attributes, s1);
                this.name = attributes.getValue("name");
            }

            public void body(String string, String string1, String string2) throws Exception {
                Object props = this.digester.peek();
                if (props instanceof Map) {
                    ((Map)props).put(this.name, string2);
                } else {
                    ((List)props).add(string2);
                }
            }
        });
    }

    public static interface PropertiesCallback {
        public void setProperties(Map var1, Digester var2) throws Exception;
    }

    private class ProcessedCallParamRule
    extends CallParamRule {
        public ProcessedCallParamRule(int i) {
            super(i);
        }

        public ProcessedCallParamRule(int i, String s) {
            super(i, s);
        }

        public ProcessedCallParamRule(int i, boolean b) {
            super(i, b);
        }

        public ProcessedCallParamRule(int i, int i1) {
            super(i, i1);
        }

        public void begin(String endpointName, String endpointName1, Attributes attributes) throws Exception {
            attributes = MulePropertiesRuleSet.this.processor.processAttributes(attributes, endpointName1);
            super.begin(endpointName, endpointName1, attributes);
        }
    }
}

