/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import java.io.File;
import java.io.InputStream;
import javax.servlet.ServletContext;
import org.mule.config.ConfigurationException;
import org.mule.config.builders.MuleXmlConfigurationBuilder;
import org.mule.util.FileUtils;

public class WebappMuleXmlConfigurationBuilder
extends MuleXmlConfigurationBuilder {
    private ServletContext context;
    private String webappClasspath;

    public WebappMuleXmlConfigurationBuilder(ServletContext context, String webappClasspath) throws ConfigurationException {
        this.context = context;
        this.webappClasspath = webappClasspath;
    }

    protected InputStream loadResource(String resource) throws ConfigurationException {
        String resourcePath = resource;
        InputStream is = null;
        if (this.webappClasspath != null) {
            resourcePath = new File(this.webappClasspath, resource).getPath();
            is = this.context.getResourceAsStream(resourcePath);
        }
        if (is == null) {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
        }
        if (this.logger.isDebugEnabled()) {
            if (is != null) {
                this.logger.debug((Object)("Resource " + resource + " is found in Servlet Context."));
            } else {
                this.logger.debug((Object)("Resource " + resourcePath + " is not found in Servlet Context, loading from classpath or as external file"));
            }
        }
        if (is == null && this.webappClasspath != null) {
            resourcePath = FileUtils.newFile(this.webappClasspath, resource).getPath();
            try {
                is = super.loadResource(resourcePath);
            }
            catch (ConfigurationException ex) {
                this.logger.debug((Object)("Resource " + resourcePath + " is not found in filesystem"));
            }
        }
        if (is == null) {
            is = super.loadResource(resource);
        }
        return is;
    }
}

