/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms;

import java.util.Map;
import javax.jms.Destination;
import javax.jms.Queue;
import javax.jms.Topic;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.providers.jms.Jms102bSupport;
import org.mule.providers.jms.JmsConnector;
import org.mule.providers.jms.JmsTopicResolver;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.util.MapUtils;
import org.mule.util.StringMessageUtils;

public class DefaultJmsTopicResolver
implements JmsTopicResolver {
    protected static final Log logger = LogFactory.getLog((Class)DefaultJmsTopicResolver.class);
    private JmsConnector connector;

    public DefaultJmsTopicResolver(JmsConnector connector) {
        this.connector = connector;
    }

    public JmsConnector getConnector() {
        return this.connector;
    }

    public boolean isTopic(UMOImmutableEndpoint endpoint) {
        return this.isTopic(endpoint, true);
    }

    public boolean isTopic(UMOImmutableEndpoint endpoint, boolean fallbackToEndpointProperties) {
        String resourceInfo = endpoint.getEndpointURI().getResourceInfo();
        boolean topic = "topic".equalsIgnoreCase(resourceInfo);
        if (!topic && fallbackToEndpointProperties) {
            topic = MapUtils.getBooleanValue((Map)endpoint.getProperties(), (Object)"topic", (boolean)false);
        }
        return topic;
    }

    public boolean isTopic(Destination destination) {
        this.checkInvariants(destination);
        return destination instanceof Topic;
    }

    protected void checkInvariants(Destination destination) {
        if (destination instanceof Topic && destination instanceof Queue && this.connector.getJmsSupport() instanceof Jms102bSupport) {
            logger.error((Object)StringMessageUtils.getBoilerPlate("Destination implements both Queue and Topic while complying with JMS 1.0.2b specification. Please report your application server or JMS vendor name and version to dev<_at_>mule.codehaus.org or http://www.mulesource.org/jira"));
        }
    }
}

