/*
 * Decompiled with CFR 0.152.
 */
package org.mule.umo.routing;

import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;
import org.mule.umo.MessagingException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOImmutableEndpoint;

public class RoutingException
extends MessagingException {
    private static final long serialVersionUID = 2478458847072048645L;
    protected final transient UMOImmutableEndpoint endpoint;

    public RoutingException(UMOMessage message, UMOImmutableEndpoint endpoint) {
        super(RoutingException.generateMessage(null, endpoint), message);
        this.endpoint = endpoint;
    }

    public RoutingException(UMOMessage umoMessage, UMOImmutableEndpoint endpoint, Throwable cause) {
        super(RoutingException.generateMessage(null, endpoint), umoMessage, cause);
        this.endpoint = endpoint;
    }

    public RoutingException(Message message, UMOMessage umoMessage, UMOImmutableEndpoint endpoint) {
        super(RoutingException.generateMessage(message, endpoint), umoMessage);
        this.endpoint = endpoint;
    }

    public RoutingException(Message message, UMOMessage umoMessage, UMOImmutableEndpoint endpoint, Throwable cause) {
        super(RoutingException.generateMessage(message, endpoint), umoMessage, cause);
        this.endpoint = endpoint;
    }

    public UMOImmutableEndpoint getEndpoint() {
        return this.endpoint;
    }

    private static Message generateMessage(Message message, UMOImmutableEndpoint endpoint) {
        Message m = CoreMessages.failedToRouterViaEndpoint(endpoint);
        if (message != null) {
            message.setNextMessage(m);
            return message;
        }
        return m;
    }
}

