/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.core.internal.converter;

import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.ServiceProperty;
import org.apache.felix.service.command.Converter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.startlevel.StartLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Provides
public class BundleConverter
implements Converter,
Pojo {
    private InstanceManager __IM;
    private boolean __FsupportedClasses;
    @ServiceProperty(name="osgi.converter.classes", value="org.osgi.framework.Bundle")
    private String supportedClasses;
    private boolean __Fcontext;
    private BundleContext context;
    private boolean __Mconvert$java_lang_Class$java_lang_Object;
    private boolean __Mformat$java_lang_Object$int$org_apache_felix_service_command_Converter;
    private boolean __MprintPart$org_osgi_framework_Bundle;
    private boolean __MprintLine$org_osgi_framework_Bundle;
    private boolean __MgetState$org_osgi_framework_Bundle;

    String __getsupportedClasses() {
        if (!this.__FsupportedClasses) {
            return this.supportedClasses;
        }
        return (String)this.__IM.onGet((Object)this, "supportedClasses");
    }

    void __setsupportedClasses(String string) {
        if (!this.__FsupportedClasses) {
            this.supportedClasses = string;
            return;
        }
        this.__IM.onSet((Object)this, "supportedClasses", (Object)string);
    }

    BundleContext __getcontext() {
        if (!this.__Fcontext) {
            return this.context;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "context");
    }

    void __setcontext(BundleContext bundleContext) {
        if (!this.__Fcontext) {
            this.context = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "context", (Object)bundleContext);
    }

    public BundleConverter(BundleContext bundleContext) {
        this(null, bundleContext);
    }

    private BundleConverter(InstanceManager _manager, BundleContext context) {
        this._setInstanceManager(_manager);
        this.__setcontext(context);
    }

    public Object convert(Class<?> clazz, Object object) throws Exception {
        Object object2;
        if (!this.__Mconvert$java_lang_Class$java_lang_Object) {
            return this.__M_convert(clazz, object);
        }
        try {
            this.__IM.onEntry((Object)this, "convert$java_lang_Class$java_lang_Object", new Object[]{clazz, object});
            object2 = this.__M_convert(clazz, object);
            this.__IM.onExit((Object)this, "convert$java_lang_Class$java_lang_Object", object2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "convert$java_lang_Class$java_lang_Object", throwable);
            throw throwable;
        }
        return object2;
    }

    private Object __M_convert(Class<?> desiredType, Object in) throws Exception {
        if (Bundle.class.equals(desiredType)) {
            String s = in.toString();
            try {
                long id = Long.parseLong(s);
                return this.__getcontext().getBundle(id);
            }
            catch (NumberFormatException nfe) {
                Bundle[] bundles;
                for (Bundle b : bundles = this.__getcontext().getBundles()) {
                    if (b.getLocation().equals(s)) {
                        return b;
                    }
                    if (!b.getSymbolicName().equals(s)) continue;
                    return b;
                }
            }
        }
        return null;
    }

    public CharSequence format(Object object, int n, Converter converter) throws Exception {
        CharSequence charSequence;
        if (!this.__Mformat$java_lang_Object$int$org_apache_felix_service_command_Converter) {
            return this.__M_format(object, n, converter);
        }
        try {
            this.__IM.onEntry((Object)this, "format$java_lang_Object$int$org_apache_felix_service_command_Converter", new Object[]{object, new Integer(n), converter});
            charSequence = this.__M_format(object, n, converter);
            this.__IM.onExit((Object)this, "format$java_lang_Object$int$org_apache_felix_service_command_Converter", (Object)charSequence);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "format$java_lang_Object$int$org_apache_felix_service_command_Converter", throwable);
            throw throwable;
        }
        return charSequence;
    }

    private CharSequence __M_format(Object target, int level, Converter converter) throws Exception {
        if (target instanceof Bundle) {
            Bundle bundle = (Bundle)target;
            switch (level) {
                case 1: {
                    return this.printLine(bundle);
                }
                case 2: {
                    return this.printPart(bundle);
                }
            }
            return null;
        }
        return null;
    }

    private String printPart(Bundle bundle) {
        String string;
        if (!this.__MprintPart$org_osgi_framework_Bundle) {
            return this.__M_printPart(bundle);
        }
        try {
            this.__IM.onEntry((Object)this, "printPart$org_osgi_framework_Bundle", new Object[]{bundle});
            string = this.__M_printPart(bundle);
            this.__IM.onExit((Object)this, "printPart$org_osgi_framework_Bundle", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "printPart$org_osgi_framework_Bundle", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_printPart(Bundle bundle) {
        return bundle.getSymbolicName();
    }

    private CharSequence printLine(Bundle bundle) {
        CharSequence charSequence;
        if (!this.__MprintLine$org_osgi_framework_Bundle) {
            return this.__M_printLine(bundle);
        }
        try {
            this.__IM.onEntry((Object)this, "printLine$org_osgi_framework_Bundle", new Object[]{bundle});
            charSequence = this.__M_printLine(bundle);
            this.__IM.onExit((Object)this, "printLine$org_osgi_framework_Bundle", (Object)charSequence);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "printLine$org_osgi_framework_Bundle", throwable);
            throw throwable;
        }
        return charSequence;
    }

    private CharSequence __M_printLine(Bundle bundle) {
        StartLevel sl = null;
        ServiceReference ref = this.__getcontext().getServiceReference(StartLevel.class.getName());
        if (ref != null) {
            sl = (StartLevel)this.__getcontext().getService(ref);
        }
        if (sl == null) {
            return String.format("%5d|%-11s|%s (%s)", bundle.getBundleId(), this.getState(bundle), bundle.getSymbolicName(), bundle.getVersion());
        }
        int level = sl.getBundleStartLevel(bundle);
        this.__getcontext().ungetService(ref);
        return String.format("%5d|%-11s|%5d|%s (%s)", bundle.getBundleId(), this.getState(bundle), level, bundle.getSymbolicName(), bundle.getVersion());
    }

    private String getState(Bundle bundle) {
        String string;
        if (!this.__MgetState$org_osgi_framework_Bundle) {
            return this.__M_getState(bundle);
        }
        try {
            this.__IM.onEntry((Object)this, "getState$org_osgi_framework_Bundle", new Object[]{bundle});
            string = this.__M_getState(bundle);
            this.__IM.onExit((Object)this, "getState$org_osgi_framework_Bundle", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getState$org_osgi_framework_Bundle", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getState(Bundle bundle) {
        switch (bundle.getState()) {
            case 32: {
                return "Active";
            }
            case 2: {
                return "Installed";
            }
            case 4: {
                return "Resolved";
            }
            case 8: {
                return "Starting";
            }
            case 16: {
                return "Stopping";
            }
            case 1: {
                return "Uninstalled ";
            }
        }
        return null;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("context")) {
                this.__Fcontext = true;
            }
            if (set.contains("supportedClasses")) {
                this.__FsupportedClasses = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("convert$java_lang_Class$java_lang_Object")) {
                this.__Mconvert$java_lang_Class$java_lang_Object = true;
            }
            if (set.contains("format$java_lang_Object$int$org_apache_felix_service_command_Converter")) {
                this.__Mformat$java_lang_Object$int$org_apache_felix_service_command_Converter = true;
            }
            if (set.contains("printPart$org_osgi_framework_Bundle")) {
                this.__MprintPart$org_osgi_framework_Bundle = true;
            }
            if (set.contains("printLine$org_osgi_framework_Bundle")) {
                this.__MprintLine$org_osgi_framework_Bundle = true;
            }
            if (set.contains("getState$org_osgi_framework_Bundle")) {
                this.__MgetState$org_osgi_framework_Bundle = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

