/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.mule.impl.ThreadSafeAccess;
import org.mule.providers.AbstractMessageAdapter;
import org.mule.umo.provider.MessageTypeNotSupportedException;

public class WriterMessageAdapter
extends AbstractMessageAdapter {
    private static final long serialVersionUID = -1065602752454818625L;
    private final StringWriter writer;

    public WriterMessageAdapter(Object message) throws MessageTypeNotSupportedException {
        if (message instanceof String) {
            this.writer = new StringWriter();
            this.writer.write((String)message);
        } else if (message instanceof StringWriter) {
            this.writer = (StringWriter)message;
        } else {
            throw new MessageTypeNotSupportedException(message, this.getClass());
        }
    }

    protected WriterMessageAdapter(WriterMessageAdapter template) {
        super(template);
        this.writer = template.writer;
    }

    public String getPayloadAsString(String encoding) throws Exception {
        return this.writer.toString();
    }

    public byte[] getPayloadAsBytes() throws Exception {
        return this.writer.toString().getBytes();
    }

    public Object getPayload() {
        return this.writer.toString();
    }

    public void write(String string) {
        this.writer.write(string);
    }

    public void write(String string, int offset, int len) {
        this.writer.write(string, offset, len);
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void flush() {
        this.writer.flush();
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public ThreadSafeAccess newThreadCopy() {
        return new WriterMessageAdapter(this);
    }
}

