/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.tcp.protocols;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.providers.tcp.protocols.ByteProtocol;

public class DefaultProtocol
extends ByteProtocol {
    private static final Log logger = LogFactory.getLog((Class)DefaultProtocol.class);
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final int UNLIMITED = -1;
    private int bufferSize;

    public DefaultProtocol() {
        this(true, 8192);
    }

    public DefaultProtocol(boolean streamOk, int bufferSize) {
        super(streamOk);
        this.bufferSize = bufferSize;
    }

    public Object read(InputStream is) throws IOException {
        return this.read(is, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object read(InputStream is, int limit) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(this.bufferSize);
        try {
            boolean repeat;
            byte[] buffer = new byte[this.bufferSize];
            int remain = this.remaining(limit, limit, 0);
            do {
                int len = this.copy(is, buffer, baos, remain);
                remain = this.remaining(limit, remain, len);
                boolean bl = repeat = -1 != len && remain > 0 && this.isRepeat(len, is.available());
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)MessageFormat.format("len/limit/repeat: {0}/{1}/{2}", new Integer(len), new Integer(limit), repeat));
            } while (repeat);
        }
        finally {
            baos.flush();
            baos.close();
        }
        return this.nullEmptyArray(baos.toByteArray());
    }

    private int remaining(int limit, int remain, int len) {
        if (-1 == limit) {
            return this.bufferSize;
        }
        if (-1 != len) {
            return remain - len;
        }
        return remain;
    }

    protected boolean isRepeat(int len, int available) {
        return available > 0;
    }
}

