/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import org.mule.config.i18n.CoreMessages;
import org.mule.providers.AbstractConnectionStrategy;
import org.mule.providers.FatalConnectException;
import org.mule.umo.provider.UMOConnectable;
import org.mule.util.ObjectUtils;

public class SimpleRetryConnectionStrategy
extends AbstractConnectionStrategy {
    public static final int DEFAULT_FREQUENCY = 2000;
    public static final int DEFAULT_RETRY_COUNT = 2;
    public static final int RETRY_COUNT_FOREVER = -1;
    protected static final RetryCounter retryCounter = new RetryCounter();
    protected static final ThreadLocal called = new ThreadLocal();
    private volatile int retryCount = 2;
    private volatile long frequency = 2000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doConnect(UMOConnectable connectable) throws FatalConnectException {
        while (true) {
            Object var6_7;
            Boolean recursiveCallDetected;
            if (!(recursiveCallDetected = (Boolean)ObjectUtils.defaultIfNull(called.get(), Boolean.FALSE)).booleanValue()) {
                retryCounter.countRetry();
            }
            called.set(Boolean.TRUE);
            try {
                try {
                    connectable.connect();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Successfully connected to " + this.getDescription(connectable)));
                    }
                    var6_7 = null;
                    called.set(Boolean.FALSE);
                    break;
                }
                catch (InterruptedException ie) {
                    throw new FatalConnectException(CoreMessages.reconnectStrategyFailed(this.getClass(), this.getDescription(connectable)), ie, connectable);
                }
                catch (Exception e) {
                    if (e instanceof FatalConnectException) {
                        throw (FatalConnectException)e;
                    }
                    if (this.retryCount != -1 && retryCounter.current().get() >= this.retryCount) {
                        throw new FatalConnectException(CoreMessages.reconnectStrategyFailed(this.getClass(), this.getDescription(connectable)), e, connectable);
                    }
                    if (this.logger.isInfoEnabled()) {
                        StringBuffer msg = new StringBuffer(512);
                        msg.append("Failed to connect/reconnect: ");
                        msg.append(this.getDescription(connectable));
                        msg.append("Waiting for ");
                        msg.append(this.frequency);
                        msg.append("ms before reconnecting. Failed attempt ");
                        msg.append(retryCounter.current().get());
                        msg.append(" of ");
                        msg.append(this.retryCount != -1 ? String.valueOf(this.retryCount) : "unlimited");
                        this.logger.info((Object)msg.toString());
                    }
                    try {
                        Thread.sleep(this.frequency);
                    }
                    catch (InterruptedException e1) {
                        throw new FatalConnectException(CoreMessages.reconnectStrategyFailed(this.getClass(), this.getDescription(connectable)), e, connectable);
                    }
                    var6_7 = null;
                    called.set(Boolean.FALSE);
                }
            }
            catch (Throwable throwable) {
                var6_7 = null;
                called.set(Boolean.FALSE);
                throw throwable;
            }
        }
    }

    public synchronized void resetState() {
        retryCounter.reset();
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public long getFrequency() {
        return this.frequency;
    }

    public void setFrequency(long frequency) {
        this.frequency = frequency;
    }

    protected static class RetryCounter
    extends ThreadLocal {
        protected RetryCounter() {
        }

        public int countRetry() {
            return ((AtomicInteger)this.get()).incrementAndGet();
        }

        public void reset() {
            ((AtomicInteger)this.get()).set(0);
        }

        public AtomicInteger current() {
            return (AtomicInteger)this.get();
        }

        protected Object initialValue() {
            return new AtomicInteger(0);
        }
    }
}

