/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.Context;
import org.mule.providers.jms.Jms11Support;
import org.mule.providers.jms.JmsConnector;

public class Jms102bSupport
extends Jms11Support {
    public Jms102bSupport(JmsConnector connector, Context context, boolean jndiDestinations, boolean forceJndiDestinations) {
        super(connector, context, jndiDestinations, forceJndiDestinations);
    }

    public Connection createConnection(ConnectionFactory connectionFactory, String username, String password) throws JMSException {
        if (connectionFactory == null) {
            throw new IllegalArgumentException("connectionFactory cannot be null");
        }
        if (connectionFactory instanceof QueueConnectionFactory) {
            return ((QueueConnectionFactory)connectionFactory).createQueueConnection(username, password);
        }
        if (connectionFactory instanceof TopicConnectionFactory) {
            return ((TopicConnectionFactory)connectionFactory).createTopicConnection(username, password);
        }
        throw new IllegalArgumentException("Unsupported ConnectionFactory type: " + connectionFactory.getClass().getName());
    }

    public Connection createConnection(ConnectionFactory connectionFactory) throws JMSException {
        if (connectionFactory == null) {
            throw new IllegalArgumentException("connectionFactory cannot be null");
        }
        if (connectionFactory instanceof QueueConnectionFactory) {
            return ((QueueConnectionFactory)connectionFactory).createQueueConnection();
        }
        if (connectionFactory instanceof TopicConnectionFactory) {
            return ((TopicConnectionFactory)connectionFactory).createTopicConnection();
        }
        throw new IllegalArgumentException("Unsupported ConnectionFactory type: " + connectionFactory.getClass().getName());
    }

    public Session createSession(Connection connection, boolean topic, boolean transacted, int ackMode, boolean noLocal) throws JMSException {
        if (topic && connection instanceof TopicConnection) {
            return ((TopicConnection)connection).createTopicSession(noLocal, ackMode);
        }
        if (connection instanceof QueueConnection) {
            return ((QueueConnection)connection).createQueueSession(transacted, transacted ? 0 : ackMode);
        }
        throw new IllegalArgumentException("Connection and domain type do not match");
    }

    public MessageConsumer createConsumer(Session session, Destination destination, String messageSelector, boolean noLocal, String durableName, boolean topic) throws JMSException {
        if (topic && session instanceof TopicSession) {
            if (durableName == null) {
                return ((TopicSession)session).createSubscriber((Topic)destination, messageSelector, noLocal);
            }
            return ((TopicSession)session).createDurableSubscriber((Topic)destination, durableName, messageSelector, noLocal);
        }
        if (session instanceof QueueSession) {
            if (messageSelector != null) {
                return ((QueueSession)session).createReceiver((Queue)destination, messageSelector);
            }
            return ((QueueSession)session).createReceiver((Queue)destination);
        }
        throw new IllegalArgumentException("Session and domain type do not match");
    }

    public MessageProducer createProducer(Session session, Destination dest, boolean topic) throws JMSException {
        if (topic && session instanceof TopicSession) {
            return ((TopicSession)session).createPublisher((Topic)dest);
        }
        if (session instanceof QueueSession) {
            return ((QueueSession)session).createSender((Queue)dest);
        }
        throw new IllegalArgumentException("Session and domain type do not match");
    }

    public Destination createDestination(Session session, String name, boolean topic) throws JMSException {
        if (session == null) {
            throw new IllegalArgumentException("Session cannot be null when creating a destination");
        }
        if (name == null) {
            throw new IllegalArgumentException("Destination name cannot be null when creating a destination");
        }
        if (this.jndiDestinations) {
            if (this.context == null) {
                throw new IllegalArgumentException("Jndi Context name cannot be null when looking up a destination");
            }
            Destination dest = this.getJndiDestination(name);
            if (dest != null) {
                return dest;
            }
            if (this.forceJndiDestinations) {
                throw new JMSException("JNDI destination not found with name: " + name);
            }
        }
        if (topic) {
            return ((TopicSession)session).createTopic(name);
        }
        return ((QueueSession)session).createQueue(name);
    }

    public Destination createTemporaryDestination(Session session, boolean topic) throws JMSException {
        if (session == null) {
            throw new IllegalArgumentException("Session cannot be null when creating a destination");
        }
        if (topic) {
            return ((TopicSession)session).createTemporaryTopic();
        }
        return ((QueueSession)session).createTemporaryQueue();
    }

    public void send(MessageProducer producer, Message message, boolean persistent, int priority, long ttl, boolean topic) throws JMSException {
        if (topic && producer instanceof TopicPublisher) {
            ((TopicPublisher)producer).publish(message, persistent ? 2 : 1, priority, ttl);
        } else if (producer instanceof QueueSender) {
            ((QueueSender)producer).send(message, persistent ? 2 : 1, priority, ttl);
        } else {
            throw new IllegalArgumentException("Producer and domain type do not match");
        }
    }

    public void send(MessageProducer producer, Message message, Destination dest, boolean persistent, int priority, long ttl, boolean topic) throws JMSException {
        if (topic && producer instanceof TopicPublisher) {
            ((TopicPublisher)producer).publish((Topic)dest, message, persistent ? 2 : 1, priority, ttl);
        } else if (producer instanceof QueueSender) {
            ((QueueSender)producer).send((Queue)dest, message, persistent ? 2 : 1, priority, ttl);
        } else {
            throw new IllegalArgumentException("Producer and domain type do not match");
        }
    }
}

