/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.mule.providers.jms;

import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.commons.lang.BooleanUtils;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.jms.JmsConnector;
import org.mule.providers.jms.JmsSupport;
import org.mule.providers.jms.filters.JmsSelectorFilter;
import org.mule.providers.jms.i18n.JmsMessages;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.DispatchException;
import org.mule.util.ClassUtils;
import org.mule.util.NumberUtils;
import org.mule.util.StringUtils;

public class JasmineJmsMessageDispatcher
extends AbstractMessageDispatcher {
    private JmsConnector connector;
    private JmsSupport jms;

    public JasmineJmsMessageDispatcher(UMOImmutableEndpoint endpoint) {
        super(endpoint);
        this.connector = (JmsConnector)endpoint.getConnector();
        this.jms = this.connector.getJmsSupport();
    }

    protected void doDispatch(UMOEvent event) throws Exception {
        this.logger.debug((Object)"");
        this.dispatchMessage(event);
    }

    protected void doConnect() throws Exception {
        this.logger.debug((Object)"");
    }

    protected void doDisconnect() throws Exception {
        this.logger.debug((Object)"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UMOMessage dispatchMessage(UMOEvent event) throws Exception {
        Session session = null;
        MessageProducer producer = null;
        boolean transacted = false;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("dispatching on endpoint: " + event.getEndpoint().getEndpointURI() + ". Event id is: " + event.getId()));
        }
        try {
            boolean persistent;
            session = this.connector.getSessionFromTransaction();
            if (session != null) {
                transacted = true;
            } else {
                session = this.connector.getSession(event.getEndpoint());
                if (event.getEndpoint().getTransactionConfig().isTransacted()) {
                    transacted = true;
                }
            }
            UMOEndpointURI endpointUri = event.getEndpoint().getEndpointURI();
            boolean topic = this.connector.getTopicResolver().isTopic(event.getEndpoint(), true);
            Destination dest = this.jms.createDestination(session, endpointUri.getAddress(), topic);
            producer = this.jms.createProducer(session, dest, topic);
            Object message = event.getTransformedMessage();
            if (!(message instanceof Message)) {
                throw new DispatchException(JmsMessages.checkTransformer("JMS message", message.getClass(), this.connector.getName()), event.getMessage(), event.getEndpoint());
            }
            Message msg = (Message)message;
            if (event.getMessage().getCorrelationId() != null) {
                msg.setJMSCorrelationID(event.getMessage().getCorrelationId());
            }
            UMOMessage eventMsg = event.getMessage();
            String ttlString = (String)eventMsg.removeProperty("timeToLive");
            String priorityString = (String)eventMsg.removeProperty("priority");
            String persistentDeliveryString = (String)eventMsg.removeProperty("persistentDelivery");
            long ttl = StringUtils.isNotBlank(ttlString) ? NumberUtils.toLong(ttlString) : 0L;
            int priority = StringUtils.isNotBlank(priorityString) ? NumberUtils.toInt(priorityString) : 4;
            boolean bl = persistent = StringUtils.isNotBlank(persistentDeliveryString) ? BooleanUtils.toBoolean(persistentDeliveryString) : this.connector.isPersistentDelivery();
            if (this.connector.isHonorQosHeaders()) {
                int priorityProp = eventMsg.getIntProperty("JMSPriority", -1);
                int deliveryModeProp = eventMsg.getIntProperty("JMSDeliveryMode", -1);
                if (priorityProp != -1) {
                    priority = priorityProp;
                }
                if (deliveryModeProp != -1) {
                    boolean bl2 = persistent = deliveryModeProp == 2;
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Sending message of type " + ClassUtils.getSimpleName(msg.getClass())));
            }
            this.jms.send(producer, msg, persistent, priority, ttl, topic);
            UMOMessage uMOMessage = null;
            this.connector.closeQuietly(producer);
            if (session != null && !transacted) {
                this.connector.closeQuietly(session);
            }
            return uMOMessage;
        }
        catch (Throwable throwable) {
            this.connector.closeQuietly(producer);
            if (session != null && !transacted) {
                this.connector.closeQuietly(session);
            }
            throw throwable;
        }
    }

    protected UMOMessage doSend(UMOEvent event) throws Exception {
        this.logger.debug((Object)"");
        UMOMessage message = this.dispatchMessage(event);
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected UMOMessage doReceive(long timeout) throws Exception {
        Message message;
        MessageConsumer consumer;
        Session session;
        block12: {
            String durableName;
            session = null;
            consumer = null;
            this.logger.debug((Object)"");
            boolean topic = this.connector.getTopicResolver().isTopic(this.endpoint);
            session = this.connector.getSession(false, topic);
            Destination dest = this.jms.createDestination(session, this.endpoint.getEndpointURI().getAddress(), topic);
            String selector = null;
            if (this.endpoint.getFilter() != null && this.endpoint.getFilter() instanceof JmsSelectorFilter) {
                selector = ((JmsSelectorFilter)this.endpoint.getFilter()).getExpression();
            } else if (this.endpoint.getProperties() != null) {
                selector = (String)this.endpoint.getProperties().get("selector");
            }
            String tempDurable = (String)this.endpoint.getProperties().get("durable");
            boolean durable = this.connector.isDurable();
            if (tempDurable != null) {
                durable = Boolean.valueOf(tempDurable);
            }
            if ((durableName = (String)this.endpoint.getProperties().get("durableName")) == null && durable && topic) {
                durableName = "mule." + this.connector.getName() + "." + this.endpoint.getEndpointURI().getAddress();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Jms Connector for this receiver is durable but no durable name has been specified. Defaulting to: " + durableName));
                }
            }
            consumer = this.jms.createConsumer(session, dest, selector, this.connector.isNoLocal(), durableName, topic);
            message = timeout == -1L ? consumer.receiveNoWait() : (timeout == 0L ? consumer.receive() : consumer.receive(timeout));
            if (message != null) break block12;
            UMOMessage uMOMessage = null;
            this.connector.closeQuietly(consumer);
            this.connector.closeQuietly(session);
            return uMOMessage;
        }
        message = this.connector.preProcessMessage(message, session);
        MuleMessage muleMessage = new MuleMessage(this.connector.getMessageAdapter(message));
        this.connector.closeQuietly(consumer);
        this.connector.closeQuietly(session);
        return muleMessage;
        {
            catch (Exception e) {
                try {
                    this.connector.handleException(e);
                    UMOMessage uMOMessage = null;
                    this.connector.closeQuietly(consumer);
                    this.connector.closeQuietly(session);
                    return uMOMessage;
                }
                catch (Throwable throwable) {
                    this.connector.closeQuietly(consumer);
                    this.connector.closeQuietly(session);
                    throw throwable;
                }
            }
        }
    }

    protected void doDispose() {
        this.logger.debug((Object)"");
    }
}

