/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.df.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineSingleNumberResult;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.collectors.JCollector;
import org.ow2.jasmine.probe.collectors.df.internal.DfCollector;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class DiskFree
extends Thread {
    private Log logger = LogFactory.getLog(JCollector.class);
    private boolean started = false;
    private long collectorTimeout = 1000L;
    private static final long DEFAULT_TIMEOUT = 1000L;
    private Collection<DfCollector> collectors = new ArrayList<DfCollector>();
    private HashMap<String, Integer> freespace = null;

    public synchronized void remove() {
        this.collectors.clear();
        this.started = false;
    }

    public synchronized void addCollector(DfCollector col) {
        this.collectors.add(col);
        if (!this.started) {
            this.started = true;
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.started) {
            Object coll2;
            Object removed;
            DiskFree diskFree = this;
            synchronized (diskFree) {
                removed = new ArrayList<DfCollector>();
                for (Object coll2 : this.collectors) {
                    if (!coll2.isRemoved()) continue;
                    ((ArrayList)removed).add(coll2);
                }
                Iterator<DfCollector> i$ = ((ArrayList)removed).iterator();
                while (i$.hasNext()) {
                    coll2 = i$.next();
                    this.collectors.remove(coll2);
                }
            }
            ArrayList<DfCollector> collupdate = new ArrayList<DfCollector>();
            removed = this;
            synchronized (removed) {
                for (Object coll2 : this.collectors) {
                    if (!coll2.needResult()) continue;
                    collupdate.add((DfCollector)((Object)coll2));
                }
            }
            if (!collupdate.isEmpty()) {
                long time = System.currentTimeMillis();
                try {
                    this.getDiskUsage();
                    coll2 = this;
                    synchronized (coll2) {
                        for (DfCollector coll3 : collupdate) {
                            JasmineSingleResult jsr;
                            String jsrname;
                            Integer val;
                            String name = coll3.getIndicator().getName();
                            JasmineIndicatorValue jiv = new JasmineIndicatorValue();
                            jiv.setName(name);
                            if (coll3.getDiskList() == null) {
                                for (String disk : this.freespace.keySet()) {
                                    val = this.freespace.get(disk);
                                    if (val == null) {
                                        this.logger.error((Object)("No value for " + disk), new Object[0]);
                                    }
                                    jsrname = disk;
                                    jsr = this.getJsr(jsrname, time, val);
                                    jiv.addValue(jsr);
                                }
                            } else {
                                for (String disk : coll3.getDiskList()) {
                                    val = this.freespace.get(disk);
                                    if (val == null) {
                                        this.logger.error((Object)("No value for " + disk), new Object[0]);
                                    }
                                    jsrname = disk;
                                    jsr = this.getJsr(jsrname, time, val);
                                    jiv.addValue(jsr);
                                }
                                if (coll3.getDiskList().size() == 1) {
                                    jiv.setMultiValue(false);
                                }
                            }
                            coll3.addResult(jiv);
                        }
                    }
                    this.collectorTimeout = 1000L;
                }
                catch (IOException e) {
                    this.logger.error((Object)("Cannot run df: " + e), new Object[0]);
                    this.collectorTimeout *= 2L;
                }
                catch (InterruptedException e) {
                    this.logger.error((Object)("Cannot run df: " + e), new Object[0]);
                    this.collectorTimeout *= 2L;
                }
            }
            DiskFree diskFree2 = this;
            synchronized (diskFree2) {
                try {
                    this.wait(this.collectorTimeout);
                }
                catch (InterruptedException e) {
                    this.logger.warn((Object)(this.getName() + ": collector interrupted"), new Object[]{e});
                }
                catch (Exception e) {
                    this.logger.warn((Object)(this.getName() + ": collector exception"), new Object[]{e});
                }
            }
        }
    }

    private void getDiskUsage() throws IOException, InterruptedException {
        String line;
        this.freespace = new HashMap();
        String cmd = "df -l";
        Runtime run = Runtime.getRuntime();
        Process pr = run.exec(cmd);
        pr.waitFor();
        BufferedReader buf = new BufferedReader(new InputStreamReader(pr.getInputStream()));
        while ((line = buf.readLine()) != null) {
            if (!line.startsWith("/dev/")) continue;
            StringTokenizer stk = new StringTokenizer(line);
            String name = stk.nextToken().substring(5);
            Integer free = 0;
            while (stk.hasMoreTokens()) {
                String tok = stk.nextToken();
                int len = tok.length();
                if (!tok.endsWith("%") || len <= 1) continue;
                free = new Integer(tok.substring(0, len - 1));
            }
            this.freespace.put(name, free);
        }
    }

    private JasmineSingleResult getJsr(String name, long time, int value) {
        JasmineSingleNumberResult jsr = new JasmineSingleNumberResult();
        jsr.setName(name);
        jsr.setTimestamp(time);
        jsr.setValue((Object)value);
        return jsr;
    }
}

