/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.jmx.internal;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.jasmine.probe.collectors.jmx.internal.ComplexValuesException;
import org.ow2.jasmine.probe.collectors.jmx.internal.ComplexValuesUtil;
import org.ow2.jasmine.probe.collectors.jmx.internal.FragmentNameException;
import org.ow2.jasmine.probe.collectors.jmx.internal.FragmentUtil;
import org.ow2.jasmine.probe.collectors.jmx.internal.JmxCollector;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JmxUtil {
    private static Log logger = LogFactory.getLog(JmxCollector.class);

    public static Set<ObjectName> getMBeans(MBeanServerConnection cnx, ObjectName on) throws IOException {
        QueryExp query = null;
        return cnx.queryNames(on, query);
    }

    public static List<String> getMBeanAttNames(MBeanServerConnection cnx, ObjectName on) throws IOException, JMException {
        MBeanAttributeInfo[] attsInfo;
        ArrayList<String> attNames = new ArrayList<String>();
        MBeanInfo mbeanInfo = cnx.getMBeanInfo(on);
        for (MBeanAttributeInfo attInfo : attsInfo = mbeanInfo.getAttributes()) {
            String attName = attInfo.getName();
            attNames.add(attName);
        }
        return attNames;
    }

    public static ObjectName getObjectName(String pattern) throws JasmineCollectorException {
        ObjectName objname = null;
        try {
            objname = ObjectName.getInstance(pattern);
        }
        catch (MalformedObjectNameException e) {
            throw new JasmineCollectorException("Malformed pattern: " + pattern + " (" + e.toString() + " )");
        }
        catch (NullPointerException e) {
            throw new JasmineCollectorException("Null pattern");
        }
        return objname;
    }

    public static Attribute createNewIndexedAttribute(String contName, String index, Object elemValue) {
        String attName = FragmentUtil.nameForIndexElement(contName, index);
        Object attValue = elemValue;
        return new Attribute(attName, attValue);
    }

    public static Attribute createNewItemAttribute(String contName, String key, Object itemValue) {
        String attName = FragmentUtil.nameForItem(contName, key);
        Object attValue = itemValue;
        return new Attribute(attName, attValue);
    }

    public static Attribute getAttributeFragment(String name, Attribute att) throws FragmentNameException {
        if (name.equals(att.getName())) {
            return att;
        }
        if (FragmentUtil.nextElementIsKey(name, att.getName())) {
            String key = FragmentUtil.getKeyName(name, att.getName());
            try {
                Object itemValue = ComplexValuesUtil.getItem(att.getValue(), key);
                Attribute newAtt = JmxUtil.createNewItemAttribute(att.getName(), key, itemValue);
                return JmxUtil.getAttributeFragment(name, newAtt);
            }
            catch (ComplexValuesException e) {
                e.printStackTrace();
                throw new FragmentNameException("Could not extract an attribute fragment having name: " + name + ". The source attribute has name: " + att.getName());
            }
        }
        if (FragmentUtil.nextElementIsIndex(name, att.getName())) {
            String indexes = FragmentUtil.getIndexes(name, att.getName());
            try {
                Object indexedValue = ComplexValuesUtil.getElement(att.getValue(), indexes);
                Attribute newAtt = JmxUtil.createNewIndexedAttribute(att.getName(), indexes, indexedValue);
                return JmxUtil.getAttributeFragment(name, newAtt);
            }
            catch (ComplexValuesException e) {
                e.printStackTrace();
                throw new FragmentNameException("Could not extract an attribute fragment having name: " + name + ". The source attribute has name: " + att.getName());
            }
        }
        throw new FragmentNameException("Could not extract an attribute fragment having name: " + name + ". The source attribute has name: " + att.getName());
    }

    public static List<Attribute> getAttributeFragments(Attribute att) throws ComplexValuesException {
        ArrayList<Attribute> result = new ArrayList<Attribute>();
        String name = att.getName();
        Object value = att.getValue();
        if (ComplexValuesUtil.hasSimpleType(value)) {
            logger.debug((Object)("Return final fragment with name: " + name + " and value: " + value), new Object[0]);
            result.add(att);
            return result;
        }
        if (value instanceof CompositeData) {
            CompositeData compValue = (CompositeData)value;
            Set<String> keys = compValue.getCompositeType().keySet();
            for (String key : keys) {
                Object item = ComplexValuesUtil.getCompositeItem(compValue, key);
                String itemName = FragmentUtil.getNameForItem(name, key);
                Attribute newAttribute = new Attribute(itemName, item);
                result.addAll(JmxUtil.getAttributeFragments(newAttribute));
            }
            return result;
        }
        if (value instanceof TabularData) {
            TabularData tabData = (TabularData)value;
            Collection<?> values = tabData.values();
            for (Object tabValue : values) {
                CompositeData compValue = (CompositeData)tabValue;
                Object[] indexes = tabData.calculateIndex(compValue);
                String elemName = FragmentUtil.getNameForTabularElement(name, indexes);
                Attribute newAttribute = new Attribute(elemName, compValue);
                result.addAll(JmxUtil.getAttributeFragments(newAttribute));
            }
            return result;
        }
        if (value instanceof Map) {
            Map mapVal = (Map)value;
            Set keys = mapVal.keySet();
            for (Object key : keys) {
                String skey = key.toString();
                Object item = ComplexValuesUtil.getMapItem(mapVal, skey);
                String itemName = FragmentUtil.getNameForItem(name, skey);
                Attribute newAttribute = new Attribute(itemName, item);
                result.addAll(JmxUtil.getAttributeFragments(newAttribute));
            }
            return result;
        }
        if (value instanceof List) {
            List listVal = (List)value;
            for (int i = 0; i < listVal.size(); ++i) {
                String index = new Integer(i).toString();
                Object item = ComplexValuesUtil.getListElement(listVal, index);
                String itemName = FragmentUtil.getNameForItem(name, index);
                Attribute newAttribute = new Attribute(itemName, item);
                result.addAll(JmxUtil.getAttributeFragments(newAttribute));
            }
            return result;
        }
        if (value.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(value); ++i) {
                Object elem = Array.get(value, i);
                String elemName = FragmentUtil.getNameForArrayElement(name, new Integer(i).toString());
                Attribute newAttribute = new Attribute(elemName, elem);
                result.addAll(JmxUtil.getAttributeFragments(newAttribute));
            }
            return result;
        }
        throw new ComplexValuesException("Complex elements other then CompositeData, TabularData, Map, List, Array or Object[] are not supported");
    }

    protected static AttributeList getAttributes(MBeanServerConnection cnx, ObjectName objname, List<String> attNames) throws IOException, JMException {
        AttributeList attl = cnx.getAttributes(objname, attNames.toArray(new String[0]));
        logger.debug((Object)"attributes polled for MBean {0} :", new Object[]{objname.toString()});
        for (String attName : attNames) {
            logger.debug((Object)attName, new Object[0]);
        }
        return attl;
    }

    protected static AttributeList getAttributes(MBeanServerConnection cnx, ObjectName objname) throws IOException, JMException {
        List<String> attNames = JmxUtil.getMBeanAttNames(cnx, objname);
        AttributeList attl = cnx.getAttributes(objname, attNames.toArray(new String[0]));
        logger.debug((Object)"attributes polled for MBean {0} :", new Object[]{objname.toString()});
        for (String attName : attNames) {
            logger.debug((Object)attName, new Object[0]);
        }
        return attl;
    }

    private static Attribute getAttribute(AttributeList atts, String attName) {
        for (Attribute att : atts.asList()) {
            if (!att.getName().equals(attName)) continue;
            return att;
        }
        return null;
    }

    protected static AttributeList getAttributesForProvidedNames(MBeanServerConnection cnx, ObjectName objname, Collection<String> names, String indicName) throws IOException, JMException {
        AttributeList attl = new AttributeList();
        HashMap<String, String> attNamesToPoll = new HashMap<String, String>();
        List<String> allAttNames = JmxUtil.getMBeanAttNames(cnx, objname);
        for (String name : names) {
            String attName;
            block15: {
                attName = null;
                if (FragmentUtil.isFragmentName(name)) {
                    try {
                        String fragAttName = FragmentUtil.getAttributeName(name);
                        if (allAttNames.contains(fragAttName)) {
                            attName = fragAttName;
                            break block15;
                        }
                        logger.error((Object)"Cannot poll fragment {0} (no attribute named {1} exists in MBean {2})", new Object[]{name, fragAttName, objname});
                    }
                    catch (FragmentNameException e) {
                        logger.error((Object)"Cannot poll fragment {0}, incorrect format !", new Object[0]);
                    }
                } else if (allAttNames.contains(name)) {
                    attName = name;
                } else {
                    logger.error((Object)"Cannot poll attribute {0} (does not exists in MBean {1})", new Object[]{name, objname});
                }
            }
            if (attName == null) continue;
            attNamesToPoll.put(name, attName);
        }
        Set namesToPull = attNamesToPoll.keySet();
        if (namesToPull.isEmpty()) {
            logger.info((Object)"No attributes to poll in MBean {0} (based on indicator {0} definition)", new Object[]{objname, indicName});
            return attl;
        }
        String[] attNamesToPull = new String[namesToPull.size()];
        logger.debug((Object)"To pull for MBean {0} :", new Object[]{objname});
        int i = 0;
        for (String nameToPoll : namesToPull) {
            String attNameToPull = (String)attNamesToPoll.get(nameToPoll);
            attNamesToPull[i++] = attNameToPull;
            logger.debug((Object)"name {0} - attribute {1}", new Object[]{nameToPoll, attNameToPull});
        }
        AttributeList atts = cnx.getAttributes(objname, attNamesToPull);
        HashMap<String, Attribute> attsToPoll = new HashMap<String, Attribute>();
        for (String nameToPoll : namesToPull) {
            String attName = (String)attNamesToPoll.get(nameToPoll);
            attsToPoll.put(nameToPoll, JmxUtil.getAttribute(atts, attName));
        }
        for (String nameToPoll : namesToPull) {
            Attribute attToPoll = (Attribute)attsToPoll.get(nameToPoll);
            if (FragmentUtil.isFragmentName(nameToPoll)) {
                try {
                    Attribute att = JmxUtil.getAttributeFragment(nameToPoll, attToPoll);
                    attl.add(att);
                }
                catch (FragmentNameException e) {
                    logger.error((Object)"Cannot poll fragment {0} ({1})", new Object[]{nameToPoll, e.toString()});
                }
                continue;
            }
            attl.add(attToPoll);
        }
        return attl;
    }

    protected static boolean hasAttributes(List<String> attrlist) {
        if (attrlist == null || attrlist.isEmpty()) {
            return false;
        }
        if (attrlist.size() == 1) {
            for (String elem : attrlist) {
                if (!"all".equals(elem)) continue;
                return false;
            }
        }
        return true;
    }
}

