/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.shell;

import java.util.List;
import java.util.Set;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.HandlerDeclaration;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.service.command.CommandSession;
import org.ow2.jasmine.probe.JasmineOutput;
import org.ow2.jasmine.probe.JasmineProbeManager;
import org.ow2.jasmine.probe.shell.Util;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

@Command(name="output-list", scope="jasmine", description="List JASMINe outputs")
@Component
@HandlerDeclaration(value="<sh:command xmlns:sh='org.ow2.shelbie'/>")
public class OutputList
implements Action,
Pojo {
    private InstanceManager __IM;
    private boolean __FprobeManager;
    @Requires
    JasmineProbeManager probeManager;
    private boolean __Fname;
    @Argument(index=0, name="name", description="Output Name", required=false, multiValued=false)
    private String name;
    private boolean __Ftype;
    @Option(name="-t", aliases={"--type"}, description="Output Type", required=false, multiValued=false)
    private String type;
    private boolean __Fverbose;
    @Option(name="-v", aliases={"--verbose"}, description="If true, print details about outputs", required=false, multiValued=false)
    private Boolean verbose;
    protected static Log logger = LogFactory.getLog(Util.class);
    private boolean __Mexecute$org_apache_felix_service_command_CommandSession;

    JasmineProbeManager __getprobeManager() {
        if (!this.__FprobeManager) {
            return this.probeManager;
        }
        return (JasmineProbeManager)this.__IM.onGet((Object)this, "probeManager");
    }

    void __setprobeManager(JasmineProbeManager jasmineProbeManager) {
        if (!this.__FprobeManager) {
            this.probeManager = jasmineProbeManager;
            return;
        }
        this.__IM.onSet((Object)this, "probeManager", (Object)jasmineProbeManager);
    }

    String __getname() {
        if (!this.__Fname) {
            return this.name;
        }
        return (String)this.__IM.onGet((Object)this, "name");
    }

    void __setname(String string) {
        if (!this.__Fname) {
            this.name = string;
            return;
        }
        this.__IM.onSet((Object)this, "name", (Object)string);
    }

    String __gettype() {
        if (!this.__Ftype) {
            return this.type;
        }
        return (String)this.__IM.onGet((Object)this, "type");
    }

    void __settype(String string) {
        if (!this.__Ftype) {
            this.type = string;
            return;
        }
        this.__IM.onSet((Object)this, "type", (Object)string);
    }

    Boolean __getverbose() {
        if (!this.__Fverbose) {
            return this.verbose;
        }
        return (Boolean)this.__IM.onGet((Object)this, "verbose");
    }

    void __setverbose(Boolean bl) {
        if (!this.__Fverbose) {
            this.verbose = bl;
            return;
        }
        this.__IM.onSet((Object)this, "verbose", (Object)bl);
    }

    public OutputList() {
        this(null);
    }

    private OutputList(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setprobeManager(null);
        this.__settype(null);
        this.__setverbose(false);
    }

    public Object execute(CommandSession commandSession) {
        Object object;
        if (!this.__Mexecute$org_apache_felix_service_command_CommandSession) {
            return this.__execute(commandSession);
        }
        try {
            this.__IM.onEntry((Object)this, "execute$org_apache_felix_service_command_CommandSession", new Object[]{commandSession});
            object = this.__execute(commandSession);
            this.__IM.onExit((Object)this, "execute$org_apache_felix_service_command_CommandSession", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "execute$org_apache_felix_service_command_CommandSession", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __execute(CommandSession commandSession) {
        logger.debug((Object)"", new Object[0]);
        try {
            if (this.__getname() == null) {
                List objs = this.__getprobeManager().getOutputs();
                if (objs.isEmpty()) {
                    String message1 = "There are no JasmineOutputs";
                    String message2 = this.__gettype() != null ? " of type " + this.__gettype() : "";
                    logger.error((Object)(message1 + message2), new Object[0]);
                    return null;
                }
                for (JasmineOutput obj : objs) {
                    if (this.__getverbose().booleanValue()) {
                        System.out.println(obj.toLine());
                        continue;
                    }
                    System.out.println(obj.getName());
                }
            } else {
                JasmineOutput obj = this.__getprobeManager().getOutput(this.__getname());
                System.out.println(obj.toString());
            }
        }
        catch (Exception e) {
            logger.error((Object)"output-list failed: ", new Object[]{e});
        }
        return null;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("probeManager")) {
                this.__FprobeManager = true;
            }
            if (set.contains("verbose")) {
                this.__Fverbose = true;
            }
            if (set.contains("name")) {
                this.__Fname = true;
            }
            if (set.contains("type")) {
                this.__Ftype = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null && set.contains("execute$org_apache_felix_service_command_CommandSession")) {
            this.__Mexecute$org_apache_felix_service_command_CommandSession = true;
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

