/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.shell;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.HandlerDeclaration;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.service.command.CommandSession;
import org.ow2.jasmine.probe.JasmineProbeManager;
import org.ow2.jasmine.probe.JasmineTarget;
import org.ow2.jasmine.probe.shell.Util;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

@Command(name="target-create", scope="jasmine", description="Create a JASMINe target")
@Component
@HandlerDeclaration(value="<sh:command xmlns:sh='org.ow2.shelbie'/>")
public class TargetCreate
implements Action,
Pojo {
    private InstanceManager __IM;
    private boolean __FprobeManager;
    @Requires
    JasmineProbeManager probeManager;
    private boolean __Fname;
    @Argument(index=0, name="name", description="Target Name", required=true, multiValued=false)
    private String name;
    private boolean __Ftype;
    @Option(name="-t", aliases={"--type"}, description="Target Type", required=false, multiValued=false)
    private String type;
    private boolean __Fparams;
    @Option(name="-d", aliases={"--define"}, description="Specific target properties given in key=value format", required=false, multiValued=true)
    private List<String> params;
    private boolean __Furl;
    @Option(name="-u", aliases={"--url"}, description="Deprecated. Use -d url instead", required=false, multiValued=false)
    private String url;
    protected static Log logger = LogFactory.getLog(Util.class);
    private boolean __Mexecute$org_apache_felix_service_command_CommandSession;

    JasmineProbeManager __getprobeManager() {
        if (!this.__FprobeManager) {
            return this.probeManager;
        }
        return (JasmineProbeManager)this.__IM.onGet((Object)this, "probeManager");
    }

    void __setprobeManager(JasmineProbeManager jasmineProbeManager) {
        if (!this.__FprobeManager) {
            this.probeManager = jasmineProbeManager;
            return;
        }
        this.__IM.onSet((Object)this, "probeManager", (Object)jasmineProbeManager);
    }

    String __getname() {
        if (!this.__Fname) {
            return this.name;
        }
        return (String)this.__IM.onGet((Object)this, "name");
    }

    void __setname(String string) {
        if (!this.__Fname) {
            this.name = string;
            return;
        }
        this.__IM.onSet((Object)this, "name", (Object)string);
    }

    String __gettype() {
        if (!this.__Ftype) {
            return this.type;
        }
        return (String)this.__IM.onGet((Object)this, "type");
    }

    void __settype(String string) {
        if (!this.__Ftype) {
            this.type = string;
            return;
        }
        this.__IM.onSet((Object)this, "type", (Object)string);
    }

    List __getparams() {
        if (!this.__Fparams) {
            return this.params;
        }
        return (List)this.__IM.onGet((Object)this, "params");
    }

    void __setparams(List list) {
        if (!this.__Fparams) {
            this.params = list;
            return;
        }
        this.__IM.onSet((Object)this, "params", (Object)list);
    }

    String __geturl() {
        if (!this.__Furl) {
            return this.url;
        }
        return (String)this.__IM.onGet((Object)this, "url");
    }

    void __seturl(String string) {
        if (!this.__Furl) {
            this.url = string;
            return;
        }
        this.__IM.onSet((Object)this, "url", (Object)string);
    }

    public TargetCreate() {
        this(null);
    }

    private TargetCreate(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setprobeManager(null);
    }

    public Object execute(CommandSession commandSession) {
        Object object;
        if (!this.__Mexecute$org_apache_felix_service_command_CommandSession) {
            return this.__execute(commandSession);
        }
        try {
            this.__IM.onEntry((Object)this, "execute$org_apache_felix_service_command_CommandSession", new Object[]{commandSession});
            object = this.__execute(commandSession);
            this.__IM.onExit((Object)this, "execute$org_apache_felix_service_command_CommandSession", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "execute$org_apache_felix_service_command_CommandSession", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __execute(CommandSession commandSession) {
        logger.debug((Object)"", new Object[0]);
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            if (this.__getparams() != null) {
                for (String param : this.__getparams()) {
                    if (Util.validParam(param)) {
                        int indexEqual = param.indexOf("=");
                        String paramName = param.substring(0, indexEqual);
                        String paramValue = param.substring(indexEqual + 1, param.length());
                        properties.put(paramName, paramValue);
                        continue;
                    }
                    logger.error((Object)("target-create " + this.__getname() + " failed"), new Object[0]);
                    logger.error((Object)("Wrong properties format for " + param), new Object[0]);
                    logger.error((Object)"Expected format is paramName=paramValue", new Object[0]);
                    return null;
                }
            }
            if (this.__geturl() != null) {
                properties.put("url", this.__geturl());
            }
            if (this.__gettype() == null) {
                this.__settype("jmx");
            }
            JasmineTarget n = new JasmineTarget();
            n.setName(this.__getname());
            n.setType(this.__gettype());
            n.setProperties(properties);
            this.__getprobeManager().createTarget(n);
            logger.info((Object)("target-create " + this.__getname() + " successful"), new Object[0]);
        }
        catch (Exception e) {
            logger.error((Object)("target-create " + this.__getname() + " failed"), new Object[]{e});
        }
        return null;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("probeManager")) {
                this.__FprobeManager = true;
            }
            if (set.contains("name")) {
                this.__Fname = true;
            }
            if (set.contains("params")) {
                this.__Fparams = true;
            }
            if (set.contains("type")) {
                this.__Ftype = true;
            }
            if (set.contains("url")) {
                this.__Furl = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null && set.contains("execute$org_apache_felix_service_command_CommandSession")) {
            this.__Mexecute$org_apache_felix_service_command_CommandSession = true;
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

