/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulation.annotations;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.felix.ipojo.manipulation.annotations.CustomAnnotationVisitor;
import org.apache.felix.ipojo.manipulation.annotations.FieldCollector;
import org.apache.felix.ipojo.manipulation.annotations.MethodCollector;
import org.apache.felix.ipojo.manipulation.annotations.PropertyAnnotationParser;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.EmptyVisitor;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class MetadataCollector
extends EmptyVisitor
implements Opcodes {
    private String m_className;
    private Element m_elem = null;
    private boolean m_containsComponentAnnotation = false;
    private boolean m_ignoredBecauseOfMissingComponent = false;
    private Map m_ids = new HashMap();
    private Map m_elements = new HashMap();
    private Element m_instance;
    private DocumentBuilder m_builder;

    public Element getComponentTypeDeclaration() {
        return this.m_elem;
    }

    public Element getInstanceDeclaration() {
        return this.m_instance;
    }

    public boolean isComponentType() {
        return this.m_containsComponentAnnotation;
    }

    public boolean isIgnoredBecauseOfMissingComponent() {
        return this.m_ignoredBecauseOfMissingComponent;
    }

    public String getClassName() {
        return this.m_className;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.m_ids = new HashMap();
        this.m_elements = new HashMap();
        this.m_className = name;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (desc.equals("Lorg/apache/felix/ipojo/annotations/Component;")) {
            this.m_elem = new Element("component", "");
            this.m_containsComponentAnnotation = true;
            this.m_elem.addAttribute(new Attribute("className", this.m_className.replace('/', '.')));
            return new ComponentVisitor();
        }
        if (desc.equals("Lorg/apache/felix/ipojo/annotations/Handler;")) {
            this.m_elem = new Element("handler", "");
            this.m_containsComponentAnnotation = true;
            this.m_elem.addAttribute(new Attribute("classname", this.m_className.replace('/', '.')));
            return new HandlerVisitor();
        }
        if (desc.equals("Lorg/apache/felix/ipojo/annotations/Provides;")) {
            return new ProvidesVisitor();
        }
        if (desc.equals("Lorg/apache/felix/ipojo/annotations/HandlerDeclaration;")) {
            return new HandlerDeclarationVisitor();
        }
        if (desc.equals("Lorg/apache/felix/ipojo/annotations/Instantiate;")) {
            return new InstantiateVisitor();
        }
        if (CustomAnnotationVisitor.isCustomAnnotation(desc)) {
            Element elem = CustomAnnotationVisitor.buildElement(desc);
            return new CustomAnnotationVisitor(elem, this, true, true);
        }
        return null;
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return new FieldCollector(name, this);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        return new MethodCollector(name, desc, this);
    }

    public void visitEnd() {
        if (this.m_elem == null && !this.m_elements.isEmpty()) {
            this.m_ignoredBecauseOfMissingComponent = true;
            return;
        }
        if (!this.m_containsComponentAnnotation) {
            this.m_ignoredBecauseOfMissingComponent = true;
            return;
        }
        Set elems = this.getElements().keySet();
        for (Element current : elems) {
            String reference = (String)this.getElements().get(current);
            if (reference == null) {
                this.m_elem.addElement(current);
                continue;
            }
            Element ref = (Element)this.getIds().get(reference);
            if (ref == null) {
                this.m_elem.addElement(current);
                continue;
            }
            ref.addElement(current);
        }
    }

    protected Map getIds() {
        return this.m_ids;
    }

    protected Map getElements() {
        return this.m_elements;
    }

    protected DocumentBuilder getFreshDocumentBuilder() {
        if (this.m_builder == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            try {
                this.m_builder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            return this.m_builder;
        }
        this.m_builder.reset();
        return this.m_builder;
    }

    private class HandlerDeclarationVisitor
    extends EmptyVisitor
    implements AnnotationVisitor {
        private String m_value;

        private HandlerDeclarationVisitor() {
        }

        public void visit(String arg0, Object arg1) {
            this.m_value = (String)arg1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitEnd() {
            DocumentBuilder builder = MetadataCollector.this.getFreshDocumentBuilder();
            ByteArrayInputStream is = new ByteArrayInputStream(this.m_value.getBytes());
            Document document = null;
            try {
                document = builder.parse(is);
                this.convertDOMElements(MetadataCollector.this.m_elem, document.getDocumentElement());
            }
            catch (Exception e) {
                System.err.println("[warning] Cannot convert " + this.m_value + " to iPOJO Elements.");
            }
            finally {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    System.err.println("[warning] Cannot close correctly the value input stream");
                }
            }
        }

        private void convertDOMElements(Element root, org.w3c.dom.Element xmlElement) {
            int i;
            Element converted = new Element(xmlElement.getLocalName(), xmlElement.getNamespaceURI());
            if (xmlElement.hasAttributes()) {
                NamedNodeMap attributes = xmlElement.getAttributes();
                for (i = 0; i < attributes.getLength(); ++i) {
                    Attr attr = (Attr)attributes.item(i);
                    converted.addAttribute(new Attribute(attr.getName(), attr.getNamespaceURI(), attr.getValue()));
                }
            }
            if (xmlElement.hasChildNodes()) {
                NodeList childs = xmlElement.getChildNodes();
                for (i = 0; i < childs.getLength(); ++i) {
                    this.convertDOMElements(converted, (org.w3c.dom.Element)childs.item(i));
                }
            }
            root.addElement(converted);
        }
    }

    private class HandlerVisitor
    extends EmptyVisitor
    implements AnnotationVisitor {
        private HandlerVisitor() {
        }

        public void visit(String arg0, Object arg1) {
            if (arg0.equals("name")) {
                MetadataCollector.this.m_elem.addAttribute(new Attribute("name", arg1.toString()));
                return;
            }
            if (arg0.equals("namespace")) {
                MetadataCollector.this.m_elem.addAttribute(new Attribute("namespace", arg1.toString()));
                return;
            }
            if (arg0.equals("level")) {
                MetadataCollector.this.m_elem.addAttribute(new Attribute("level", arg1.toString()));
                return;
            }
            if (arg0.equals("architecture")) {
                MetadataCollector.this.m_elem.addAttribute(new Attribute("architecture", arg1.toString()));
                return;
            }
        }
    }

    private class ComponentVisitor
    extends EmptyVisitor
    implements AnnotationVisitor {
        private String m_factory;
        private String m_immediate;
        private String m_name;
        private String m_architecture;
        private String m_propagation;
        private String m_managedservice;
        private String m_method;
        private String m_version;
        private Element m_props;

        private ComponentVisitor() {
        }

        public void visit(String arg0, Object arg1) {
            if (arg0.equals("public_factory") || arg0.equals("publicFactory")) {
                this.m_factory = arg1.toString();
                return;
            }
            if (arg0.equals("name")) {
                this.m_name = arg1.toString();
                return;
            }
            if (arg0.equals("immediate")) {
                this.m_immediate = arg1.toString();
                return;
            }
            if (arg0.equals("architecture")) {
                this.m_architecture = arg1.toString();
                return;
            }
            if (arg0.equals("propagation")) {
                this.m_propagation = arg1.toString();
                return;
            }
            if (arg0.equals("managedservice")) {
                this.m_managedservice = arg1.toString();
                return;
            }
            if (arg0.equals("factory_method") || arg0.equals("factoryMethod")) {
                this.m_method = arg1.toString();
                return;
            }
            if (arg0.equals("version")) {
                this.m_version = arg1.toString();
                return;
            }
        }

        public void visitEnd() {
            if (this.m_name == null) {
                this.m_name = MetadataCollector.this.m_className.replace('/', '.');
            }
            MetadataCollector.this.m_elem.addAttribute(new Attribute("name", this.m_name));
            if (this.m_factory != null && this.m_factory.equalsIgnoreCase("false")) {
                MetadataCollector.this.m_elem.addAttribute(new Attribute("public", "false"));
            } else {
                MetadataCollector.this.m_elem.addAttribute(new Attribute("public", "true"));
            }
            if (this.m_architecture != null) {
                MetadataCollector.this.m_elem.addAttribute(new Attribute("architecture", this.m_architecture));
            }
            if (this.m_immediate != null) {
                MetadataCollector.this.m_elem.addAttribute(new Attribute("immediate", this.m_immediate));
            }
            if (this.m_method != null) {
                MetadataCollector.this.m_elem.addAttribute(new Attribute("factory-method", this.m_method));
            }
            if (this.m_version != null) {
                MetadataCollector.this.m_elem.addAttribute(new Attribute("version", this.m_version));
            }
            if (this.m_propagation != null) {
                if (this.m_props == null) {
                    this.m_props = new Element("properties", "");
                    MetadataCollector.this.getElements().put(this.m_props, null);
                    MetadataCollector.this.getIds().put("properties", this.m_props);
                }
                this.m_props.addAttribute(new Attribute("propagation", this.m_propagation));
            }
            if (this.m_managedservice != null) {
                if (this.m_props == null) {
                    this.m_props = new Element("properties", "");
                    MetadataCollector.this.getElements().put(this.m_props, null);
                    MetadataCollector.this.getIds().put("properties", this.m_props);
                }
                this.m_props.addAttribute(new Attribute("pid", this.m_managedservice));
            }
        }
    }

    private class InstantiateVisitor
    extends EmptyVisitor
    implements AnnotationVisitor {
        private String m_name;

        private InstantiateVisitor() {
        }

        public void visit(String arg0, Object arg1) {
            if (arg0.equals("name")) {
                this.m_name = arg1.toString();
                return;
            }
        }

        public void visitEnd() {
            MetadataCollector.this.m_instance = new Element("instance", "");
            if (MetadataCollector.this.m_className != null) {
                MetadataCollector.this.m_instance.addAttribute(new Attribute("component", MetadataCollector.this.m_className.replace('/', '.')));
            }
            if (this.m_name != null) {
                MetadataCollector.this.m_instance.addAttribute(new Attribute("name", this.m_name));
            }
        }
    }

    private class ProvidesVisitor
    extends EmptyVisitor
    implements AnnotationVisitor {
        Element m_prov = new Element("provides", "");

        private ProvidesVisitor() {
        }

        public void visit(String arg0, Object arg1) {
            if (arg0.equals("factory")) {
                this.m_prov.addAttribute(new Attribute("factory", arg1.toString()));
            }
            if (arg0.equals("strategy")) {
                this.m_prov.addAttribute(new Attribute("strategy", arg1.toString()));
            }
        }

        public AnnotationVisitor visitArray(String arg0) {
            if (arg0.equals("specifications")) {
                return new InterfaceArrayVisitor();
            }
            if (arg0.equals("properties")) {
                return new EmptyVisitor(){

                    public AnnotationVisitor visitAnnotation(String ignored, String desc) {
                        return new PropertyAnnotationParser(ProvidesVisitor.this.m_prov);
                    }
                };
            }
            return null;
        }

        public void visitEnd() {
            MetadataCollector.this.getIds().put("provides", this.m_prov);
            MetadataCollector.this.getElements().put(this.m_prov, null);
        }

        private class InterfaceArrayVisitor
        extends EmptyVisitor {
            private String m_itfs;

            private InterfaceArrayVisitor() {
            }

            public void visit(String arg0, Object arg1) {
                this.m_itfs = this.m_itfs == null ? "{" + ((Type)arg1).getClassName() : this.m_itfs + "," + ((Type)arg1).getClassName();
            }

            public void visitEnd() {
                ProvidesVisitor.this.m_prov.addAttribute(new Attribute("specifications", this.m_itfs + "}"));
            }
        }
    }
}

