/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.spec.ee.validation;

import java.net.URL;
import java.util.Map;
import java.util.WeakHashMap;
import javax.validation.ValidationProviderResolver;
import javax.validation.spi.ValidationProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.ow2.spec.ee.validation.ValidationProviderResolverHolder;
import org.ow2.spec.ee.validation.ValidationProviderResolverImpl;

public class ValidationProviderActivator
implements BundleActivator,
ServiceListener,
SynchronousBundleListener {
    private ValidationProviderResolverImpl validationProviderResolver = new ValidationProviderResolverImpl();
    private ValidationProviderResolver previousValidationProviderResolver = null;
    private Map<Bundle, ValidationProvider<?>> bundlesProviders = new WeakHashMap();
    private BundleContext bundleContext = null;

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        this.previousValidationProviderResolver = ValidationProviderResolverHolder.getValidationProviderResolver();
        ValidationProviderResolverHolder.setValidationProviderResolver(this.validationProviderResolver);
        ServiceReference[] serviceReferences = this.bundleContext.getServiceReferences(ValidationProvider.class.getName(), null);
        if (serviceReferences != null) {
            for (ServiceReference serviceReference : serviceReferences) {
                ValidationProvider validationProvider = (ValidationProvider)this.bundleContext.getService(serviceReference);
                this.bundlesProviders.put(serviceReference.getBundle(), validationProvider);
                this.validationProviderResolver.addValidationProvider(null, validationProvider);
            }
        }
        this.bundleContext.addBundleListener((BundleListener)this);
        this.bundleContext.addServiceListener((ServiceListener)this, "(objectClass=" + ValidationProvider.class.getName() + ")");
        Bundle[] bundles = this.bundleContext.getBundles();
        if (bundles != null) {
            for (Bundle bundle : bundles) {
                this.loadBundle(bundle);
            }
        }
    }

    protected void loadBundle(Bundle bundle) {
        URL url = bundle.getEntry("META-INF/services/javax.validation.spi.ValidationProvider");
        if (url != null) {
            if (this.bundlesProviders.containsKey(bundle)) {
                return;
            }
            ValidationProvider<?> validationProvider = this.validationProviderResolver.getProvider(url, bundle, null);
            this.bundlesProviders.put(bundle, validationProvider);
            this.validationProviderResolver.addValidationProvider(url, validationProvider);
        }
    }

    public void stop(BundleContext context) throws Exception {
        ValidationProviderResolverHolder.setValidationProviderResolver(this.previousValidationProviderResolver);
        this.bundlesProviders.clear();
        this.validationProviderResolver.clearCachedProviders();
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference serviceRef = event.getServiceReference();
        ValidationProvider<?> validationProvider = (ValidationProvider<?>)this.bundleContext.getService(serviceRef);
        switch (event.getType()) {
            case 1: {
                if (this.bundlesProviders.containsKey(serviceRef.getBundle())) break;
                this.bundlesProviders.put(serviceRef.getBundle(), validationProvider);
                this.validationProviderResolver.addValidationProvider(null, validationProvider);
                break;
            }
            case 4: {
                if (!this.bundlesProviders.containsKey(serviceRef.getBundle())) break;
                validationProvider = this.bundlesProviders.remove(serviceRef.getBundle());
                this.validationProviderResolver.removeValidationProvider(null, validationProvider);
                break;
            }
        }
    }

    public void unloadBundle(Bundle bundle) {
        if (this.bundlesProviders.containsKey(bundle)) {
            URL url = bundle.getEntry("META-INF/services/javax.validation.spi.ValidationProvider");
            ValidationProvider<?> validationProvider = this.bundlesProviders.remove(bundle);
            this.validationProviderResolver.removeValidationProvider(url, validationProvider);
        }
    }

    public void bundleChanged(BundleEvent event) {
        if (event == null) {
            return;
        }
        Bundle bundle = event.getBundle();
        if (32 == event.getType()) {
            this.loadBundle(bundle);
        } else if (16 == event.getType() || 64 == event.getType()) {
            this.unloadBundle(bundle);
        }
    }
}

