/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.metainfo.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.CompositeName;
import org.objectweb.jorm.metainfo.api.Manager;
import org.objectweb.jorm.metainfo.api.MappingFactory;
import org.objectweb.jorm.metainfo.api.Package;
import org.objectweb.jorm.metainfo.lib.BasicMetaObject;
import org.objectweb.jorm.metainfo.lib.BasicPackage;
import org.objectweb.jorm.type.api.PTypeSpace;
import org.objectweb.jorm.type.lib.PTypeSpacePAAH;
import org.objectweb.util.monolog.api.BasicLevel;

public class JormManager
extends BasicMetaObject
implements Manager {
    protected Map packages;
    protected Map mappingFactories;
    protected PTypeSpace ptypeSpace;

    public JormManager() {
        super(null);
        this.init();
    }

    public void init() {
        this.packages = new HashMap();
        this.mappingFactories = new HashMap();
        this.ptypeSpace = new PTypeSpacePAAH();
    }

    public Package getPackage(String schemaName) {
        return (Package)this.packages.get(schemaName);
    }

    public Package createPackage(String schemaName) {
        if (this.debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("create a new Package (" + schemaName + ") for the current Manager"));
        }
        if (this.packages.get(schemaName) != null) {
            if (this.debug) {
                this.logger.log(BasicLevel.DEBUG, (Object)("The Package already exist (" + schemaName + "), return existing one"));
            }
            return (Package)this.packages.get(schemaName);
        }
        BasicPackage newPackage = new BasicPackage(schemaName, this);
        this.setLoggingOnChild(newPackage);
        this.packages.put(schemaName, newPackage);
        return newPackage;
    }

    public Collection getPackages() {
        return this.packages.values();
    }

    public void addMappingFactory(String mapperName, MappingFactory factory) {
        this.setLoggingOnChild(factory);
        this.mappingFactories.put(mapperName, factory);
    }

    public MappingFactory getMappingFactory(String mapperName) {
        if (this.debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("get the mappingFactory from " + mapperName));
        }
        return (MappingFactory)this.mappingFactories.get(mapperName);
    }

    public Collection getMappingFactories() {
        return this.mappingFactories.values();
    }

    public PTypeSpace getPTypeSpace() {
        return this.ptypeSpace;
    }

    public Collection getClasses() {
        ArrayList v = new ArrayList();
        Iterator allPackages = this.packages.values().iterator();
        while (allPackages.hasNext()) {
            v.addAll(((Package)allPackages.next()).getClasses());
        }
        return v;
    }

    public Collection getCompositeNames() {
        ArrayList v = new ArrayList();
        Iterator allPackages = this.packages.values().iterator();
        while (allPackages.hasNext()) {
            v.addAll(((Package)allPackages.next()).getCompositeNames());
        }
        return v;
    }

    public Collection getJormObjects() {
        ArrayList v = new ArrayList();
        Iterator allPackages = this.packages.values().iterator();
        while (allPackages.hasNext()) {
            Package p = (Package)allPackages.next();
            v.addAll(p.getClasses());
            v.addAll(p.getCompositeNames());
        }
        return v;
    }

    public Class getClass(String className) {
        if (this.packages == null || className == null) {
            return null;
        }
        int idx = className.lastIndexOf(".");
        Package p = null;
        if (idx == -1) {
            p = (Package)this.packages.get("");
            if (p != null) {
                return p.getClass(className);
            }
        } else {
            p = (Package)this.packages.get(className.substring(0, idx));
            if (p != null) {
                return p.getClass(className.substring(idx + 1));
            }
        }
        return null;
    }

    public Class createClass(String fqclassName) {
        if (this.packages == null || fqclassName == null) {
            return null;
        }
        int idx = fqclassName.lastIndexOf(".");
        if (idx == -1) {
            return this.createPackage("").createClass(fqclassName);
        }
        return this.createPackage(fqclassName.substring(0, idx)).createClass(fqclassName.substring(idx + 1));
    }

    public CompositeName getCompositeName(String fqcompositeNameName) {
        if (this.packages == null || fqcompositeNameName == null) {
            return null;
        }
        int idx = fqcompositeNameName.lastIndexOf(".");
        Package p = null;
        if (idx == -1) {
            p = (Package)this.packages.get("");
            if (p != null) {
                return p.getCompositeName(fqcompositeNameName);
            }
        } else {
            p = (Package)this.packages.get(fqcompositeNameName.substring(0, idx));
            if (p != null) {
                return p.getCompositeName(fqcompositeNameName.substring(idx + 1));
            }
        }
        return null;
    }

    public CompositeName createCompositeName(String fqcompositeNameName) {
        if (this.packages == null || fqcompositeNameName == null) {
            return null;
        }
        int idx = fqcompositeNameName.lastIndexOf(".");
        if (idx == -1) {
            return this.createPackage("").createCompositeName(fqcompositeNameName);
        }
        return this.createPackage(fqcompositeNameName.substring(0, idx)).createCompositeName(fqcompositeNameName.substring(idx + 1));
    }

    protected Collection getChildren() {
        return this.packages.values();
    }
}

