/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.optim.rdb;

import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.Operator;
import org.objectweb.medor.expression.api.TypingException;
import org.objectweb.medor.expression.lib.BasicOperand;
import org.objectweb.medor.expression.lib.BasicParameterOperand;
import org.objectweb.medor.expression.lib.Like;
import org.objectweb.medor.filter.rdb.lib.Like2SQLStringConverter;
import org.objectweb.medor.optim.lib.BasicRule;
import org.objectweb.medor.query.api.FilteredQueryTree;
import org.objectweb.medor.query.api.QueryNode;
import org.objectweb.medor.query.api.QueryTree;

public class Like2SQL
extends BasicRule {
    public Like2SQL() {
    }

    public Like2SQL(String suffix) {
        super(suffix);
    }

    public QueryTree rewrite(QueryTree qt, QueryNode _parent) throws MedorException {
        if (qt instanceof FilteredQueryTree) {
            FilteredQueryTree fqt = (FilteredQueryTree)qt;
            BasicRule.ModifiedExpression me = this.convertRegExpToSQLLike(fqt.getQueryFilter(), false);
            if (me.isModified) {
                fqt.setQueryFilter(me.e);
            }
        }
        if (qt instanceof QueryNode) {
            QueryTree[] children = ((QueryNode)qt).getChildren();
            for (int i = 0; i < children.length; ++i) {
                this.rewrite(children[i], (QueryNode)qt);
            }
        }
        return qt;
    }

    private BasicRule.ModifiedExpression convertRegExpToSQLLike(Expression e, boolean inLike) throws MedorException {
        BasicRule.ModifiedExpression me = new BasicRule.ModifiedExpression(e, false);
        if (inLike) {
            if (!(e instanceof Like2SQLStringConverter)) {
                if (e instanceof BasicParameterOperand) {
                    me.e = new Like2SQLStringConverter((BasicParameterOperand)e);
                    me.isModified = true;
                } else if (e.getClass().equals(BasicOperand.class)) {
                    me.isModified = true;
                    try {
                        me.e = new BasicOperand(Like2SQLStringConverter.convert(((BasicOperand)e).getString()));
                    }
                    catch (TypingException e1) {
                        throw new MedorException("Expected a basicOperand with String type", e1);
                    }
                }
            }
        } else if (e instanceof Operator) {
            if (!inLike) {
                inLike = e instanceof Like;
            }
            Operator op = (Operator)e;
            for (int i = 0; i < op.getOperandNumber(); ++i) {
                BasicRule.ModifiedExpression mei = this.convertRegExpToSQLLike(op.getExpression(i), inLike);
                if (!mei.isModified) continue;
                op.setExpression(i, mei.e);
            }
        }
        return me;
    }
}

