# ---------------------------------------------------------------------------
# JASMINe
# Copyright (C) 2012 Bull S.A.S.
# Contact: jasmine@ow2.org
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
# USA
#
# ---------------------------------------------------------------------------
# $Id$
# ---------------------------------------------------------------------------
#!/bin/sh

export JONAS_ROOT=${JPROBE_ROOT}

# Check if $JONAS_ROOT is set.
if [ -z "$JONAS_ROOT" ]; then
    echo Please set the JPROBE_ROOT variable.
    exit
fi

export JONAS_BASE=$JONAS_ROOT
export PATH=$JONAS_ROOT/bin:$PATH

# ---------------------------------------------
# Get arguments
# ---------------------------------------------
COMMAND=
OPTS=

#Parse command line
while [ -n "$1" ]; do
  if [ $1 = "start" ]; then
    COMMAND="$1"
    shift
  elif [ $1 = "stop" ]; then
    COMMAND="$1"
    shift
  else
    OPTS="$OPTS $1"
    shift
  fi
done

#OPTS=-Dhttp.proxyHost=
#OPTS=$OPTS -Dhttp.proxyPort=8080
#OPTS=$OPTS -Dhttp.nonProxyHosts="localhost|127.0.0.1"

case "$COMMAND" in
  start)
    jonas start -n jasmine-probe -clean -Djava.net.preferIPv4Stack=true $OPTS
    ;;
  stop)
    jonas stop -n jasmine-probe $OPTS
    ;;
  *)
    echo "usage : jasmine-probe start|stop [OPTIONS]"
esac
