/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe;

import java.util.ArrayList;
import java.util.List;
import org.ow2.jasmine.probe.JasmineObject;

public class JasmineIndicator
extends JasmineObject {
    private int scale = 1;
    private List<String> sources = new ArrayList<String>();

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public List<String> getSources() {
        return this.sources;
    }

    public void setSources(List<String> sources) {
        this.sources = sources == null ? new ArrayList<String>() : sources;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("JasmineIndicator " + this.name);
        buffer.append("\n> type : " + this.type);
        buffer.append("\n> scale : " + this.scale);
        buffer.append("\n> sources : " + this.sources);
        for (String key : this.properties.keySet()) {
            buffer.append("\n> " + key + " = " + (String)this.properties.get(key));
        }
        return buffer.toString();
    }

    @Override
    public String toLine() {
        String formattedName = (this.name + "                              ").substring(0, 30);
        return formattedName + this.type;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JasmineIndicator)) {
            return false;
        }
        JasmineIndicator other = (JasmineIndicator)obj;
        if (!this.name.equals(other.getName())) {
            return false;
        }
        if (!this.type.equals(other.getType())) {
            return false;
        }
        if (this.scale != other.getScale()) {
            return false;
        }
        if (this.sources.size() != other.sources.size()) {
            return false;
        }
        for (String source : this.sources) {
            if (other.sources.contains(source)) continue;
            return false;
        }
        if (this.properties.size() != other.properties.size()) {
            return false;
        }
        for (String key : this.properties.keySet()) {
            if (!other.properties.containsKey(key)) {
                return false;
            }
            String value = (String)this.properties.get(key);
            if (!(value != null ? !value.equals(other.properties.get(key)) : other.properties.get(key) != null)) continue;
            return false;
        }
        return true;
    }
}

