/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.shell;

import java.util.List;
import java.util.Set;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.HandlerDeclaration;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.service.command.CommandSession;
import org.ow2.jasmine.probe.JasmineProbe;
import org.ow2.jasmine.probe.JasmineProbeManager;
import org.ow2.jasmine.probe.shell.Util;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

@Command(name="probe-create", scope="jasmine", description="Create a JASMINe probe")
@Component
@HandlerDeclaration(value="<sh:command xmlns:sh='org.ow2.shelbie'/>")
public class ProbeCreate
implements Action,
Pojo {
    private InstanceManager __IM;
    private boolean __FprobeManager;
    @Requires
    JasmineProbeManager probeManager;
    private boolean __Fname;
    @Argument(index=0, name="name", description="Probe Name", required=true, multiValued=false)
    private String name;
    private boolean __FstartProbe;
    @Option(name="-s", aliases={"--start"}, description="Start the Probe at once", required=false, multiValued=false)
    private Boolean startProbe;
    private boolean __Fperiod;
    @Option(name="-p", aliases={"--period"}, description="Execution period in seconds", required=false, multiValued=false)
    private Integer period;
    private boolean __Findicators;
    @Option(name="-i", aliases={"--indicators"}, description="List of indicators", required=true, multiValued=true)
    private List<String> indicators;
    private boolean __Foutputs;
    @Option(name="-o", aliases={"--outputs"}, description="List of outputs", required=false, multiValued=true)
    private List<String> outputs;
    private boolean __Ftargets;
    @Option(name="-t", aliases={"--targets"}, description="List of targets", required=false, multiValued=true)
    private List<String> targets;
    protected static Log logger = LogFactory.getLog(Util.class);
    private boolean __Mexecute$org_apache_felix_service_command_CommandSession;

    JasmineProbeManager __getprobeManager() {
        if (!this.__FprobeManager) {
            return this.probeManager;
        }
        return (JasmineProbeManager)this.__IM.onGet((Object)this, "probeManager");
    }

    void __setprobeManager(JasmineProbeManager jasmineProbeManager) {
        if (!this.__FprobeManager) {
            this.probeManager = jasmineProbeManager;
            return;
        }
        this.__IM.onSet((Object)this, "probeManager", (Object)jasmineProbeManager);
    }

    String __getname() {
        if (!this.__Fname) {
            return this.name;
        }
        return (String)this.__IM.onGet((Object)this, "name");
    }

    void __setname(String string) {
        if (!this.__Fname) {
            this.name = string;
            return;
        }
        this.__IM.onSet((Object)this, "name", (Object)string);
    }

    Boolean __getstartProbe() {
        if (!this.__FstartProbe) {
            return this.startProbe;
        }
        return (Boolean)this.__IM.onGet((Object)this, "startProbe");
    }

    void __setstartProbe(Boolean bl) {
        if (!this.__FstartProbe) {
            this.startProbe = bl;
            return;
        }
        this.__IM.onSet((Object)this, "startProbe", (Object)bl);
    }

    Integer __getperiod() {
        if (!this.__Fperiod) {
            return this.period;
        }
        return (Integer)this.__IM.onGet((Object)this, "period");
    }

    void __setperiod(Integer n) {
        if (!this.__Fperiod) {
            this.period = n;
            return;
        }
        this.__IM.onSet((Object)this, "period", (Object)n);
    }

    List __getindicators() {
        if (!this.__Findicators) {
            return this.indicators;
        }
        return (List)this.__IM.onGet((Object)this, "indicators");
    }

    void __setindicators(List list) {
        if (!this.__Findicators) {
            this.indicators = list;
            return;
        }
        this.__IM.onSet((Object)this, "indicators", (Object)list);
    }

    List __getoutputs() {
        if (!this.__Foutputs) {
            return this.outputs;
        }
        return (List)this.__IM.onGet((Object)this, "outputs");
    }

    void __setoutputs(List list) {
        if (!this.__Foutputs) {
            this.outputs = list;
            return;
        }
        this.__IM.onSet((Object)this, "outputs", (Object)list);
    }

    List __gettargets() {
        if (!this.__Ftargets) {
            return this.targets;
        }
        return (List)this.__IM.onGet((Object)this, "targets");
    }

    void __settargets(List list) {
        if (!this.__Ftargets) {
            this.targets = list;
            return;
        }
        this.__IM.onSet((Object)this, "targets", (Object)list);
    }

    public ProbeCreate() {
        this(null);
    }

    private ProbeCreate(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setprobeManager(null);
        this.__setstartProbe(false);
        this.__setperiod(10);
    }

    public Object execute(CommandSession commandSession) {
        Object object;
        if (!this.__Mexecute$org_apache_felix_service_command_CommandSession) {
            return this.__execute(commandSession);
        }
        try {
            this.__IM.onEntry((Object)this, "execute$org_apache_felix_service_command_CommandSession", new Object[]{commandSession});
            object = this.__execute(commandSession);
            this.__IM.onExit((Object)this, "execute$org_apache_felix_service_command_CommandSession", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "execute$org_apache_felix_service_command_CommandSession", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __execute(CommandSession commandSession) {
        logger.debug((Object)"", new Object[0]);
        try {
            JasmineProbe n = new JasmineProbe();
            n.setId(this.__getname());
            n.setPeriod(this.__getperiod().intValue());
            n.setIndicatorList(this.__getindicators());
            if (this.__getoutputs() != null) {
                n.setOutputList(this.__getoutputs());
            }
            if (this.__gettargets() != null) {
                n.setTargetList(this.__gettargets());
            }
            this.__getprobeManager().createProbe(n);
            logger.info((Object)("Create " + this.__getname() + " successful"), new Object[0]);
        }
        catch (Exception e) {
            logger.error((Object)("Create " + this.__getname() + " failed"), new Object[]{e});
            return null;
        }
        if (this.__getstartProbe().booleanValue()) {
            try {
                this.__getprobeManager().startProbe(this.__getname());
                logger.info((Object)("probe " + this.__getname() + " started"), new Object[0]);
            }
            catch (Exception e) {
                logger.error((Object)("Starting probe " + this.__getname() + " failed"), new Object[]{e});
            }
        }
        return null;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("probeManager")) {
                this.__FprobeManager = true;
            }
            if (set.contains("name")) {
                this.__Fname = true;
            }
            if (set.contains("startProbe")) {
                this.__FstartProbe = true;
            }
            if (set.contains("outputs")) {
                this.__Foutputs = true;
            }
            if (set.contains("indicators")) {
                this.__Findicators = true;
            }
            if (set.contains("period")) {
                this.__Fperiod = true;
            }
            if (set.contains("targets")) {
                this.__Ftargets = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null && set.contains("execute$org_apache_felix_service_command_CommandSession")) {
            this.__Mexecute$org_apache_felix_service_command_CommandSession = true;
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

