/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.outers;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineOutput;
import org.ow2.jasmine.probe.JasmineProbeResult;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.outer.JasmineOuter;
import org.ow2.jasmine.probe.outers.JOuterMBean;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public abstract class JOuter
extends Thread
implements JasmineOuter,
JOuterMBean {
    protected Log logger = LogFactory.getLog(JOuter.class);
    private Queue<JasmineProbeResult> dataqueue = new ConcurrentLinkedQueue<JasmineProbeResult>();
    private boolean waiting = false;
    private long outerTimeout = 10000L;
    protected static final String SEPARATOR = ";";
    protected JasmineOutput output;
    private boolean valid = true;
    protected SimpleDateFormat dateformat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private boolean removed = false;
    private int maxQueueSize = 0;
    private int nbInserted = 0;
    private int nbRejected = 0;
    private int nbRetrieved = 0;
    String defaultPublishLocation = "";

    public abstract void processData(JasmineProbeResult var1);

    public JOuter(JasmineOutput output) {
        super("JasmineOuter-" + output.getName());
        this.output = output;
    }

    public JasmineOutput getOutput() {
        return this.output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.valid) {
            JasmineProbeResult data = null;
            JOuter jOuter = this;
            synchronized (jOuter) {
                if (this.dataqueue.isEmpty()) {
                    try {
                        this.waiting = true;
                        this.wait(this.outerTimeout);
                        this.waiting = false;
                    }
                    catch (InterruptedException e) {
                        this.logger.warn((Object)(this.getName() + ": outer interrupted"), new Object[]{e});
                    }
                    catch (Exception e) {
                        this.logger.warn((Object)(this.getName() + ": outer exception"), new Object[]{e});
                    }
                }
                data = this.dataqueue.poll();
            }
            if (data == null) continue;
            ++this.nbRetrieved;
            this.processData(data);
        }
    }

    public synchronized void stopIt() {
        this.valid = false;
        this.notify();
    }

    public void flushData() {
    }

    public String composeName(JasmineIndicatorValue jiv, String jsrName) {
        StringBuffer name = new StringBuffer(jiv.getName());
        if (jiv.isMultiValue() && jsrName != null && jsrName.length() != 0) {
            name.append(".");
            name.append(jsrName);
        }
        return name.toString();
    }

    public String findMbean(JasmineSingleResult jsr) {
        String mbean = null;
        HashMap resultProps = jsr.getProperties();
        if (!resultProps.isEmpty()) {
            for (String key : resultProps.keySet()) {
                if (!"mbean".equals(key)) continue;
                mbean = (String)resultProps.get(key);
            }
        }
        if (mbean == null) {
            mbean = "misc:type=misc";
        }
        return mbean;
    }

    public String findDomain(JasmineIndicatorValue jiv) {
        String domain = (String)jiv.getMetadata().get("domain");
        if (domain == null) {
            domain = "misc";
        }
        return domain;
    }

    public String findServer(JasmineIndicatorValue jiv) {
        String server = (String)jiv.getMetadata().get("server");
        if (server == null) {
            server = "misc";
        }
        return server;
    }

    @Override
    public String getOutputName() {
        return this.getOutput().getName();
    }

    public synchronized void publishData(JasmineProbeResult result) {
        if (this.dataqueue.offer(result)) {
            ++this.nbInserted;
            int size = this.dataqueue.size();
            if (this.maxQueueSize < size) {
                this.maxQueueSize = size;
            }
        } else {
            ++this.nbRejected;
        }
        if (this.waiting) {
            this.notify();
        }
    }

    protected String outputProps(String output, HashMap<String, String> props, String separator) {
        String result = output;
        for (String key : props.keySet()) {
            if (result.length() > 0) {
                result = result + separator;
            }
            result = result + key + "=" + props.get(key);
        }
        return result;
    }

    public void remove() {
        this.logger.debug((Object)("Mark removed " + this.getName()), new Object[0]);
        this.removed = true;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    @Override
    public int getQueueSize() {
        return this.dataqueue.size();
    }

    @Override
    public String getOutputType() {
        return this.output.getType();
    }

    @Override
    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    @Override
    public void resetMaxQueueSize() {
        this.maxQueueSize = 0;
    }

    @Override
    public int getNbInserted() {
        return this.nbInserted;
    }

    @Override
    public void resetNbInserted() {
        this.nbInserted = 0;
    }

    @Override
    public int getNbRejected() {
        return this.nbRejected;
    }

    @Override
    public void resetNbRejected() {
        this.nbRejected = 0;
    }

    @Override
    public int getNbRetrieved() {
        return this.nbRetrieved;
    }

    @Override
    public void resetNbRetrieved() {
        this.nbRetrieved = 0;
    }

    @Override
    public String getPublishLocation() {
        return this.defaultPublishLocation;
    }
}

