/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.spec.ee.validation;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.ValidationException;
import javax.validation.ValidationProviderResolver;
import javax.validation.spi.ValidationProvider;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationProviderResolverImpl
implements ValidationProviderResolver {
    public static final String METAINF_SERVICES_VALIDATION_PROVIDER = "META-INF/services/javax.validation.spi.ValidationProvider";
    private volatile List<ValidationProvider<?>> osgiValidationProviders = null;
    private volatile List<URL> urlsValidationProviders = null;
    private volatile Map<ClassLoader, List<ValidationProvider<?>>> classLoaderProviders = null;
    private Logger logger = Logger.getLogger(ValidationProviderResolverImpl.class.getName());

    public ValidationProviderResolverImpl() {
        this.osgiValidationProviders = new ArrayList();
        this.classLoaderProviders = new WeakHashMap();
        this.urlsValidationProviders = new ArrayList<URL>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCachedProviders() {
        List<ValidationProvider<?>> list = this.osgiValidationProviders;
        synchronized (list) {
            this.osgiValidationProviders.clear();
            this.urlsValidationProviders.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValidationProvider(URL url, ValidationProvider<?> validationProvider) {
        if (!this.urlsValidationProviders.contains(url)) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Adding new provider for URL " + url + ", provider = " + validationProvider);
            }
            List<ValidationProvider<?>> list = this.osgiValidationProviders;
            synchronized (list) {
                this.osgiValidationProviders.add(validationProvider);
            }
            if (url != null) {
                this.urlsValidationProviders.add(url);
            }
        } else if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Not adding new provider for URL " + url + ", provider = " + validationProvider + " as it already exists");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeValidationProvider(URL url, ValidationProvider<?> validationProvider) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Removinf validationProvider with URL " + url + ", provider = " + validationProvider);
        }
        List<ValidationProvider<?>> list = this.osgiValidationProviders;
        synchronized (list) {
            this.osgiValidationProviders.remove(validationProvider);
        }
        if (url != null && this.urlsValidationProviders.contains(url)) {
            this.urlsValidationProviders.remove(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ValidationProvider<?>> getValidationProviders() {
        ArrayList allProviders = new ArrayList();
        List<ValidationProvider<?>> list = this.osgiValidationProviders;
        synchronized (list) {
            allProviders.addAll(this.osgiValidationProviders);
        }
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        List<ValidationProvider<?>> currentClassLoaderProviders = this.classLoaderProviders.get(currentClassLoader);
        if (currentClassLoaderProviders == null) {
            currentClassLoaderProviders = this.searchProviders(currentClassLoader);
            this.classLoaderProviders.put(currentClassLoader, currentClassLoaderProviders);
        }
        allProviders.addAll(currentClassLoaderProviders);
        return allProviders;
    }

    protected List<ValidationProvider<?>> searchProviders(ClassLoader classLoader) {
        ArrayList providers = new ArrayList();
        Enumeration<URL> urls = null;
        try {
            urls = classLoader.getResources(METAINF_SERVICES_VALIDATION_PROVIDER);
        }
        catch (IOException e) {
            throw new ValidationException("Unable to find services provider", e);
        }
        if (urls != null) {
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (!this.urlsValidationProviders.contains(url)) {
                    ValidationProvider<?> validationProvider = this.getProvider(url, null, classLoader);
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.log(Level.FINE, "Adding a provider with URL = " + url + " and validationProvider " + validationProvider);
                    }
                    providers.add(validationProvider);
                    continue;
                }
                if (!this.logger.isLoggable(Level.FINE)) continue;
                this.logger.log(Level.FINE, "Not adding Validation Provider as already exists for URL '" + url);
            }
        }
        return providers;
    }

    /*
     * Exception decompiling
     */
    public ValidationProvider<?> getProvider(URL url, Bundle bundle, ClassLoader classLoader) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

