/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.commands.builtin.internal;

import java.util.Collection;
import java.util.Set;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Bind;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.HandlerDeclaration;
import org.apache.felix.service.command.CommandSession;
import org.ow2.shelbie.core.registry.CommandFilter;
import org.ow2.shelbie.core.registry.CommandRegistry;
import org.ow2.shelbie.core.registry.info.ArgumentInfo;
import org.ow2.shelbie.core.registry.info.CommandInfo;
import org.ow2.shelbie.core.registry.info.OptionInfo;
import org.ow2.shelbie.core.registry.info.ParameterInfo;
import org.ow2.shelbie.core.registry.info.ScopeInfo;

@Command(name="help", scope="shelbie", description="Display command's help")
@Component
@HandlerDeclaration(value="<sh:command xmlns:sh='org.ow2.shelbie' />")
public class HelpAction
implements Action,
Pojo {
    private InstanceManager __IM;
    private boolean __Fregistry;
    private CommandRegistry registry;
    private boolean __Flisting;
    @Option(name="-l", aliases={"--list"}, description="Output command list as a simple list (no decorations)")
    private boolean listing;
    private boolean __FcommandName;
    @Argument(description="Command name (may be scoped or un-scoped)")
    private String commandName;
    private boolean __Mexecute$org_apache_felix_service_command_CommandSession;
    private boolean __MprintCommandDetails$org_ow2_shelbie_core_registry_info_CommandInfo;
    private boolean __MprintArgument$org_ow2_shelbie_core_registry_info_ArgumentInfo;
    private boolean __MprintOption$org_ow2_shelbie_core_registry_info_OptionInfo;
    private boolean __MprintParameter$org_ow2_shelbie_core_registry_info_ParameterInfo;
    private boolean __MprintType$org_ow2_shelbie_core_registry_info_ParameterInfo;
    private boolean __MbindRegistry$org_ow2_shelbie_core_registry_CommandRegistry;

    CommandRegistry __getregistry() {
        if (!this.__Fregistry) {
            return this.registry;
        }
        return (CommandRegistry)this.__IM.onGet((Object)this, "registry");
    }

    void __setregistry(CommandRegistry commandRegistry) {
        if (!this.__Fregistry) {
            this.registry = commandRegistry;
            return;
        }
        this.__IM.onSet((Object)this, "registry", (Object)commandRegistry);
    }

    boolean __getlisting() {
        if (!this.__Flisting) {
            return this.listing;
        }
        Object object = this.__IM.onGet((Object)this, "listing");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setlisting(boolean bl) {
        if (!this.__Flisting) {
            this.listing = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "listing", (Object)bl2);
    }

    String __getcommandName() {
        if (!this.__FcommandName) {
            return this.commandName;
        }
        return (String)this.__IM.onGet((Object)this, "commandName");
    }

    void __setcommandName(String string) {
        if (!this.__FcommandName) {
            this.commandName = string;
            return;
        }
        this.__IM.onSet((Object)this, "commandName", (Object)string);
    }

    public HelpAction() {
        this(null);
    }

    private HelpAction(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setlisting(false);
    }

    public Object execute(CommandSession commandSession) throws Exception {
        Object object;
        if (!this.__Mexecute$org_apache_felix_service_command_CommandSession) {
            return this.__M_execute(commandSession);
        }
        try {
            this.__IM.onEntry((Object)this, "execute$org_apache_felix_service_command_CommandSession", new Object[]{commandSession});
            object = this.__M_execute(commandSession);
            this.__IM.onExit((Object)this, "execute$org_apache_felix_service_command_CommandSession", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "execute$org_apache_felix_service_command_CommandSession", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __M_execute(CommandSession session) throws Exception {
        if (this.__getcommandName() == null) {
            int size = 0;
            for (ScopeInfo scopeInfo : this.__getregistry().getScopes()) {
                Collection commands = scopeInfo.getCommands();
                size += commands.size();
                if (commands.isEmpty()) continue;
                if (!this.__getlisting()) {
                    System.out.printf("%nScope '%s' (%d commands)%n", scopeInfo.getName(), commands.size());
                    System.out.printf("-----------------------------------%n", new Object[0]);
                }
                for (CommandInfo command : commands) {
                    String qualifiedName = String.format("%s:%s", command.getScope(), command.getName());
                    if (command.getDescription() == null) {
                        System.out.printf("  %-40s%n", qualifiedName);
                        continue;
                    }
                    System.out.printf("  %-40s %s%n", qualifiedName, command.getDescription());
                }
            }
            if (!this.__getlisting()) {
                System.out.printf("%n===================================%n", new Object[0]);
                System.out.printf("Total: %d scopes for %d commands.%n", this.__getregistry().getScopes().size(), size);
            }
        } else {
            String[] fragments = this.__getcommandName().split(":");
            String scope = fragments.length == 1 ? null : fragments[0];
            String name = fragments.length == 1 ? fragments[0] : fragments[1];
            Object filter = scope == null ? new UnQualifiedCommandFilter(name) : new QualifiedCommandFilter(scope, name);
            Collection commands = this.__getregistry().getCommands((CommandFilter)filter);
            for (CommandInfo command : commands) {
                this.printCommandDetails(command);
                System.out.printf("%n-----------------------------------%n", new Object[0]);
            }
        }
        return null;
    }

    private void printCommandDetails(CommandInfo commandInfo) {
        if (!this.__MprintCommandDetails$org_ow2_shelbie_core_registry_info_CommandInfo) {
            this.__M_printCommandDetails(commandInfo);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "printCommandDetails$org_ow2_shelbie_core_registry_info_CommandInfo", new Object[]{commandInfo});
            this.__M_printCommandDetails(commandInfo);
            this.__IM.onExit((Object)this, "printCommandDetails$org_ow2_shelbie_core_registry_info_CommandInfo", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "printCommandDetails$org_ow2_shelbie_core_registry_info_CommandInfo", throwable);
            throw throwable;
        }
    }

    private void __M_printCommandDetails(CommandInfo command) {
        String cmdDescription = command.getDescription();
        if (HelpAction.isEmpty(cmdDescription)) {
            cmdDescription = "No description available";
        }
        System.out.printf("%nName%n", new Object[0]);
        System.out.printf("  %s - %s%n%n", command.getName(), cmdDescription);
        System.out.printf("Syntax%n", new Object[0]);
        String parameters = command.getOptions().isEmpty() ? "" : "[option(s)]...";
        parameters = parameters + (command.getArguments().isEmpty() ? "" : " [argument(s)]...");
        System.out.printf("  %s:%s %s%n", command.getScope(), command.getName(), parameters);
        if (!command.getOptions().isEmpty()) {
            System.out.printf("%nOption(s)%n", new Object[0]);
            for (OptionInfo optionInfo : command.getOptions()) {
                this.printOption(optionInfo);
            }
        }
        if (!command.getArguments().isEmpty()) {
            System.out.printf("%nArgument(s)%n", new Object[0]);
            for (ArgumentInfo argumentInfo : command.getArguments()) {
                this.printArgument(argumentInfo);
            }
        }
    }

    private void printArgument(ArgumentInfo argumentInfo) {
        if (!this.__MprintArgument$org_ow2_shelbie_core_registry_info_ArgumentInfo) {
            this.__M_printArgument(argumentInfo);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "printArgument$org_ow2_shelbie_core_registry_info_ArgumentInfo", new Object[]{argumentInfo});
            this.__M_printArgument(argumentInfo);
            this.__IM.onExit((Object)this, "printArgument$org_ow2_shelbie_core_registry_info_ArgumentInfo", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "printArgument$org_ow2_shelbie_core_registry_info_ArgumentInfo", throwable);
            throw throwable;
        }
    }

    private void __M_printArgument(ArgumentInfo argumentInfo) {
        System.out.printf("  index: %d ", argumentInfo.getIndex());
        this.printParameter((ParameterInfo)argumentInfo);
    }

    private void printOption(OptionInfo optionInfo) {
        if (!this.__MprintOption$org_ow2_shelbie_core_registry_info_OptionInfo) {
            this.__M_printOption(optionInfo);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "printOption$org_ow2_shelbie_core_registry_info_OptionInfo", new Object[]{optionInfo});
            this.__M_printOption(optionInfo);
            this.__IM.onExit((Object)this, "printOption$org_ow2_shelbie_core_registry_info_OptionInfo", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "printOption$org_ow2_shelbie_core_registry_info_OptionInfo", throwable);
            throw throwable;
        }
    }

    private void __M_printOption(OptionInfo optionInfo) {
        System.out.printf("  ", new Object[0]);
        for (String name : optionInfo.getNames()) {
            System.out.printf("%s ", name);
        }
        this.printParameter((ParameterInfo)optionInfo);
    }

    private void printParameter(ParameterInfo parameterInfo) {
        if (!this.__MprintParameter$org_ow2_shelbie_core_registry_info_ParameterInfo) {
            this.__M_printParameter(parameterInfo);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "printParameter$org_ow2_shelbie_core_registry_info_ParameterInfo", new Object[]{parameterInfo});
            this.__M_printParameter(parameterInfo);
            this.__IM.onExit((Object)this, "printParameter$org_ow2_shelbie_core_registry_info_ParameterInfo", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "printParameter$org_ow2_shelbie_core_registry_info_ParameterInfo", throwable);
            throw throwable;
        }
    }

    private void __M_printParameter(ParameterInfo parameterInfo) {
        String description;
        if (parameterInfo.isRequired()) {
            System.out.printf("[required] ", new Object[0]);
        }
        if (parameterInfo.isMultiValued()) {
            System.out.printf("[multi-valued] ", new Object[0]);
        }
        System.out.printf("%n", new Object[0]);
        this.printType(parameterInfo);
        if (parameterInfo.getDefault() != null) {
            System.out.printf("    default: %s%n", parameterInfo.getDefault().toString());
        }
        if (!HelpAction.isEmpty(description = parameterInfo.getDescription())) {
            System.out.printf("    %s%n", description);
        }
    }

    private void printType(ParameterInfo parameterInfo) {
        if (!this.__MprintType$org_ow2_shelbie_core_registry_info_ParameterInfo) {
            this.__M_printType(parameterInfo);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "printType$org_ow2_shelbie_core_registry_info_ParameterInfo", new Object[]{parameterInfo});
            this.__M_printType(parameterInfo);
            this.__IM.onExit((Object)this, "printType$org_ow2_shelbie_core_registry_info_ParameterInfo", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "printType$org_ow2_shelbie_core_registry_info_ParameterInfo", throwable);
            throw throwable;
        }
    }

    private void __M_printType(ParameterInfo parameterInfo) {
        Class pType = parameterInfo.getType();
        String type = pType.getName();
        if (pType.isArray()) {
            type = pType.getComponentType().getName() + "[]";
        }
        System.out.printf("    type: %s%n", type);
    }

    private static boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }

    public void bindRegistry(CommandRegistry commandRegistry) {
        if (!this.__MbindRegistry$org_ow2_shelbie_core_registry_CommandRegistry) {
            this.__M_bindRegistry(commandRegistry);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindRegistry$org_ow2_shelbie_core_registry_CommandRegistry", new Object[]{commandRegistry});
            this.__M_bindRegistry(commandRegistry);
            this.__IM.onExit((Object)this, "bindRegistry$org_ow2_shelbie_core_registry_CommandRegistry", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindRegistry$org_ow2_shelbie_core_registry_CommandRegistry", throwable);
            throw throwable;
        }
    }

    @Bind
    private void __M_bindRegistry(CommandRegistry registry) {
        this.__setregistry(registry);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("commandName")) {
                this.__FcommandName = true;
            }
            if (set.contains("listing")) {
                this.__Flisting = true;
            }
            if (set.contains("registry")) {
                this.__Fregistry = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("execute$org_apache_felix_service_command_CommandSession")) {
                this.__Mexecute$org_apache_felix_service_command_CommandSession = true;
            }
            if (set.contains("printCommandDetails$org_ow2_shelbie_core_registry_info_CommandInfo")) {
                this.__MprintCommandDetails$org_ow2_shelbie_core_registry_info_CommandInfo = true;
            }
            if (set.contains("printArgument$org_ow2_shelbie_core_registry_info_ArgumentInfo")) {
                this.__MprintArgument$org_ow2_shelbie_core_registry_info_ArgumentInfo = true;
            }
            if (set.contains("printOption$org_ow2_shelbie_core_registry_info_OptionInfo")) {
                this.__MprintOption$org_ow2_shelbie_core_registry_info_OptionInfo = true;
            }
            if (set.contains("printParameter$org_ow2_shelbie_core_registry_info_ParameterInfo")) {
                this.__MprintParameter$org_ow2_shelbie_core_registry_info_ParameterInfo = true;
            }
            if (set.contains("printType$org_ow2_shelbie_core_registry_info_ParameterInfo")) {
                this.__MprintType$org_ow2_shelbie_core_registry_info_ParameterInfo = true;
            }
            if (set.contains("bindRegistry$org_ow2_shelbie_core_registry_CommandRegistry")) {
                this.__MbindRegistry$org_ow2_shelbie_core_registry_CommandRegistry = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }

    private static class UnQualifiedCommandFilter
    implements CommandFilter {
        private final String name;

        public UnQualifiedCommandFilter(String name) {
            this.name = name;
        }

        public boolean accept(CommandInfo info) {
            return this.name.equals(info.getName());
        }
    }

    private static class QualifiedCommandFilter
    implements CommandFilter {
        private final String scope;
        private final String name;

        public QualifiedCommandFilter(String scope, String name) {
            this.scope = scope;
            this.name = name;
        }

        public boolean accept(CommandInfo info) {
            return this.scope.equals(info.getScope()) && this.name.equals(info.getName());
        }
    }
}

