/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.commands.builtin.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Set;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.HandlerDeclaration;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.service.command.CommandSession;
import org.fusesource.jansi.Ansi;
import org.ow2.shelbie.core.ExitSessionException;
import org.ow2.shelbie.core.system.SystemService;

@Command(name="shutdown", scope="shelbie", description="Shutdown the OSGi platform")
@Component
@HandlerDeclaration(value="<sh:command xmlns:sh='org.ow2.shelbie'/>")
public class ShutdownAction
implements Action,
Pojo {
    private InstanceManager __IM;
    private boolean __Fforce;
    @Option(name="-f", aliases={"--force"}, description="Do not ask for confirmation")
    private boolean force;
    private boolean __Fquiet;
    @Option(name="-q", aliases={"--quiet"}, description="Quietly shutdown (avoid traces except confirmation messages)")
    private boolean quiet;
    private boolean __Fsystem;
    @Requires
    private SystemService system;
    private boolean __Mexecute$org_apache_felix_service_command_CommandSession;
    private boolean __MprintConfirmationMessage;
    private boolean __MprintWarningMessage;
    private boolean __MgetConfirmation$java_lang_String;
    private boolean __MisProduction$org_apache_felix_service_command_CommandSession;

    boolean __getforce() {
        if (!this.__Fforce) {
            return this.force;
        }
        Object object = this.__IM.onGet((Object)this, "force");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setforce(boolean bl) {
        if (!this.__Fforce) {
            this.force = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "force", (Object)bl2);
    }

    boolean __getquiet() {
        if (!this.__Fquiet) {
            return this.quiet;
        }
        Object object = this.__IM.onGet((Object)this, "quiet");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setquiet(boolean bl) {
        if (!this.__Fquiet) {
            this.quiet = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "quiet", (Object)bl2);
    }

    SystemService __getsystem() {
        if (!this.__Fsystem) {
            return this.system;
        }
        return (SystemService)this.__IM.onGet((Object)this, "system");
    }

    void __setsystem(SystemService systemService) {
        if (!this.__Fsystem) {
            this.system = systemService;
            return;
        }
        this.__IM.onSet((Object)this, "system", (Object)systemService);
    }

    public ShutdownAction() {
        this(null);
    }

    private ShutdownAction(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setforce(false);
        this.__setquiet(false);
    }

    public Object execute(CommandSession commandSession) throws Exception {
        Object object;
        if (!this.__Mexecute$org_apache_felix_service_command_CommandSession) {
            return this.__M_execute(commandSession);
        }
        try {
            this.__IM.onEntry((Object)this, "execute$org_apache_felix_service_command_CommandSession", new Object[]{commandSession});
            object = this.__M_execute(commandSession);
            this.__IM.onExit((Object)this, "execute$org_apache_felix_service_command_CommandSession", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "execute$org_apache_felix_service_command_CommandSession", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __M_execute(CommandSession session) throws Exception {
        if (!this.__getforce() && this.isProduction(session)) {
            this.printWarningMessage();
            this.printConfirmationMessage();
            Confirmation confirmation = Confirmation.NO;
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(session.getKeyboard()));
                confirmation = this.getConfirmation(reader.readLine());
                System.out.printf("%n", new Object[0]);
            }
            catch (IOException e) {
                System.out.printf("%nCannot read answer: %s%n", e.getMessage());
                System.out.flush();
            }
            if (confirmation == Confirmation.NO) {
                System.out.printf("Aborting shutdown%n", new Object[0]);
                System.out.flush();
                return null;
            }
        }
        if (!this.__getquiet()) {
            System.out.printf("The system is going down for halt NOW!%n", new Object[0]);
            System.out.flush();
        }
        this.__getsystem().shutdown();
        throw new ExitSessionException();
    }

    private void printConfirmationMessage() {
        if (!this.__MprintConfirmationMessage) {
            this.__M_printConfirmationMessage();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "printConfirmationMessage", new Object[0]);
            this.__M_printConfirmationMessage();
            this.__IM.onExit((Object)this, "printConfirmationMessage", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "printConfirmationMessage", throwable);
            throw throwable;
        }
    }

    private void __M_printConfirmationMessage() {
        Ansi buffer = Ansi.ansi();
        buffer.a(Ansi.Attribute.ITALIC);
        buffer.a("Are you sure ? ");
        buffer.a(Ansi.Attribute.ITALIC_OFF);
        buffer.a("[y/");
        buffer.a(Ansi.Attribute.BLINK_SLOW);
        buffer.a("N");
        buffer.a(Ansi.Attribute.BLINK_OFF);
        buffer.a("] ");
        System.out.print(buffer);
        System.out.flush();
    }

    private void printWarningMessage() {
        if (!this.__MprintWarningMessage) {
            this.__M_printWarningMessage();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "printWarningMessage", new Object[0]);
            this.__M_printWarningMessage();
            this.__IM.onExit((Object)this, "printWarningMessage", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "printWarningMessage", throwable);
            throw throwable;
        }
    }

    private void __M_printWarningMessage() {
        Ansi buffer = Ansi.ansi();
        buffer.a(Ansi.Attribute.INTENSITY_BOLD);
        buffer.a("Shutdown will halt the entire OSGi system.");
        buffer.a(Ansi.Attribute.INTENSITY_BOLD_OFF);
        buffer.newline();
        System.out.print(buffer);
        System.out.flush();
    }

    private Confirmation getConfirmation(String string) {
        Confirmation confirmation;
        if (!this.__MgetConfirmation$java_lang_String) {
            return this.__M_getConfirmation(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getConfirmation$java_lang_String", new Object[]{string});
            confirmation = this.__M_getConfirmation(string);
            this.__IM.onExit((Object)this, "getConfirmation$java_lang_String", (Object)confirmation);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getConfirmation$java_lang_String", throwable);
            throw throwable;
        }
        return confirmation;
    }

    private Confirmation __M_getConfirmation(String input) {
        for (Confirmation matcher : Confirmation.values()) {
            if (!matcher.match(input)) continue;
            return matcher;
        }
        return Confirmation.NO;
    }

    private boolean isProduction(CommandSession commandSession) {
        boolean bl;
        if (!this.__MisProduction$org_apache_felix_service_command_CommandSession) {
            return this.__M_isProduction(commandSession);
        }
        try {
            this.__IM.onEntry((Object)this, "isProduction$org_apache_felix_service_command_CommandSession", new Object[]{commandSession});
            bl = this.__M_isProduction(commandSession);
            this.__IM.onExit((Object)this, "isProduction$org_apache_felix_service_command_CommandSession", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isProduction$org_apache_felix_service_command_CommandSession", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_isProduction(CommandSession session) {
        return true;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("force")) {
                this.__Fforce = true;
            }
            if (set.contains("quiet")) {
                this.__Fquiet = true;
            }
            if (set.contains("system")) {
                this.__Fsystem = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("execute$org_apache_felix_service_command_CommandSession")) {
                this.__Mexecute$org_apache_felix_service_command_CommandSession = true;
            }
            if (set.contains("printConfirmationMessage")) {
                this.__MprintConfirmationMessage = true;
            }
            if (set.contains("printWarningMessage")) {
                this.__MprintWarningMessage = true;
            }
            if (set.contains("getConfirmation$java_lang_String")) {
                this.__MgetConfirmation$java_lang_String = true;
            }
            if (set.contains("isProduction$org_apache_felix_service_command_CommandSession")) {
                this.__MisProduction$org_apache_felix_service_command_CommandSession = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Confirmation {
        YES("y", "yes"),
        NO("n", "no");

        private final String[] values;

        private Confirmation(String ... values) {
            this.values = values;
        }

        public boolean match(String input) {
            for (String value : this.values) {
                if (!value.equalsIgnoreCase(input)) continue;
                return true;
            }
            return false;
        }
    }
}

