/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.report.extensions.deployables.internal;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.osgi.service.event.Event;
import org.ow2.jonas.management.DeployableState;
import org.ow2.jonas.report.api.IReportExtension;
import org.ow2.jonas.report.extensions.deployable.generated.DeployableType;
import org.ow2.jonas.report.extensions.deployable.generated.Deployables;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class DeployablesReportExtension
implements IReportExtension,
Pojo {
    private InstanceManager __IM;
    public static final Log logger = LogFactory.getLog(DeployablesReportExtension.class);
    public static final String DEPLOYABLE_TOPIC = "deployablePublisherTopic";
    public static final String XSD_PATH = "xsd/deployable-report.xsd";
    private boolean __FdeployableTypeList;
    private List<DeployableType> deployableTypeList;
    private boolean __FdeployableMap;
    private Map<DeployableType, Long> deployableMap;
    private boolean __MgenerateReport;
    private boolean __MgetXsd;
    private boolean __MgetRootClass;
    private boolean __MhandleDeployable$org_osgi_service_event_Event;
    private boolean __MgetDeployable$java_lang_String;

    List __getdeployableTypeList() {
        if (!this.__FdeployableTypeList) {
            return this.deployableTypeList;
        }
        return (List)this.__IM.onGet((Object)this, "deployableTypeList");
    }

    void __setdeployableTypeList(List list) {
        if (!this.__FdeployableTypeList) {
            this.deployableTypeList = list;
            return;
        }
        this.__IM.onSet((Object)this, "deployableTypeList", (Object)list);
    }

    Map __getdeployableMap() {
        if (!this.__FdeployableMap) {
            return this.deployableMap;
        }
        return (Map)this.__IM.onGet((Object)this, "deployableMap");
    }

    void __setdeployableMap(Map map) {
        if (!this.__FdeployableMap) {
            this.deployableMap = map;
            return;
        }
        this.__IM.onSet((Object)this, "deployableMap", (Object)map);
    }

    public DeployablesReportExtension() {
        this(null);
    }

    private DeployablesReportExtension(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setdeployableTypeList(new ArrayList());
        this.__setdeployableMap(new HashMap());
    }

    public Object generateReport() {
        Object object;
        if (!this.__MgenerateReport) {
            return this.__M_generateReport();
        }
        try {
            this.__IM.onEntry((Object)this, "generateReport", new Object[0]);
            object = this.__M_generateReport();
            this.__IM.onExit((Object)this, "generateReport", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "generateReport", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __M_generateReport() {
        Deployables deployablesType = new Deployables();
        deployablesType.getDeployable().addAll(this.__getdeployableTypeList());
        return deployablesType;
    }

    public Source getXsd() {
        Source source;
        if (!this.__MgetXsd) {
            return this.__M_getXsd();
        }
        try {
            this.__IM.onEntry((Object)this, "getXsd", new Object[0]);
            source = this.__M_getXsd();
            this.__IM.onExit((Object)this, "getXsd", (Object)source);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getXsd", throwable);
            throw throwable;
        }
        return source;
    }

    private Source __M_getXsd() {
        InputStream xsd = this.getRootClass().getClassLoader().getResourceAsStream(XSD_PATH);
        StreamSource source = null;
        if (xsd != null) {
            source = new StreamSource(xsd);
        } else {
            logger.error((Object)"Cannot find XSD xsd/deployable-report.xsd", new Object[0]);
        }
        return source;
    }

    public Class getRootClass() {
        Class clazz;
        if (!this.__MgetRootClass) {
            return this.__M_getRootClass();
        }
        try {
            this.__IM.onEntry((Object)this, "getRootClass", new Object[0]);
            clazz = this.__M_getRootClass();
            this.__IM.onExit((Object)this, "getRootClass", (Object)clazz);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRootClass", throwable);
            throw throwable;
        }
        return clazz;
    }

    private Class __M_getRootClass() {
        return Deployables.class;
    }

    public void handleDeployable(Event event) {
        if (!this.__MhandleDeployable$org_osgi_service_event_Event) {
            this.__M_handleDeployable(event);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "handleDeployable$org_osgi_service_event_Event", new Object[]{event});
            this.__M_handleDeployable(event);
            this.__IM.onExit((Object)this, "handleDeployable$org_osgi_service_event_Event", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "handleDeployable$org_osgi_service_event_Event", throwable);
            throw throwable;
        }
    }

    private void __M_handleDeployable(Event event) {
        boolean postDeployedOperation = false;
        boolean postUndeployedOperation = false;
        if (DEPLOYABLE_TOPIC.equals(event.getTopic())) {
            DeployableState deployableState;
            Object object;
            String name = (String)String.class.cast(event.getProperty("name"));
            DeployableType deployableType = this.getDeployable(name);
            if (deployableType == null) {
                deployableType = new DeployableType();
                object = event.getProperty("name");
                if (object != null) {
                    deployableType.setName((String)String.class.cast(object));
                }
                if ((object = event.getProperty("path")) != null) {
                    deployableType.setPath((String)String.class.cast(object));
                }
                if ((object = event.getProperty("state")) != null) {
                    deployableState = (DeployableState)DeployableState.class.cast(object);
                    deployableType.setState(deployableState.toString());
                }
                if ((object = event.getProperty("source")) != null) {
                    deployableType.setSource(String.valueOf(object));
                }
                this.__getdeployableTypeList().add(deployableType);
            } else {
                object = event.getProperty("state");
                if (object != null) {
                    String state;
                    deployableState = (DeployableState)DeployableState.class.cast(object);
                    String curentState = deployableState.toString();
                    if (!curentState.equals(state = deployableType.getState())) {
                        if (DeployableState.DEPLOYED.toString().equals(curentState)) {
                            postDeployedOperation = true;
                        } else {
                            postUndeployedOperation = true;
                        }
                    }
                    deployableType.setState(deployableState.toString());
                }
            }
            object = event.getProperty("currentTime");
            if (object != null) {
                Long currentTime = (Long)Long.class.cast(object);
                Long time = (Long)this.__getdeployableMap().get(deployableType);
                if (time != null) {
                    if (postDeployedOperation) {
                        Long startTime = currentTime - time;
                        deployableType.setStartTime(startTime);
                        postDeployedOperation = false;
                    } else if (postUndeployedOperation) {
                        Long shutdownTime = currentTime - time;
                        deployableType.setShutdownTime(shutdownTime);
                        postUndeployedOperation = false;
                    }
                }
                this.__getdeployableMap().put(deployableType, currentTime);
            }
        }
    }

    private DeployableType getDeployable(String name) {
        DeployableType deployableType;
        if (!this.__MgetDeployable$java_lang_String) {
            return this.__M_getDeployable(name);
        }
        try {
            this.__IM.onEntry((Object)this, "getDeployable$java_lang_String", new Object[]{name});
            deployableType = this.__M_getDeployable(name);
            this.__IM.onExit((Object)this, "getDeployable$java_lang_String", (Object)deployableType);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDeployable$java_lang_String", throwable);
            throw throwable;
        }
        return deployableType;
    }

    private DeployableType __M_getDeployable(String name) {
        for (DeployableType deployableType : this.__getdeployableTypeList()) {
            String deployableName = deployableType.getName();
            if (deployableName == null || !deployableName.equals(name)) continue;
            return deployableType;
        }
        return null;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("deployableMap")) {
                this.__FdeployableMap = true;
            }
            if (set.contains("deployableTypeList")) {
                this.__FdeployableTypeList = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("generateReport")) {
                this.__MgenerateReport = true;
            }
            if (set.contains("getXsd")) {
                this.__MgetXsd = true;
            }
            if (set.contains("getRootClass")) {
                this.__MgetRootClass = true;
            }
            if (set.contains("handleDeployable$org_osgi_service_event_Event")) {
                this.__MhandleDeployable$org_osgi_service_event_Event = true;
            }
            if (set.contains("getDeployable$java_lang_String")) {
                this.__MgetDeployable$java_lang_String = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

