/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.core.internal.handler.completer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jline.console.completer.AggregateCompleter;
import jline.console.completer.ArgumentCompleter;
import jline.console.completer.Completer;
import jline.console.completer.NullCompleter;
import jline.console.completer.StringsCompleter;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.ServiceProperty;
import org.apache.felix.ipojo.whiteboard.Wbp;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.ow2.shelbie.core.ICompletable;
import org.ow2.shelbie.core.IScopeRegistry;
import org.ow2.shelbie.core.internal.handler.completer.CharSequenceComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Provides
@Wbp(filter="(&(osgi.command.scope=*)(osgi.command.function=*))", onArrival="bindCommand", onDeparture="unbindCommand")
public class CommandsCompleter
implements Completer,
IScopeRegistry,
Pojo {
    private InstanceManager __IM;
    private boolean __Freferences;
    private List<ServiceReference> references;
    private boolean __FnbCommandsForScope;
    private Map<String, Integer> nbCommandsForScope;
    private boolean __Fcontext;
    private BundleContext context;
    private boolean __Ftype;
    @ServiceProperty(value="commands")
    private String type;
    private boolean __Fscopes;
    @ServiceProperty(value="*")
    private String scopes;
    private boolean __MrefreshScopes;
    private boolean __MbindCommand$org_osgi_framework_ServiceReference;
    private boolean __MunbindCommand$org_osgi_framework_ServiceReference;
    private boolean __MgetFunctionNames$org_osgi_framework_ServiceReference;
    private boolean __Mcomplete$java_lang_String$int$java_util_List;
    private boolean __MgetCompleters;
    private boolean __MgetScopes;

    List __getreferences() {
        if (!this.__Freferences) {
            return this.references;
        }
        return (List)this.__IM.onGet((Object)this, "references");
    }

    void __setreferences(List list) {
        if (!this.__Freferences) {
            this.references = list;
            return;
        }
        this.__IM.onSet((Object)this, "references", (Object)list);
    }

    Map __getnbCommandsForScope() {
        if (!this.__FnbCommandsForScope) {
            return this.nbCommandsForScope;
        }
        return (Map)this.__IM.onGet((Object)this, "nbCommandsForScope");
    }

    void __setnbCommandsForScope(Map map) {
        if (!this.__FnbCommandsForScope) {
            this.nbCommandsForScope = map;
            return;
        }
        this.__IM.onSet((Object)this, "nbCommandsForScope", (Object)map);
    }

    BundleContext __getcontext() {
        if (!this.__Fcontext) {
            return this.context;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "context");
    }

    void __setcontext(BundleContext bundleContext) {
        if (!this.__Fcontext) {
            this.context = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "context", (Object)bundleContext);
    }

    String __gettype() {
        if (!this.__Ftype) {
            return this.type;
        }
        return (String)this.__IM.onGet((Object)this, "type");
    }

    void __settype(String string) {
        if (!this.__Ftype) {
            this.type = string;
            return;
        }
        this.__IM.onSet((Object)this, "type", (Object)string);
    }

    String __getscopes() {
        if (!this.__Fscopes) {
            return this.scopes;
        }
        return (String)this.__IM.onGet((Object)this, "scopes");
    }

    void __setscopes(String string) {
        if (!this.__Fscopes) {
            this.scopes = string;
            return;
        }
        this.__IM.onSet((Object)this, "scopes", (Object)string);
    }

    private void refreshScopes() {
        if (!this.__MrefreshScopes) {
            this.__M_refreshScopes();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "refreshScopes", new Object[0]);
            this.__M_refreshScopes();
            this.__IM.onExit((Object)this, "refreshScopes", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "refreshScopes", throwable);
            throw throwable;
        }
    }

    private void __M_refreshScopes() {
        StringBuilder scopeValue = new StringBuilder();
        for (String scope : this.__getnbCommandsForScope().keySet()) {
            scopeValue.append(scope);
            scopeValue.append(":");
        }
        scopeValue.append("*");
        this.__setscopes(scopeValue.toString());
    }

    public CommandsCompleter(BundleContext bundleContext) {
        this(null, bundleContext);
    }

    private CommandsCompleter(InstanceManager _manager, BundleContext context) {
        this._setInstanceManager(_manager);
        this.__setreferences(new ArrayList());
        this.__setnbCommandsForScope(new HashMap());
        this.__setcontext(context);
    }

    public void bindCommand(ServiceReference serviceReference) {
        if (!this.__MbindCommand$org_osgi_framework_ServiceReference) {
            this.__M_bindCommand(serviceReference);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindCommand$org_osgi_framework_ServiceReference", new Object[]{serviceReference});
            this.__M_bindCommand(serviceReference);
            this.__IM.onExit((Object)this, "bindCommand$org_osgi_framework_ServiceReference", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindCommand$org_osgi_framework_ServiceReference", throwable);
            throw throwable;
        }
    }

    private void __M_bindCommand(ServiceReference reference) {
        this.__getreferences().add(reference);
        String scope = (String)reference.getProperty("osgi.command.scope");
        Integer numberOfCommands = (Integer)this.__getnbCommandsForScope().get(scope);
        if (numberOfCommands == null) {
            numberOfCommands = 0;
        }
        numberOfCommands = numberOfCommands + 1;
        this.__getnbCommandsForScope().put(scope, numberOfCommands);
        if (numberOfCommands == 1) {
            this.refreshScopes();
        }
    }

    public void unbindCommand(ServiceReference serviceReference) {
        if (!this.__MunbindCommand$org_osgi_framework_ServiceReference) {
            this.__M_unbindCommand(serviceReference);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindCommand$org_osgi_framework_ServiceReference", new Object[]{serviceReference});
            this.__M_unbindCommand(serviceReference);
            this.__IM.onExit((Object)this, "unbindCommand$org_osgi_framework_ServiceReference", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindCommand$org_osgi_framework_ServiceReference", throwable);
            throw throwable;
        }
    }

    private void __M_unbindCommand(ServiceReference reference) {
        this.__getreferences().remove(reference);
        String scope = (String)reference.getProperty("osgi.command.scope");
        Integer numberOfCommands = (Integer)this.__getnbCommandsForScope().get(scope);
        if (numberOfCommands != null) {
            Integer n = numberOfCommands;
            Integer n2 = numberOfCommands = Integer.valueOf(numberOfCommands - 1);
            if (numberOfCommands == 0) {
                this.__getnbCommandsForScope().remove(scope);
                this.refreshScopes();
            } else {
                this.__getnbCommandsForScope().put(scope, numberOfCommands);
            }
        }
    }

    private String[] getFunctionNames(ServiceReference serviceReference) {
        String[] stringArray;
        if (!this.__MgetFunctionNames$org_osgi_framework_ServiceReference) {
            return this.__M_getFunctionNames(serviceReference);
        }
        try {
            this.__IM.onEntry((Object)this, "getFunctionNames$org_osgi_framework_ServiceReference", new Object[]{serviceReference});
            stringArray = this.__M_getFunctionNames(serviceReference);
            this.__IM.onExit((Object)this, "getFunctionNames$org_osgi_framework_ServiceReference", (Object)stringArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getFunctionNames$org_osgi_framework_ServiceReference", throwable);
            throw throwable;
        }
        return stringArray;
    }

    private String[] __M_getFunctionNames(ServiceReference reference) {
        ArrayList<String> names = new ArrayList<String>();
        Object functionValue = reference.getProperty("osgi.command.function");
        String scope = (String)reference.getProperty("osgi.command.scope");
        if (functionValue.getClass().isArray() && String.class.equals(functionValue.getClass().getComponentType())) {
            String[] values;
            for (String name : values = (String[])functionValue) {
                names.add(scope + ":" + name);
            }
        } else {
            names.add(scope + ":" + functionValue.toString());
        }
        return names.toArray(new String[names.size()]);
    }

    @Override
    public int complete(String string, int n, List<CharSequence> list) {
        int n2;
        if (!this.__Mcomplete$java_lang_String$int$java_util_List) {
            return this.__M_complete(string, n, list);
        }
        try {
            this.__IM.onEntry((Object)this, "complete$java_lang_String$int$java_util_List", new Object[]{string, new Integer(n), list});
            n2 = this.__M_complete(string, n, list);
            this.__IM.onExit((Object)this, "complete$java_lang_String$int$java_util_List", (Object)new Integer(n2));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "complete$java_lang_String$int$java_util_List", throwable);
            throw throwable;
        }
        return n2;
    }

    private int __M_complete(String buffer, int cursor, List<CharSequence> candidates) {
        int res = new AggregateCompleter(this.getCompleters()).complete(buffer, cursor, candidates);
        Collections.sort(candidates, new CharSequenceComparator());
        return res;
    }

    private Collection<Completer> getCompleters() {
        Collection<Completer> collection;
        if (!this.__MgetCompleters) {
            return this.__M_getCompleters();
        }
        try {
            this.__IM.onEntry((Object)this, "getCompleters", new Object[0]);
            collection = this.__M_getCompleters();
            this.__IM.onExit((Object)this, "getCompleters", collection);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getCompleters", throwable);
            throw throwable;
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Completer> __M_getCompleters() {
        ArrayList<Completer> completers = new ArrayList<Completer>();
        for (ServiceReference reference : this.__getreferences()) {
            String[] functionNames = this.getFunctionNames(reference);
            ArrayList<Completer> cl = new ArrayList<Completer>();
            cl.add(new StringsCompleter(functionNames));
            try {
                Object service = this.__getcontext().getService(reference);
                if (service instanceof ICompletable) {
                    ICompletable completable = (ICompletable)service;
                    List<Completer> commandCompleters = completable.getCompleters();
                    if (commandCompleters != null) {
                        for (Completer completer : commandCompleters) {
                            if (completer == null) {
                                cl.add(new NullCompleter());
                                continue;
                            }
                            cl.add(completer);
                        }
                    }
                } else {
                    cl.add(new NullCompleter());
                }
                completers.add(new ArgumentCompleter(cl));
            }
            finally {
                this.__getcontext().ungetService(reference);
            }
        }
        return completers;
    }

    @Override
    public String getScopes() {
        String string;
        if (!this.__MgetScopes) {
            return this.__M_getScopes();
        }
        try {
            this.__IM.onEntry((Object)this, "getScopes", new Object[0]);
            string = this.__M_getScopes();
            this.__IM.onExit((Object)this, "getScopes", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getScopes", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getScopes() {
        return this.__getscopes();
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("context")) {
                this.__Fcontext = true;
            }
            if (set.contains("nbCommandsForScope")) {
                this.__FnbCommandsForScope = true;
            }
            if (set.contains("references")) {
                this.__Freferences = true;
            }
            if (set.contains("scopes")) {
                this.__Fscopes = true;
            }
            if (set.contains("type")) {
                this.__Ftype = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("refreshScopes")) {
                this.__MrefreshScopes = true;
            }
            if (set.contains("bindCommand$org_osgi_framework_ServiceReference")) {
                this.__MbindCommand$org_osgi_framework_ServiceReference = true;
            }
            if (set.contains("unbindCommand$org_osgi_framework_ServiceReference")) {
                this.__MunbindCommand$org_osgi_framework_ServiceReference = true;
            }
            if (set.contains("getFunctionNames$org_osgi_framework_ServiceReference")) {
                this.__MgetFunctionNames$org_osgi_framework_ServiceReference = true;
            }
            if (set.contains("complete$java_lang_String$int$java_util_List")) {
                this.__Mcomplete$java_lang_String$int$java_util_List = true;
            }
            if (set.contains("getCompleters")) {
                this.__MgetCompleters = true;
            }
            if (set.contains("getScopes")) {
                this.__MgetScopes = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

