/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.core.internal.registry.supplier.gogo.info;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Descriptor;
import org.apache.felix.service.command.Parameter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.ow2.shelbie.core.internal.registry.supplier.gogo.info.GogoArgumentInfo;
import org.ow2.shelbie.core.internal.registry.supplier.gogo.info.GogoCommandInfo;
import org.ow2.shelbie.core.internal.registry.supplier.gogo.info.GogoOptionInfo;
import org.ow2.shelbie.core.internal.registry.supplier.gogo.info.GogoScopeInfo;
import org.ow2.shelbie.core.internal.registry.util.References;
import org.ow2.shelbie.core.registry.info.ScopeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfoBuilder {
    public static final Set<String> KEYWORDS = new HashSet<String>(Arrays.asList("abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while"));
    private final BundleContext bundleContext;

    public InfoBuilder(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScopeInfo buildScopeInfo(ServiceReference reference) {
        GogoScopeInfo scopeInfo;
        try {
            Object support = this.bundleContext.getService(reference);
            scopeInfo = new GogoScopeInfo(References.getCommandScope(reference));
            List<String> names = References.getCommandFunctions(reference);
            List<Method> methods = Arrays.asList(support.getClass().getMethods());
            Iterator<String> i$ = names.iterator();
            while (i$.hasNext()) {
                String name;
                String unmodifiedName = name = i$.next();
                if (KEYWORDS.contains(name)) {
                    name = "_" + name;
                }
                for (Method method : this.findMethods(methods, name)) {
                    GogoCommandInfo commandInfo = new GogoCommandInfo(scopeInfo.getName(), unmodifiedName);
                    scopeInfo.getCommands().add(commandInfo);
                    Descriptor md = method.getAnnotation(Descriptor.class);
                    if (md != null) {
                        commandInfo.setDescription(md.value());
                    }
                    int argumentIndex = 0;
                    for (int i = 0; i < method.getParameterTypes().length; ++i) {
                        Descriptor od;
                        if (method.getParameterTypes()[i].equals(CommandSession.class)) continue;
                        Annotation[] annotations = method.getParameterAnnotations()[i];
                        Parameter parameter = this.getAnnotation(annotations, Parameter.class);
                        if (parameter != null) {
                            GogoOptionInfo optionInfo = new GogoOptionInfo(parameter.names(), method.getParameterTypes()[i]);
                            commandInfo.getOptions().add(optionInfo);
                            optionInfo.setDefaultValue(parameter.absentValue());
                            od = this.getAnnotation(annotations, Descriptor.class);
                            if (od == null) continue;
                            optionInfo.setDescription(od.value());
                            continue;
                        }
                        GogoArgumentInfo argumentInfo = new GogoArgumentInfo(method.getParameterTypes()[i], argumentIndex++);
                        commandInfo.getArguments().add(argumentInfo);
                        od = this.getAnnotation(annotations, Descriptor.class);
                        if (od == null) continue;
                        argumentInfo.setDescription(od.value());
                    }
                }
            }
        }
        finally {
            this.bundleContext.ungetService(reference);
        }
        return scopeInfo;
    }

    private <T> T getAnnotation(Annotation[] annotations, Class<T> annotationType) {
        for (Annotation annotation : annotations) {
            if (!annotationType.equals(annotation.annotationType())) continue;
            return annotationType.cast(annotation);
        }
        return null;
    }

    private List<Method> findMethods(List<Method> methods, String name) {
        ArrayList<Method> filtered = new ArrayList<Method>();
        for (Method method : methods) {
            if (!method.getName().equals(name)) continue;
            filtered.add(method);
        }
        if (filtered.isEmpty()) {
            throw new IllegalStateException("Cannot find matching method for function named " + name);
        }
        return filtered;
    }
}

