/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.udp.UdpConnector;
import org.mule.providers.udp.i18n.UdpMessages;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.umo.transformer.UMOTransformer;

public class UdpMessageReceiver
extends AbstractMessageReceiver
implements Work {
    protected DatagramSocket socket = null;
    protected InetAddress inetAddress;
    protected int bufferSize;
    private URI uri;
    protected UMOTransformer responseTransformer = null;

    public UdpMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        super(connector, component, endpoint);
        this.bufferSize = ((UdpConnector)connector).getReceiveBufferSize();
        this.uri = endpoint.getEndpointURI().getUri();
        try {
            if (!"null".equalsIgnoreCase(this.uri.getHost())) {
                this.inetAddress = InetAddress.getByName(this.uri.getHost());
            }
        }
        catch (UnknownHostException e) {
            throw new InitialisationException(UdpMessages.failedToLocateHost(this.uri), e, this);
        }
        this.responseTransformer = this.getResponseTransformer();
    }

    protected void doConnect() throws Exception {
        try {
            this.socket = ((UdpConnector)this.connector).getSocket(this.endpoint);
        }
        catch (Exception e) {
            throw new InitialisationException(UdpMessages.failedToBind(this.uri), e, this);
        }
        try {
            this.getWorkManager().scheduleWork(this, Long.MAX_VALUE, null, this.connector);
        }
        catch (WorkException e) {
            throw new InitialisationException(CoreMessages.failedToScheduleWork(), e, this);
        }
    }

    protected void doDisconnect() throws Exception {
        this.disposing.set(true);
        if (this.socket != null) {
            this.socket.close();
        }
    }

    protected void doStart() throws UMOException {
    }

    protected void doStop() throws UMOException {
    }

    protected UMOTransformer getResponseTransformer() throws InitialisationException {
        UMOTransformer transformer = this.component.getDescriptor().getResponseTransformer();
        if (transformer == null) {
            return this.connector.getDefaultResponseTransformer();
        }
        return transformer;
    }

    protected DatagramSocket createSocket(URI uri, InetAddress inetAddress) throws IOException {
        return new DatagramSocket(uri.getPort(), inetAddress);
    }

    public DatagramSocket getSocket() {
        return this.socket;
    }

    protected DatagramPacket createPacket() {
        DatagramPacket packet = new DatagramPacket(new byte[this.bufferSize], this.bufferSize);
        return packet;
    }

    public void run() {
        while (!this.disposing.get()) {
            if (!this.connector.isStarted()) continue;
            try {
                DatagramPacket packet = this.createPacket();
                try {
                    this.socket.receive(packet);
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)("Received packet on: " + this.uri));
                    }
                    Work work = this.createWork(packet);
                    try {
                        this.getWorkManager().scheduleWork(work, Long.MAX_VALUE, null, this.connector);
                    }
                    catch (WorkException e) {
                        this.logger.error((Object)("Udp receiver interrupted: " + e.getMessage()), (Throwable)e);
                    }
                }
                catch (SocketTimeoutException socketTimeoutException) {
                }
            }
            catch (Exception e) {
                if (this.connector.isDisposed() || this.disposing.get()) continue;
                this.logger.debug((Object)("Accept failed on socket: " + e), (Throwable)e);
                this.handleException(e);
            }
        }
    }

    public void release() {
        this.dispose();
    }

    protected void doDispose() {
        if (this.socket != null && !this.socket.isClosed()) {
            this.logger.debug((Object)("Closing Udp connection: " + this.uri));
            this.socket.close();
            this.logger.info((Object)("Closed Udp connection: " + this.uri));
        }
    }

    protected Work createWork(DatagramPacket packet) throws IOException {
        return new UdpWorker(new DatagramSocket(0), packet);
    }

    protected class UdpWorker
    implements Work,
    Disposable {
        private DatagramSocket socket = null;
        private DatagramPacket packet;

        public UdpWorker(DatagramSocket socket, DatagramPacket packet) {
            this.socket = socket;
            this.packet = packet;
        }

        public void release() {
            this.dispose();
        }

        public void dispose() {
            if (this.socket != null && !this.socket.isClosed()) {
                try {
                    this.socket.close();
                }
                catch (Exception e) {
                    UdpMessageReceiver.this.logger.error((Object)"Socket close failed", (Throwable)e);
                }
            }
            this.socket = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            UMOMessage returnMessage = null;
            try {
                UMOMessageAdapter adapter = UdpMessageReceiver.this.connector.getMessageAdapter(this.packet);
                SocketAddress clientAddress = this.socket.getRemoteSocketAddress();
                if (clientAddress != null) {
                    adapter.setProperty("MULE_REMOTE_CLIENT_ADDRESS", clientAddress);
                }
                if ((returnMessage = UdpMessageReceiver.this.routeMessage((UMOMessage)new MuleMessage(adapter), UdpMessageReceiver.this.endpoint.isSynchronous())) != null) {
                    Object response;
                    byte[] data = UdpMessageReceiver.this.responseTransformer != null ? ((response = UdpMessageReceiver.this.responseTransformer.transform(returnMessage.getPayload())) instanceof byte[] ? (byte[])response : response.toString().getBytes()) : returnMessage.getPayloadAsBytes();
                    DatagramPacket result = new DatagramPacket(data, data.length, this.packet.getAddress(), this.packet.getPort());
                    this.socket.send(result);
                }
            }
            catch (Exception e) {
                if (!UdpMessageReceiver.this.disposing.get()) {
                    UdpMessageReceiver.this.handleException(e);
                }
            }
            finally {
                this.dispose();
            }
        }
    }
}

