/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.domain.cluster.tomcat;

import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.lib.management.domain.DomainMonitor;
import org.ow2.jonas.lib.management.domain.cluster.BaseCluster;
import org.ow2.jonas.lib.management.domain.cluster.ClusterFactory;
import org.ow2.jonas.lib.management.domain.cluster.tomcat.TomcatCluster;
import org.ow2.jonas.lib.management.domain.proxy.server.ServerProxy;

public class TomcatClusterFactory
extends ClusterFactory {
    private HashMap myclusters = new HashMap();

    public TomcatClusterFactory(DomainMonitor dm) {
        super(dm);
    }

    @Override
    public BaseCluster getCluster(String name) {
        return (BaseCluster)this.myclusters.get(name);
    }

    @Override
    public boolean notifyServer(ServerProxy proxy) {
        ObjectName clusterOns;
        String serverName = proxy.getServerName();
        logger.log(BasicLevel.DEBUG, (Object)serverName);
        try {
            clusterOns = ObjectName.getInstance(this.domainName + ":type=Cluster,*");
        }
        catch (MalformedObjectNameException e2) {
            logger.log(BasicLevel.WARN, (Object)e2);
            return false;
        }
        Set clusterOnSet = proxy.queryNames(clusterOns);
        if (clusterOnSet == null) {
            logger.log(BasicLevel.DEBUG, (Object)("Cannot reach " + serverName));
            return false;
        }
        if (clusterOnSet.isEmpty()) {
            logger.log(BasicLevel.DEBUG, (Object)"No Tomcat Cluster declared");
            return false;
        }
        ObjectName clusterOn = (ObjectName)clusterOnSet.iterator().next();
        String hostName = clusterOn.getKeyProperty("host");
        String clusterName = (String)proxy.getAttribute(clusterOn, "clusterName");
        logger.log(BasicLevel.DEBUG, (Object)("Found Tomcat cluster: " + hostName + "," + clusterName));
        ObjectName cmon = null;
        try {
            cmon = ObjectName.getInstance(this.domainName + ":type=ClusterMembership,host=" + hostName);
        }
        catch (MalformedObjectNameException e1) {
            logger.log(BasicLevel.WARN, (Object)e1);
            return false;
        }
        if (!proxy.isRegistered(cmon)) {
            logger.log(BasicLevel.ERROR, (Object)("CatalinaClusterMembership not registered:" + cmon));
            return false;
        }
        String mcastAddr = null;
        int mcastPort = 0;
        long mcastDropTime = 0L;
        long mcastFrequency = 0L;
        int mcastSoTimeout = 0;
        String[] attNames = new String[]{"mcastAddr", "mcastPort", "mcastDropTime", "mcastFrequency", "mcastTTL", "mcastBindAddress", "mcastClusterDomain", "mcastSoTimeout"};
        AttributeList attList = proxy.getAttributes(cmon, attNames);
        for (int i = 0; i < attList.size(); ++i) {
            Attribute att = (Attribute)attList.get(i);
            String attName = att.getName();
            Object attValue = att.getValue();
            if ("mcastAddr".equals(attName)) {
                mcastAddr = (String)attValue;
            }
            if ("mcastPort".equals(attName)) {
                mcastPort = (Integer)attValue;
            }
            if ("mcastDropTime".equals(attName)) {
                mcastDropTime = (Long)attValue;
            }
            if ("mcastFrequency".equals(attName)) {
                mcastFrequency = (Long)attValue;
            }
            if (!"mcastSoTimeout".equals(attName)) continue;
            mcastSoTimeout = (Integer)attValue;
        }
        TomcatCluster cluster = (TomcatCluster)this.myclusters.get(clusterName);
        if (cluster == null) {
            ObjectName clon = null;
            try {
                cluster = new TomcatCluster(this);
                cluster.setHost(hostName);
                clon = cluster.setName(clusterName);
            }
            catch (JMException e) {
                logger.log(BasicLevel.ERROR, (Object)("Cannot create tomcat SessionCluster:" + e));
                return false;
            }
            cluster.setMcastAddr(mcastAddr);
            cluster.setMcastPort(mcastPort);
            cluster.setMcastDropTime(mcastDropTime);
            cluster.setMcastFrequency(mcastFrequency);
            cluster.setMcastSocketTimeout(mcastSoTimeout);
            if (!this.mbeanServer.isRegistered(clon)) {
                try {
                    this.mbeanServer.registerMBean(cluster, clon);
                }
                catch (Exception e) {
                    logger.log(BasicLevel.ERROR, (Object)("Cannot register tomcat cluster:" + e));
                    return false;
                }
            }
            this.myclusters.put(clusterName, cluster);
        } else {
            int currentMcastPort;
            boolean ok = true;
            String currentMcastAddr = cluster.getMcastAddr();
            if (!currentMcastAddr.equals(mcastAddr)) {
                logger.log(BasicLevel.ERROR, (Object)("Tomcat cluster " + clusterName + " configuration error: found mcastAddr " + mcastAddr + ", got mcastAddr " + currentMcastAddr));
                ok = false;
            }
            if ((currentMcastPort = cluster.getMcastPort()) != mcastPort) {
                logger.log(BasicLevel.ERROR, (Object)("Tomcat cluster " + clusterName + " configuration error: found mcastPort " + mcastPort + ", got mcastPort " + currentMcastPort));
                ok = false;
            }
        }
        return cluster.addTomcatServer(serverName, proxy);
    }

    @Override
    public Collection getClusterList() {
        return this.myclusters.values();
    }

    @Override
    public void getMonitoringInfo() {
    }
}

