/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.loader.locator;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import org.ow2.jonas.lib.loader.locator.Locator;
import org.ow2.util.url.URLUtils;

public class DirLocator
extends Locator {
    private File file = null;

    public DirLocator(URL jar) throws IOException {
        this.file = URLUtils.urlToFile((URL)jar);
        if (!this.file.exists()) {
            throw new IOException("File " + this.file + " does not exists.");
        }
        if (!this.file.isDirectory()) {
            throw new IOException("File " + this.file + " is not a directory.");
        }
    }

    @Override
    public boolean hasFile(String path) {
        File child = new File(this.file, path);
        return child.exists() && child.isFile();
    }

    @Override
    public boolean hasDirectory(String path) {
        File child = new File(this.file, path);
        return child.exists() && child.isDirectory();
    }

    @Override
    public List listContent(String path) {
        File child = new File(this.file, path);
        Vector libs = new Vector();
        if (child.isDirectory()) {
            this.addContent(child, libs);
        }
        return libs;
    }

    private void addContent(File f, List l) {
        File[] childs = f.listFiles();
        if (childs != null) {
            for (int i = 0; i < childs.length; ++i) {
                if (childs[i].isDirectory()) {
                    this.addContent(childs[i], l);
                    continue;
                }
                if (!childs[i].isFile()) continue;
                l.add(childs[i].getPath().substring(this.file.getPath().length()));
            }
        }
    }
}

