/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.work;

import java.io.File;
import java.util.Vector;
import org.ow2.jonas.workcleaner.DeployerLogException;
import org.ow2.jonas.workcleaner.IDeployerLog;
import org.ow2.jonas.workcleaner.LogEntry;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public abstract class AbsDeployerLog<T extends LogEntry>
implements IDeployerLog<T> {
    protected Log logger = LogFactory.getLog(AbsDeployerLog.class);
    protected static final String SEPARATOR_ENTRY = ";";
    protected File logFile;
    protected Vector<T> logEntries = null;

    public AbsDeployerLog(File logFile) throws DeployerLogException {
        this.logger.debug((Object)("logfile=" + logFile.getName()), new Object[0]);
        this.logFile = logFile;
        this.logEntries = new Vector();
        this.loadEntries();
    }

    protected Log getLogger() {
        return this.logger;
    }

    protected abstract void loadEntries() throws DeployerLogException;

    protected abstract void saveEntries() throws DeployerLogException;

    public synchronized Vector<T> getEntries() {
        return this.logEntries;
    }

    public synchronized Vector<T> removeEntry(T entry) throws DeployerLogException {
        if (this.logEntries == null) {
            throw new DeployerLogException("Can not remove a entry, the vector is null");
        }
        if (!this.logEntries.contains(entry)) {
            throw new DeployerLogException("Can not remove entry " + entry + ". There is no such entry");
        }
        this.logEntries.remove(entry);
        this.saveEntries();
        return this.logEntries;
    }

    public abstract Vector<T> addEntry(T var1) throws DeployerLogException;

    public abstract T getEntry(File var1);
}

