/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.extension.loader;

import aQute.lib.osgi.Analyzer;
import aQute.lib.osgi.Builder;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.Verifier;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Bnd {
    private List<String> errors;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wrap(File source, File output) throws Exception {
        Properties properties = new Properties();
        properties.setProperty("DynamicImport-Package", "*");
        this.errors = new ArrayList<String>();
        Analyzer analyzer = new Analyzer();
        try {
            analyzer.setJar(source);
            Jar dot = analyzer.getJar();
            if (properties != null) {
                analyzer.setProperties(properties);
            }
            if (analyzer.getProperty("Import-Package") == null) {
                analyzer.setProperty("Import-Package", "*;resolution:=optional");
            }
            if (analyzer.getProperty("Bundle-SymbolicName") == null) {
                Pattern p = Pattern.compile("(" + Verifier.SYMBOLICNAME.pattern() + ")(-[0-9])?.*\\.jar");
                String base = source.getName();
                Matcher m = p.matcher(base);
                base = "Untitled";
                if (!m.matches()) {
                    throw new IOException("Can not calculate symbolic name of bundle, rename jar to respect pattern <name>(-<version>).jar" + source);
                }
                base = m.group(1);
                analyzer.setProperty("Bundle-SymbolicName", base);
            }
            if (analyzer.getProperty("Export-Package") == null) {
                String export = analyzer.calculateExportsFromContents(dot);
                analyzer.setProperty("Export-Package", export);
            }
            analyzer.mergeManifest(dot.getManifest());
            String version = analyzer.getProperty("Bundle-Version");
            if (version != null) {
                version = Builder.cleanupVersion(version);
                analyzer.setProperty("Bundle-Version", version);
            }
            analyzer.calcManifest();
            Jar jar = analyzer.getJar();
            jar.write(output);
            jar.close();
            this.errors.addAll(analyzer.getErrors());
            boolean bl = analyzer.getErrors().size() == 0;
            return bl;
        }
        finally {
            analyzer.close();
        }
    }

    public List<String> getErrors() {
        return this.errors;
    }
}

