/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.log.jul.internal;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.util.i18n.I18n;
import org.ow2.util.log.Log;
import org.ow2.util.log.jul.internal.JDKConsoleHandler;
import org.ow2.util.log.jul.internal.JDKFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDKLogger
implements Log,
Serializable {
    private static final long serialVersionUID = -3786299204538237422L;
    private String name = null;
    private transient Logger logger = null;
    private transient I18n i18n = null;
    private static boolean handlerSet = false;
    public static final String SET_HANDLER = "easybeans.log.handler";

    public JDKLogger(Class<?> clazz, I18n i18n) {
        this(clazz.getName(), i18n);
    }

    protected JDKLogger(String className, I18n i18n) {
        this.name = className;
        this.i18n = i18n;
        this.logger = this.getLogger();
    }

    protected Object readResolve() throws ObjectStreamException {
        return new JDKLogger(this.name, null);
    }

    private void log(Level level, String msg, Throwable t) {
        Throwable throwable = new Throwable();
        StackTraceElement[] stackTraceElements = throwable.getStackTrace();
        String className = "stack-not-found";
        String methodName = "stack-not-found";
        if (stackTraceElements != null && stackTraceElements.length > 2) {
            StackTraceElement caller = stackTraceElements[2];
            className = caller.getClassName();
            methodName = caller.getMethodName();
        }
        Logger logger = this.getLogger();
        if (t == null) {
            logger.logp(level, className, methodName, msg);
        } else {
            logger.logp(level, className, methodName, msg, t);
        }
    }

    private void replaceConsoleHandlerInParentHandlers(Logger logger) {
        if (logger == null) {
            return;
        }
        Logger parent = logger.getParent();
        if (parent == null) {
            return;
        }
        Handler[] handlers = parent.getHandlers();
        if (handlers != null) {
            for (Handler handler : handlers) {
                if (!(handler instanceof ConsoleHandler)) continue;
                parent.removeHandler(handler);
                JDKConsoleHandler easyBeansHandler = new JDKConsoleHandler();
                easyBeansHandler.setFormatter(new JDKFormatter());
                parent.addHandler(easyBeansHandler);
            }
        }
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger(this.name);
        }
        if (!handlerSet) {
            String prop = System.getProperty(SET_HANDLER, "true");
            if (Boolean.parseBoolean(prop)) {
                this.replaceConsoleHandlerInParentHandlers(this.logger);
            }
            handlerSet = true;
        }
        return this.logger;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.getLogger().isLoggable(Level.FINE);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.getLogger().isLoggable(Level.SEVERE);
    }

    @Override
    public boolean isFatalEnabled() {
        return this.getLogger().isLoggable(Level.SEVERE);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.getLogger().isLoggable(Level.INFO);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.getLogger().isLoggable(Level.FINEST);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.getLogger().isLoggable(Level.WARNING);
    }

    @Override
    public I18n getI18n() {
        return this.i18n;
    }

    @Override
    public void debug(Object message, Object ... args) {
        if (!this.isDebugEnabled()) {
            return;
        }
        String msg = this.getMessage(message, args);
        Throwable t = this.getThrowable(args);
        this.log(Level.FINE, msg, t);
    }

    @Override
    public void error(Object message, Object ... args) {
        String msg = this.getMessage(message, args);
        Throwable t = this.getThrowable(args);
        this.log(Level.SEVERE, msg, t);
    }

    @Override
    public void fatal(Object message, Object ... args) {
        this.error(message, args);
    }

    @Override
    public void info(Object message, Object ... args) {
        if (!this.isInfoEnabled()) {
            return;
        }
        String msg = this.getMessage(message, args);
        Throwable t = this.getThrowable(args);
        this.log(Level.INFO, msg, t);
    }

    @Override
    public void trace(Object message, Object ... args) {
        if (!this.isTraceEnabled()) {
            return;
        }
        String msg = this.getMessage(message, args);
        Throwable t = this.getThrowable(args);
        this.log(Level.FINEST, msg, t);
    }

    @Override
    public void warn(Object message, Object ... args) {
        if (!this.isWarnEnabled()) {
            return;
        }
        String msg = this.getMessage(message, args);
        Throwable t = this.getThrowable(args);
        this.log(Level.WARNING, msg, t);
    }

    private String getMessage(Object message, Object ... args) {
        if (this.i18n != null) {
            return this.i18n.getMessage(String.valueOf(message), args);
        }
        return MessageFormat.format(String.valueOf(message), args);
    }

    private Throwable getThrowable(Object ... args) {
        Object lastArg;
        int size = args.length;
        if (size > 0 && (lastArg = args[size - 1]) instanceof Throwable) {
            return (Throwable)lastArg;
        }
        return null;
    }
}

