/**
* JASMINe
* Copyright (C) 2012 Bull S.A.S.
* Contact: jasmine@ow2.org
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
* USA
*
* --------------------------------------------------------------------------
* $Id$
* --------------------------------------------------------------------------
*/

package org.ow2.jasmine.probe.itests;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;


import org.ow2.jasmine.probe.JasmineProbeException;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;

public class CnfFelixShProcessingIndicatorTest extends AbsProcessingIndicatorTest {

   @BeforeClass
    public void createProbesAndWait()  throws InterruptedException, JasmineProbeException {

       String felixShIP = System.getProperty("osgi.shell.telnet.ip", "localhost");
       String felixShPort = System.getProperty("osgi.shell.telnet.port", "6666");

       logger.info("Felix shell remote on " + felixShIP + ":" + felixShPort);


       ArrayList<String> cmdList = new ArrayList<String>();
       cmdList.add("target-create -t jmx -d url=" + getJmxUrl() + " tst_agent0");
       cmdList.add("target-create -t jmx -d url=service:jmx:rmi:///jndi/rmi://localhost:"+getPortNumber()+"/jrmpconnector_unknown tst_agent_unknown");
       cmdList.add("output-create -t console stdio");
       cmdList.add("output-create -t file -d path="+getTmpDirPath()+"/tst_mbdefault_all_attributes.csv tst_mbdefault_all_attributes");
       cmdList.add("output-create -t file -d path="+getTmpDirPath()+"/tst_mb_aa_01_delta.csv tst_mb_aa_01_delta");
       cmdList.add("output-create -t file -d path="+getTmpDirPath()+"/tst_mb_aa_02_rate.csv tst_mb_aa_02_rate");
       cmdList.add("output-create -t file -d path="+getTmpDirPath()+"/tst_mb_aa_03_slope.csv tst_mb_aa_03_slope");
       cmdList.add("output-create -t file -d path="+getTmpDirPath()+"/tst_mb_aa_04_add.csv tst_mb_aa_04_add");
       cmdList.add("output-create -t file -d path="+getTmpDirPath()+"/tst_mb_aa_04_sub.csv tst_mb_aa_04_sub");
       cmdList.add("output-create -t file -d path="+getTmpDirPath()+"/tst_mb_aa_04_mul.csv tst_mb_aa_04_mul");
       cmdList.add("output-create -t file -d path="+getTmpDirPath()+"/tst_mb_aa_04_div.csv tst_mb_aa_04_div");
       cmdList.add("output-create -t file -d path="+getTmpDirPath()+"/tst_mb_aa_04_percent.csv tst_mb_aa_04_percent");
       cmdList.add("output-create -t file -d path="+getTmpDirPath()+"/tst_mb_aa_04_add_complex.csv tst_mb_aa_04_add_complex");
       cmdList.add("output-create -t file -d path="+getTmpDirPath()+"/tst_mb_aa_04_mul_complex.csv tst_mb_aa_04_mul_complex");
       cmdList.add("output-create -t file -d path="+getTmpDirPath()+"/tst_mb_ab_xx_correlate.csv tst_mb_ab_xx_correlate");
       cmdList.add("output-create -t file -d path="+getTmpDirPath()+"/tst_mb_ac_01_merge.csv tst_mb_ac_01_merge");
       cmdList.add("output-create -t file -d path="+getTmpDirPath()+"/tst_mb_ac_xx_merge_one.csv tst_mb_ac_xx_merge_one");
       cmdList.add("output-create -t file -d path="+getTmpDirPath()+"/tst_mbdefault_target_on_probe.csv tst_mbdefault_target_on_probe");
       cmdList.add("output-create -t file -d path="+getTmpDirPath()+"/tst_mb_aa_04_add_float.csv tst_mb_aa_04_add_float");
       cmdList.add("output-create -t file -d path="+getTmpDirPath()+"/tst_mb_aa_04_sub_float.csv tst_mb_aa_04_sub_float");
       cmdList.add("output-create -t file -d path="+getTmpDirPath()+"/tst_mb_aa_04_mul_float.csv tst_mb_aa_04_mul_float");
       cmdList.add("output-create -t file -d path="+getTmpDirPath()+"/tst_mb_ac_xx_merge_float.csv tst_mb_ac_xx_merge_float");
       cmdList.add("output-create -t file -d path="+getTmpDirPath()+"/tst_mb_aa_05_BUG133_several_use_indicator.csv tst_mb_aa_05_BUG133_several_use_indicator");
       cmdList.add("output-create -t file -d path="+getTmpDirPath()+"/tst_mb_aa_05_BUG145_several_use_indicator.csv tst_mb_aa_05_BUG145_several_use_indicator");
       cmdList.add("output-create -t file -d path="+getTmpDirPath()+"/tst_mb_aa_06_cache_several_use_indicator.csv tst_mb_aa_06_cache_several_use_indicator");
       cmdList.add("output-create -t file -d path="+getTmpDirPath()+"/tst_mb_bb_xx_delta_rate_slope.csv tst_mb_bb_xx_delta_rate_slope");
       cmdList.add("output-create -t file -d path="+getTmpDirPath()+"/tst_df_all_several_use_indicator.csv tst_df_all_several_use_indicator");
       cmdList.add("indicator-create -t constant -d type=int -d value=1 tst_C_1");
       cmdList.add("indicator-create -t constant -d type=int -d value=2 tst_C_2");
       cmdList.add("indicator-create -t constant -d type=int -d value=15 tst_C_15");
       cmdList.add("indicator-create -t jmx -d target=tst_agent0 -d mbean=*:type=Basic,category=default,name=mbdefault -d attr=all -d test=true tst_mbdefault_all_attributes");
       cmdList.add("indicator-create -t jmx -d target=tst_agent0 -d mbean=*:type=Basic,category=aa,name=mb_aa_01 -d attr=CIncrement -d test=true tst_mb_aa_01_CIncrement");
       cmdList.add("indicator-create -t jmx -d target=tst_agent0 -d mbean=*:type=Basic,category=aa,name=mb_aa_01 -d attr=VIncremented -d test=true tst_mb_aa_01_VIncremented");
       cmdList.add("indicator-create -t derived -d op=delta -i tst_mb_aa_01_VIncremented tst_mb_aa_01_delta_VIncremented");
       cmdList.add("indicator-create -t jmx -d target=tst_agent0 -d mbean=*:type=Basic,category=aa,name=mb_aa_02 -d attr=CIncrement -d test=true tst_mb_aa_02_CIncrement");
       cmdList.add("indicator-create -t jmx -d target=tst_agent0 -d mbean=*:type=Basic,category=aa,name=mb_aa_02 -d attr=VIncremented -d test=true tst_mb_aa_02_VIncremented");
       cmdList.add("indicator-create -t derived -d op=rate -i tst_mb_aa_02_VIncremented tst_mb_aa_02_rate_VIncremented");
       cmdList.add("indicator-create -t jmx -d target=tst_agent0 -d mbean=*:type=Basic,category=aa,name=mb_aa_03 -d attr=CIncrement,CStep -d test=true tst_mb_aa_03");
       cmdList.add("indicator-create -t jmx -d target=tst_agent0 -d mbean=*:type=Basic,category=aa,name=mb_aa_03 -d attr=VIncremented -d test=true tst_mb_aa_03_VIncremented");
       cmdList.add("indicator-create -t jmx -d target=tst_agent0 -d mbean=*:type=Basic,category=aa,name=mb_aa_03 -d attr=VSinusoidal -d test=true tst_mb_aa_03_VSinusoidal");
       cmdList.add("indicator-create -t slope -i tst_mb_aa_03_VIncremented -i tst_mb_aa_03_VSinusoidal tst_mb_aa_03_slope_VIncremented_VSinusoidal");
       cmdList.add("indicator-create -t jmx -d target=tst_agent0 -d mbean=*:type=Basic,category=aa,name=mb_aa_04 -d attr=CInt1 -d test=true tst_mb_aa_04_CInt1");
       cmdList.add("indicator-create -t jmx -d target=tst_agent0 -d mbean=*:type=Basic,category=aa,name=mb_aa_04 -d attr=CInt2 -d test=true tst_mb_aa_04_CInt2");
       cmdList.add("indicator-create -t correlate -d op=add -i tst_mb_aa_04_CInt1 -i tst_mb_aa_04_CInt2 tst_mb_aa_04_add_CInt1_CInt2");
       cmdList.add("indicator-create -t correlate -d op=sub -i tst_mb_aa_04_CInt1 -i tst_mb_aa_04_CInt2 tst_mb_aa_04_sub_CInt1_CInt2");
       cmdList.add("indicator-create -t correlate -d op=mul -i tst_mb_aa_04_CInt1 -i tst_mb_aa_04_CInt2 tst_mb_aa_04_mul_CInt1_CInt2");
       cmdList.add("indicator-create -t correlate -d op=div -i tst_mb_aa_04_CInt1 -i tst_mb_aa_04_CInt2 tst_mb_aa_04_div_CInt1_CInt2");
       cmdList.add("indicator-create -t correlate -d op=percent -i tst_mb_aa_04_CInt1 -i tst_mb_aa_04_CInt2 tst_mb_aa_04_percent_CInt1_CInt2");
       cmdList.add("indicator-create -t correlate -d op=add -i tst_mb_aa_04_CInt1 -i tst_mb_aa_04_CInt2 -i tst_mb_aa_04_CInt1 -i tst_C_15 tst_mb_aa_04_add_CInt1_CInt2_CInt1_15");
       cmdList.add("indicator-create -t correlate -d op=mul -i tst_mb_aa_04_CInt1 -i tst_mb_aa_04_CInt2 -i tst_mb_aa_04_CInt1 -i tst_C_2 tst_mb_aa_04_mul_CInt1_CInt2_CInt1_2");
       cmdList.add("indicator-create -t jmx -d target=tst_agent0 -d mbean=*:type=Basic,category=ab,name=mb_ab_01 -d attr=VIncremented -d test=true tst_mb_ab_01_VIncremented");
       cmdList.add("indicator-create -t jmx -d target=tst_agent0 -d mbean=*:type=Basic,category=ab,name=mb_ab_02 -d attr=VIncremented -d test=true tst_mb_ab_02_VIncremented");
       cmdList.add("indicator-create -t correlate -d op=add -i tst_mb_ab_01_VIncremented -i tst_mb_ab_02_VIncremented tst_mb_ab_xx_add_VIncremented");
       cmdList.add("indicator-create -t jmx -d target=tst_agent0 -d mbean=*:type=Basic,category=ab,name=mb_ab_01 -d attr=CInt1 -d test=true tst_mb_ab_01_CInt1");
       cmdList.add("indicator-create -t jmx -d target=tst_agent0 -d mbean=*:type=Basic,category=ab,name=mb_ab_01 -d attr=CInt2 -d test=true tst_mb_ab_01_CInt2");
       cmdList.add("indicator-create -t jmx -d target=tst_agent0 -d mbean=*:type=Basic,category=ab,name=mb_ab_02 -d attr=CInt1 -d test=true tst_mb_ab_02_CInt1");
       cmdList.add("indicator-create -t jmx -d target=tst_agent0 -d mbean=*:type=Basic,category=ab,name=mb_ab_02 -d attr=CInt2 -d test=true tst_mb_ab_02_CInt2");
       cmdList.add("indicator-create -t correlate -d op=sub -i tst_mb_ab_01_CInt1 -i tst_mb_ab_02_CInt1 tst_mb_ab_xx_sub_CInt1");
       cmdList.add("indicator-create -t correlate -d op=mul -i tst_mb_ab_01_CInt1 -i tst_mb_ab_02_CInt1 tst_mb_ab_xx_mul_CInt1");
       cmdList.add("indicator-create -t correlate -d op=div -i tst_mb_ab_01_CInt1 -i tst_mb_ab_02_CInt1 tst_mb_ab_xx_div_CInt1");
       cmdList.add("indicator-create -t correlate -d op=percent -i tst_mb_ab_01_CInt1 -i tst_mb_ab_02_CInt1 tst_mb_ab_xx_percent_CInt1");
       cmdList.add("indicator-create -t jmx -d target=tst_agent0 -d mbean=*:type=Basic,category=ac,name=mb_ac_01 -d attr=CInt1,CInt2 -d test=true tst_mb_ac_01");
       cmdList.add("indicator-create -t merge -d op=sum -i tst_mb_ac_01 tst_mb_ac_01_sum");
       cmdList.add("indicator-create -t merge -d op=average -i tst_mb_ac_01 tst_mb_ac_01_average");
       cmdList.add("indicator-create -t merge -d op=min -i tst_mb_ac_01 tst_mb_ac_01_min");
       cmdList.add("indicator-create -t merge -d op=max -i tst_mb_ac_01 tst_mb_ac_01_max");
       cmdList.add("indicator-create -t jmx -d target=tst_agent0 -d mbean=*:type=Basic,category=ac,* -d attr=CInt1 -d test=true tst_mb_ac_xx_CInt1");
       cmdList.add("indicator-create -t merge -d op=sum -i tst_mb_ac_xx_CInt1 tst_mb_ac_xx_sum_CInt1");
       cmdList.add("indicator-create -t merge -d op=average -i tst_mb_ac_xx_CInt1 tst_mb_ac_xx_average_CInt1");
       cmdList.add("indicator-create -t merge -d op=min -i tst_mb_ac_xx_CInt1 tst_mb_ac_xx_min_CInt1");
       cmdList.add("indicator-create -t merge -d op=max -i tst_mb_ac_xx_CInt1 tst_mb_ac_xx_max_CInt1");
       cmdList.add("indicator-create -t jmx -d target=tst_agent_unknown -d mbean=*:type=Basic,category=default,name=mbdefault -d attr=CInt1,CFloat1 -d test=true tst_mbdefault_target_unknown");
       cmdList.add("indicator-create -t jmx -d target=tst_agent0 -d mbean=*:type=Basic,category=aa,name=mb_aa_04 -d attr=CFloat1 -d test=true tst_mb_aa_04_CFloat1");
       cmdList.add("indicator-create -t jmx -d target=tst_agent0 -d mbean=*:type=Basic,category=aa,name=mb_aa_04 -d attr=CFloat2 -d test=true tst_mb_aa_04_CFloat2");
       cmdList.add("indicator-create -t correlate -d op=add -i tst_mb_aa_04_CFloat1 -i tst_mb_aa_04_CFloat2 tst_mb_aa_04_add_CFloat1_CFloat2");
       cmdList.add("indicator-create -t correlate -d op=sub -i tst_mb_aa_04_CFloat1 -i tst_mb_aa_04_CFloat2 tst_mb_aa_04_sub_CFloat1_CFloat2");
       cmdList.add("indicator-create -t correlate -d op=mul -i tst_mb_aa_04_CFloat1 -i tst_mb_aa_04_CFloat2 tst_mb_aa_04_mul_CFloat1_CFloat2");
       cmdList.add("indicator-create -t jmx -d target=tst_agent0 -d mbean=*:type=Basic,category=ac,* -d attr=CFloat1,CFloat2 -d test=true tst_mb_ac_xx_CFloatX");
       cmdList.add("indicator-create -t merge -d op=sum -i tst_mb_ac_xx_CFloatX tst_mb_ac_xx_sum_CFloatX");
       cmdList.add("indicator-create -t merge -d op=average -i tst_mb_ac_xx_CFloatX tst_mb_ac_xx_average_CFloatX");
       cmdList.add("indicator-create -t merge -d op=max -i tst_mb_ac_xx_CFloatX tst_mb_ac_xx_max_CFloatX");
       cmdList.add("indicator-create -t merge -d op=min -i tst_mb_ac_xx_CFloatX tst_mb_ac_xx_min_CFloatX");
       cmdList.add("indicator-create -t jmx -d target=tst_agent0 -d mbean=*:type=Basic,category=aa,name=mb_aa_05 -d attr=CInt1 -d test=true tst_mb_aa_05_CInt1");
       cmdList.add("indicator-create -t jmx -d target=tst_agent0 -d mbean=*:type=Basic,category=aa,name=mb_aa_05 -d attr=CInt2 -d test=true tst_mb_aa_05_CInt2");
       cmdList.add("indicator-create -t correlate -d op=add -i tst_mb_aa_05_CInt1 -i tst_C_1 tst_mb_aa_05_add_CInt1_1");
       cmdList.add("indicator-create -t correlate -d op=sub -i tst_mb_aa_05_CInt1 -i tst_C_1 tst_mb_aa_05_sub_CInt1_1");
       cmdList.add("indicator-create -t derived -d op=delta -i tst_mb_aa_05_CInt1 tst_mb_aa_05_delta_CInt1");
       cmdList.add("indicator-create -t derived -d op=rate -i tst_mb_aa_05_CInt1 tst_mb_aa_05_rate_CInt1");
       cmdList.add("indicator-create -t correlate -d op=add -i tst_mb_aa_05_add_CInt1_1 -i tst_mb_aa_05_sub_CInt1_1 tst_mb_aa_05_total");
       cmdList.add("indicator-create -t jmx -d target=tst_agent0 -d mbean=*:type=Basic,category=aa,name=mb_aa_06 -d attr=CIncrement -d test=true tst_mb_aa_06_CIncrement");
       cmdList.add("indicator-create -t jmx -d target=tst_agent0 -d mbean=*:type=Basic,category=aa,name=mb_aa_06 -d attr=VIncremented -d test=true tst_mb_aa_06_VIncremented");
       cmdList.add("indicator-create -t derived -d op=delta -i tst_mb_aa_06_VIncremented tst_mb_aa_06_delta_VIncremented");
       cmdList.add("indicator-create -t jmx -d target=tst_agent0 -d mbean=*:type=Basic,category=bb,* -d attr=CIncrement -d test=true tst_mb_bb_xx_CIncrement");
       cmdList.add("indicator-create -t jmx -d target=tst_agent0 -d mbean=*:type=Basic,category=bb,* -d attr=CAmplitude -d test=true tst_mb_bb_xx_CAmplitude");
       cmdList.add("indicator-create -t jmx -d target=tst_agent0 -d mbean=*:type=Basic,category=bb,* -d attr=CStep -d test=true tst_mb_bb_xx_CStep");
       cmdList.add("indicator-create -t jmx -d target=tst_agent0 -d mbean=*:type=Basic,category=bb,* -d attr=VPeriod -d test=true tst_mb_bb_xx_VPeriod");
       cmdList.add("indicator-create -t jmx -d target=tst_agent0 -d mbean=*:type=Basic,category=bb,* -d attr=VIncremented -d test=true tst_mb_bb_xx_VIncremented");
       cmdList.add("indicator-create -t jmx -d target=tst_agent0 -d mbean=*:type=Basic,category=bb,* -d attr=VSinusoidal -d test=true tst_mb_bb_xx_VSinusoidal");
       cmdList.add("indicator-create -t derived -d op=delta -i tst_mb_bb_xx_VIncremented tst_mb_bb_xx_delta_VIncremented");
       cmdList.add("indicator-create -t derived -d op=rate -i tst_mb_bb_xx_VIncremented tst_mb_bb_xx_rate_VIncremented");
       cmdList.add("indicator-create -t derived -d op=delta -i tst_mb_bb_xx_VSinusoidal tst_mb_bb_xx_delta_VSinusoidal");
       cmdList.add("indicator-create -t derived -d op=rate -i tst_mb_bb_xx_VSinusoidal tst_mb_bb_xx_rate_VSinusoidal");
       cmdList.add("indicator-create -t slope -i tst_mb_bb_xx_VIncremented -i tst_mb_bb_xx_VSinusoidal tst_mb_bb_xx_VIncremented_per_VSinusoidal");
       cmdList.add("indicator-create -t slope -i tst_mb_bb_xx_CAmplitude -i tst_mb_bb_xx_CStep tst_mb_bb_xx_CAmplitude_per_CStep");
       cmdList.add("indicator-create -t df tst_df_all");
       cmdList.add("indicator-create -t merge -d op=min -i tst_df_all tst_df_all_min");
       cmdList.add("indicator-create -t merge -d op=max -i tst_df_all tst_df_all_max");
       cmdList.add("indicator-create -t correlate -d op=add -i tst_df_all_min -i tst_df_all_max tst_df_all_add_min_max");
       cmdList.add("indicator-create -t correlate -d op=mul -i tst_df_all_min -i tst_df_all_max tst_df_all_mul_min_max");
       cmdList.add("probe-create -s -p 3 -o tst_mbdefault_all_attributes -i tst_mbdefault_all_attributes ptst_mbdefault_all_attributes");
       cmdList.add("probe-create -s -p 3 -o tst_mb_aa_01_delta -i tst_mb_aa_01_CIncrement -i tst_mb_aa_01_delta_VIncremented ptst_mb_aa_01_delta");
       cmdList.add("probe-create -s -p 3 -o tst_mb_aa_02_rate -i tst_mb_aa_02_CIncrement -i tst_mb_aa_02_rate_VIncremented ptst_mb_aa_02");
       cmdList.add("probe-create -s -p 8 -o tst_mb_aa_03_slope -i tst_mb_aa_03 -i tst_mb_aa_03_slope_VIncremented_VSinusoidal ptst_mb_aa_03_slope");
       cmdList.add("probe-create -s -p 3 -o tst_mb_aa_04_add -i tst_mb_aa_04_CInt1 -i tst_mb_aa_04_CInt2 -i tst_mb_aa_04_add_CInt1_CInt2 ptst_mb_aa_04_add_CInt1_CInt2");
       cmdList.add("probe-create -s -p 3 -o tst_mb_aa_04_sub -i tst_mb_aa_04_CInt1 -i tst_mb_aa_04_CInt2 -i tst_mb_aa_04_sub_CInt1_CInt2 ptst_mb_aa_04_sub_CInt1_CInt2");
       cmdList.add("probe-create -s -p 3 -o tst_mb_aa_04_mul -i tst_mb_aa_04_CInt1 -i tst_mb_aa_04_CInt2 -i tst_mb_aa_04_mul_CInt1_CInt2 ptst_mb_aa_04_mul_CInt1_CInt2");
       cmdList.add("probe-create -s -p 3 -o tst_mb_aa_04_div -i tst_mb_aa_04_CInt1 -i tst_mb_aa_04_CInt2 -i tst_mb_aa_04_div_CInt1_CInt2 ptst_mb_aa_04_div_CInt1_CInt2");
       cmdList.add("probe-create -s -p 3 -o tst_mb_aa_04_percent -i tst_mb_aa_04_CInt1 -i tst_mb_aa_04_CInt2 -i tst_mb_aa_04_percent_CInt1_CInt2 ptst_mb_aa_04_percent_CInt1_CInt2");
       cmdList.add("probe-create -s -p 3 -o tst_mb_aa_04_add_complex -i tst_mb_aa_04_CInt1 -i tst_mb_aa_04_CInt2 -i tst_mb_aa_04_add_CInt1_CInt2_CInt1_15 ptst_mb_aa_04_add_complex");
       cmdList.add("probe-create -s -p 3 -o tst_mb_aa_04_mul_complex -i tst_mb_aa_04_CInt1 -i tst_mb_aa_04_CInt2 -i tst_mb_aa_04_mul_CInt1_CInt2_CInt1_2 ptst_mb_aa_04_mul_complex");
       cmdList.add("probe-create -s -p 3 -o tst_mb_ab_xx_correlate -i tst_mb_ab_xx_add_VIncremented ptst_mb_ab_xx_add_VIncremented");
       cmdList.add("probe-create -s -p 3 -o tst_mb_ab_xx_correlate -i tst_mb_ab_01_CInt1 -i tst_mb_ab_02_CInt1 ptst_mb_ab_xx_CInt1");
       cmdList.add("probe-create -s -p 3 -o tst_mb_ab_xx_correlate -i tst_mb_ab_xx_sub_CInt1 ptst_mb_ab_xx_sub_CInt1");
       cmdList.add("probe-create -s -p 3 -o tst_mb_ab_xx_correlate -i tst_mb_ab_xx_mul_CInt1 ptst_mb_ab_xx_mul_CInt1");
       cmdList.add("probe-create -s -p 3 -o tst_mb_ab_xx_correlate -i tst_mb_ab_xx_div_CInt1 ptst_mb_ab_xx_div_CInt1");
       cmdList.add("probe-create -s -p 3 -o tst_mb_ab_xx_correlate -i tst_mb_ab_xx_percent_CInt1 ptst_mb_ab_xx_percent_CInt1");
       cmdList.add("probe-create -s -p 3 -o tst_mb_ac_01_merge -i tst_mb_ac_01 ptst_mb_ac_01");
       cmdList.add("probe-create -s -p 3 -o tst_mb_ac_01_merge -i tst_mb_ac_01_sum ptst_mb_ac_01_sum");
       cmdList.add("probe-create -s -p 3 -o tst_mb_ac_01_merge -i tst_mb_ac_01_min ptst_mb_ac_01_min");
       cmdList.add("probe-create -s -p 3 -o tst_mb_ac_01_merge -i tst_mb_ac_01_max ptst_mb_ac_01_max");
       cmdList.add("probe-create -s -p 3 -o tst_mb_ac_xx_merge_one -i tst_mb_ac_xx_CInt1 ptst_mb_ac_xx_CInt1");
       cmdList.add("probe-create -s -p 3 -o tst_mb_ac_xx_merge_one -i tst_mb_ac_xx_sum_CInt1 ptst_mb_ac_xx_sum_CInt1");
       cmdList.add("probe-create -s -p 3 -o tst_mb_ac_xx_merge_one -i tst_mb_ac_xx_average_CInt1 ptst_mb_ac_xx_average_CInt1");
       cmdList.add("probe-create -s -p 3 -o tst_mb_ac_xx_merge_one -i tst_mb_ac_xx_min_CInt1 ptst_mb_ac_xx_min_CInt1");
       cmdList.add("probe-create -s -p 3 -o tst_mb_ac_xx_merge_one -i tst_mb_ac_xx_max_CInt1 ptst_mb_ac_xx_max_CInt1");
       cmdList.add("probe-create -s -p 3 -o tst_mbdefault_target_on_probe -t tst_agent0 -i tst_mbdefault_target_unknown ptst_mbdefault_target_on_probe");
       cmdList.add("probe-create -s -p 3 -o tst_mb_aa_04_add_float -i tst_mb_aa_04_CFloat1 -i tst_mb_aa_04_CFloat2 -i tst_mb_aa_04_add_CFloat1_CFloat2 ptst_mb_aa_04_add_CFloat1_CFloat2");
       cmdList.add("probe-create -s -p 3 -o tst_mb_aa_04_sub_float -i tst_mb_aa_04_CFloat1 -i tst_mb_aa_04_CFloat2 -i tst_mb_aa_04_sub_CFloat1_CFloat2 ptst_mb_aa_04_sub_CFloat1_CFloat2");
       cmdList.add("probe-create -s -p 3 -o tst_mb_aa_04_mul_float -i tst_mb_aa_04_CFloat1 -i tst_mb_aa_04_CFloat2 -i tst_mb_aa_04_mul_CFloat1_CFloat2 ptst_mb_aa_04_mul_CFloat1_CFloat2");
       cmdList.add("probe-create -s -p 3 -o tst_mb_ac_xx_merge_float -i tst_mb_ac_xx_CFloatX -i tst_mb_ac_xx_sum_CFloatX -i tst_mb_ac_xx_average_CFloatX -i tst_mb_ac_xx_max_CFloatX -i tst_mb_ac_xx_min_CFloatX ptst_mb_ac_xx_aggreagte_CFloatX");
       cmdList.add("probe-create -s -p 3 -o tst_mb_aa_05_BUG133_several_use_indicator -i tst_mb_aa_05_CInt1 -i tst_mb_aa_05_CInt2 -i tst_mb_aa_05_add_CInt1_1 -i tst_mb_aa_05_sub_CInt1_1 -i tst_mb_aa_05_delta_CInt1 -i tst_mb_aa_05_rate_CInt1 ptst_mb_aa_05_BUG133_several_use_indicator");
       cmdList.add("probe-create -s -p 3 -o tst_mb_aa_05_BUG145_several_use_indicator -i tst_mb_aa_05_CInt1 -i tst_mb_aa_05_add_CInt1_1 -i tst_mb_aa_05_sub_CInt1_1 -i tst_mb_aa_05_total ptst_mb_aa_05_BUG145_several_use_indicator");
       cmdList.add("probe-create -s -p 3 -o tst_mb_aa_06_cache_several_use_indicator -i tst_mb_aa_06_CIncrement -i tst_mb_aa_06_VIncremented -i tst_mb_aa_06_VIncremented -i tst_mb_aa_06_delta_VIncremented -i tst_mb_aa_06_delta_VIncremented ptst_mb_aa_06_cache_several_use_indicator");
       cmdList.add("probe-create -s -p 3 -o tst_mb_bb_xx_delta_rate_slope -i tst_mb_bb_xx_CIncrement -i tst_mb_bb_xx_CAmplitude -i tst_mb_bb_xx_CStep -i tst_mb_bb_xx_VPeriod -i tst_mb_bb_xx_VIncremented -i tst_mb_bb_xx_VSinusoidal -i tst_mb_bb_xx_delta_VIncremented -i tst_mb_bb_xx_rate_VIncremented -i tst_mb_bb_xx_delta_VSinusoidal -i tst_mb_bb_xx_rate_VSinusoidal ptst_mb_bb_xx_delta_rate_slope");
       cmdList.add("probe-create -s -p 3 -o tst_df_all_several_use_indicator -i tst_df_all -i tst_df_all_min -i tst_df_all_max -i tst_df_all_add_min_max -i tst_df_all_mul_min_max ptst_df_all_several_use_indicator");
       cmdList.add("target-list");
       cmdList.add("output-list");
       cmdList.add("indicator-list");
       cmdList.add("probe-list");

       Socket socketFelixSh = null;
       PrintWriter sOut = null;

       try {

           socketFelixSh = new Socket(felixShIP, Integer.parseInt(felixShPort));
           sOut = new PrintWriter(socketFelixSh.getOutputStream(), true);

           for(String cmd: cmdList) {
               logger.info("-> " + cmd);
               sOut.println(cmd);
               // TODO: Some tests randomly fail if there is not this following wait.
               // To be studied ...
               Thread.sleep(300);
           }

       } catch (IOException ioe) {
           Assert.fail("Error when creating outputs/indicators/probes", ioe);

       } finally {
           try {
               if (sOut  != null) {
                   sOut.close();
               }
               if (socketFelixSh != null) {
                   socketFelixSh.close();
               }
           } catch (IOException ioe) {
               // ignore
           }
       }

       logger.info("The indicators/probes have been probably successfully created via Felix Shell");

       // Wait few mn to get the time to do some collects .... and than stop all the probes
       logger.info("Wait " + WAIT_COLLECTS_IN_SEC + " sec to get time to do some collects ...");
       Thread.sleep(WAIT_COLLECTS_IN_SEC*1000);
       getProxyMXBean().stopAllProbes();

   }

}
