package org.ow2.jasmine.probe.outers;

/**
 * MBean interface for JasmineProbe Output monitoring.
 * The monitoring is based on the outer object (JOuter instance) associated to the output.
 * @author danesa
 *
 */
public interface JOuterMBean {

    /**
     * @return the name of the output
     */
    String getOutputName();
    /**
     * @return the output type
     */
    String getOutputType();
    /**
     * @return the address used by the outer to publish results
     */
    String getPublishLocation();
    /**
     * @return the size of the internal queue used to cache results
     */
    int getQueueSize();
    /**
     * @return the maximum size of the queue
     */
    int getMaxQueueSize();
    /**
     * @return the number of elements inserted in the queue
     */
    int getNbInserted();
    /**
     * @return the number of elements rejected when trying to insert in the queue
     */
    int getNbRejected();
    /**
     * @return the number of elements retrieved from the queue in order to be published
     */
    int getNbRetrieved();

    void resetMaxQueueSize();

    void resetNbInserted();

    void resetNbRejected();

    void resetNbRetrieved();

}
