/**
 * JASMINe
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */
package org.ow2.jasmine.probe.util;

public class MetaData {

    /**
     * Keys for different metadata (or properties) that characterize
     * JasmineProbe results.
     */
    public final static String SERVER = "server";
    public final static String DOMAIN = "domain";
    public final static String MBEAN = "mbean";
    public final static String URL = "url";

    // ----------------------------------------------------------
    // predefined values for metadata
    // ----------------------------------------------------------
    /**
     * Can't say which management domain is, indicator's value may be a result of combining values of indicators having
     * different domains.
     */
    public final static String MISC_DOMAIN = "misc";

    /**
     * Can't say which server is, indicator's value may be a result of combining values of indicators having
     * different servers.
     */
    public final static String MISC_SERVER = "misc";


    /**
     * Can't say which MBean it is.
     */
    public final static String MISC_MBEAN = "misc:type=misc";

    /**
     * Can't say which MBean is, indicator's value may be a result of combining values of indicators corresponding to
     * different MBeans.
     */
    public final static String MISC_CORRELATE_MBEAN = "misc:type=correlate";
}
