/**
 * JASMINe
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe.rest;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

/**
 * Root resource class for indicator types management.
 * @author danesa
 *
 */
@Path("/indicatorType")
public interface IndicatorTypes {
    /**
     * Process HTTP GET with URI /indicatorType
     * @return response containing the available indicator types
     */
    @GET
    @Produces(MediaType.APPLICATION_XML)
    Response getIndicatorTypes();

    /**
     * Process HTTP GET with URI /indicatorType/{type}/props
     * @param type an indicator type
     * @return describes the properties that need to be defined for an indicator of the given type
     */
    @GET
    @Path("/{type}/props")
    @Produces(MediaType.APPLICATION_XML)
    Response getIndicatorTypeProps(@PathParam("type") String type);

    /**
     * Process HTTP GET with URI /indicatorType/{type}/info
     * @param type an indicator type
     * @return provides all the usage information for an indicator of the given type
     */
    @GET
    @Path("/{type}/info")
    @Produces(MediaType.APPLICATION_XML)
    Response getIndicatorTypeInfo(@PathParam("type") String type);
}

