/**
 * JASMINe
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe.rest;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

import org.ow2.jasmine.probe.api.generated.TargetBaseType;

/**
 * Root resource class for targets management.
 * Contains methods to treat HTTP requests on "target" resources.
 * @author danesa
 *
 */
@Path("/target")
public interface Targets {

    public final String RESOURCE_NAME = "target";

    /**
     * Process HTTP GET requests.
     * Possible URIs are:
     *  /target that corresponds to 'target-list' command
     * or
     * /target?verbose="true" that corresponds to 'target-list -v' command
     * @return response containing the existent targets
     */
    @GET
    @Produces(MediaType.APPLICATION_XML)
    Response getTargets(@DefaultValue("false") @QueryParam("verbose") boolean verbose
            , @Context UriInfo ui);


    /**
     * Process HTTP GET requests having /target/{name} URI
     * Correspond to target-list -n name
     * @param name target name
     * @param type
     * @return response
     */
    @GET
    @Path("/{name}")
    @Produces(MediaType.APPLICATION_XML)
    Response getTarget(@PathParam("name") String name, @Context UriInfo ui);

    /**
     * Process HTTP POST requests having /target URI and new target definition in its body.
     * Corresponds to target-create command
     * @param targetDef new target definition
     * @return
     */
    @POST
    @Consumes(MediaType.APPLICATION_XML)
    @Produces(MediaType.APPLICATION_XML)
    Response createTarget(TargetBaseType targetDef);

    /**
     * Process HTTP DELETE requests having /target/{name} URI
     * Corresponds to target-remove name
     * @param name the name of the target to remove
     */
    @DELETE
    @Path("/{name}")
    @Produces(MediaType.APPLICATION_XML)
    Response deleteTarget(@PathParam("name") String name);
}
