/**
 * JASMINe
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 */
package org.ow2.jasmine.probe.collectors.linux;

public interface LinuxResourceCollector {

    /**
     * Returns the list of parameter ids
     */
    int[] getParamsIds();

    /**
     * Returns the list of available parameters for the given resource type, in a human readable format.
     */
    String[] getParamsNames();

    /**
     * Get a parameter identifier given its name.
     * @param paramName the resource name
     * @return the resource id
     * @throws NoSuchLinuxResourceException if the parameter name is not supported for this resource type
     */
    int getParamId(String paramName) throws NoSuchLinuxResourceException;
    /**
     * Get a parameter name given its identifier.
     * @param paramId the parameter id
     * @return the parameter name
     * @throws NoSuchLinuxResourceException if the parameter id does not exist
     */
    String getParamName(int paramId) throws NoSuchLinuxResourceException;

    /**
     * Collects a list of parameters given their identifier.
     * @param paramIds ids of the parameters to be collected
     * @return collected values as an array of longs
     * @throws NoSuchLinuxResourceException if a given id is not valid
     * @throws LinuxCollectingException if an error occurs during collecting
     */
    long[] getValue(int[] paramIds) throws
          NoSuchLinuxResourceException, LinuxCollectingException;

}
